module KB.Text.Shape.FFI.Enums.FeatureTag where

import Prelude hiding (id, error)

import Foreign

#include "kb_text_shape.h"

newtype FeatureTag = FeatureTag Word32
  deriving (Eq, Ord, Show)
  deriving newtype (Storable)

pattern FEATURE_TAG_UNREGISTERED :: FeatureTag
pattern FEATURE_TAG_UNREGISTERED = FeatureTag 0

-- | Isolated Forms
pattern FEATURE_TAG_isol :: FeatureTag
pattern FEATURE_TAG_isol = FeatureTag (#const KBTS_FEATURE_TAG_isol)

-- | Terminal Forms
pattern FEATURE_TAG_fina :: FeatureTag
pattern FEATURE_TAG_fina = FeatureTag (#const KBTS_FEATURE_TAG_fina)

-- | Terminal Forms #2
pattern FEATURE_TAG_fin2 :: FeatureTag
pattern FEATURE_TAG_fin2 = FeatureTag (#const KBTS_FEATURE_TAG_fin2)

-- | Terminal Forms #3
pattern FEATURE_TAG_fin3 :: FeatureTag
pattern FEATURE_TAG_fin3 = FeatureTag (#const KBTS_FEATURE_TAG_fin3)

-- | Medial Forms
pattern FEATURE_TAG_medi :: FeatureTag
pattern FEATURE_TAG_medi = FeatureTag (#const KBTS_FEATURE_TAG_medi)

-- | Medial Forms #2
pattern FEATURE_TAG_med2 :: FeatureTag
pattern FEATURE_TAG_med2 = FeatureTag (#const KBTS_FEATURE_TAG_med2)

-- | Initial Forms
pattern FEATURE_TAG_init :: FeatureTag
pattern FEATURE_TAG_init = FeatureTag (#const KBTS_FEATURE_TAG_init)

-- | Leading Jamo Forms
pattern FEATURE_TAG_ljmo :: FeatureTag
pattern FEATURE_TAG_ljmo = FeatureTag (#const KBTS_FEATURE_TAG_ljmo)

-- | Vowel Jamo Forms
pattern FEATURE_TAG_vjmo :: FeatureTag
pattern FEATURE_TAG_vjmo = FeatureTag (#const KBTS_FEATURE_TAG_vjmo)

-- | Trailing Jamo Forms
pattern FEATURE_TAG_tjmo :: FeatureTag
pattern FEATURE_TAG_tjmo = FeatureTag (#const KBTS_FEATURE_TAG_tjmo)

-- | Reph Form
pattern FEATURE_TAG_rphf :: FeatureTag
pattern FEATURE_TAG_rphf = FeatureTag (#const KBTS_FEATURE_TAG_rphf)

-- | Below-base Forms
pattern FEATURE_TAG_blwf :: FeatureTag
pattern FEATURE_TAG_blwf = FeatureTag (#const KBTS_FEATURE_TAG_blwf)

-- | Half Forms
pattern FEATURE_TAG_half :: FeatureTag
pattern FEATURE_TAG_half = FeatureTag (#const KBTS_FEATURE_TAG_half)

-- | Post-base Forms
pattern FEATURE_TAG_pstf :: FeatureTag
pattern FEATURE_TAG_pstf = FeatureTag (#const KBTS_FEATURE_TAG_pstf)

-- | Above-base Forms
pattern FEATURE_TAG_abvf :: FeatureTag
pattern FEATURE_TAG_abvf = FeatureTag (#const KBTS_FEATURE_TAG_abvf)

-- | Pre-base Forms
pattern FEATURE_TAG_pref :: FeatureTag
pattern FEATURE_TAG_pref = FeatureTag (#const KBTS_FEATURE_TAG_pref)

-- | Numerators
pattern FEATURE_TAG_numr :: FeatureTag
pattern FEATURE_TAG_numr = FeatureTag (#const KBTS_FEATURE_TAG_numr)

-- | Fractions
pattern FEATURE_TAG_frac :: FeatureTag
pattern FEATURE_TAG_frac = FeatureTag (#const KBTS_FEATURE_TAG_frac)

-- | Denominators
pattern FEATURE_TAG_dnom :: FeatureTag
pattern FEATURE_TAG_dnom = FeatureTag (#const KBTS_FEATURE_TAG_dnom)

-- | Conjunct Form After Ro
pattern FEATURE_TAG_cfar :: FeatureTag
pattern FEATURE_TAG_cfar = FeatureTag (#const KBTS_FEATURE_TAG_cfar)

-- | Access All Alternates
pattern FEATURE_TAG_aalt :: FeatureTag
pattern FEATURE_TAG_aalt = FeatureTag (#const KBTS_FEATURE_TAG_aalt)

-- | Above-base Mark Positioning
pattern FEATURE_TAG_abvm :: FeatureTag
pattern FEATURE_TAG_abvm = FeatureTag (#const KBTS_FEATURE_TAG_abvm)

-- | Above-base Substitutions
pattern FEATURE_TAG_abvs :: FeatureTag
pattern FEATURE_TAG_abvs = FeatureTag (#const KBTS_FEATURE_TAG_abvs)

-- | Alternative Fractions
pattern FEATURE_TAG_afrc :: FeatureTag
pattern FEATURE_TAG_afrc = FeatureTag (#const KBTS_FEATURE_TAG_afrc)

-- | Akhand
pattern FEATURE_TAG_akhn :: FeatureTag
pattern FEATURE_TAG_akhn = FeatureTag (#const KBTS_FEATURE_TAG_akhn)

-- | Kerning for Alternate Proportional Widths
pattern FEATURE_TAG_apkn :: FeatureTag
pattern FEATURE_TAG_apkn = FeatureTag (#const KBTS_FEATURE_TAG_apkn)

-- | Below-base Mark Positioning
pattern FEATURE_TAG_blwm :: FeatureTag
pattern FEATURE_TAG_blwm = FeatureTag (#const KBTS_FEATURE_TAG_blwm)

-- | Below-base Substitutions
pattern FEATURE_TAG_blws :: FeatureTag
pattern FEATURE_TAG_blws = FeatureTag (#const KBTS_FEATURE_TAG_blws)

-- | Contextual Alternates
pattern FEATURE_TAG_calt :: FeatureTag
pattern FEATURE_TAG_calt = FeatureTag (#const KBTS_FEATURE_TAG_calt)

-- | Case-sensitive Forms
pattern FEATURE_TAG_case :: FeatureTag
pattern FEATURE_TAG_case = FeatureTag (#const KBTS_FEATURE_TAG_case)

-- | Glyph Composition / Decomposition
pattern FEATURE_TAG_ccmp :: FeatureTag
pattern FEATURE_TAG_ccmp = FeatureTag (#const KBTS_FEATURE_TAG_ccmp)

-- | Contextual Half-width Spacing
pattern FEATURE_TAG_chws :: FeatureTag
pattern FEATURE_TAG_chws = FeatureTag (#const KBTS_FEATURE_TAG_chws)

-- | Conjunct Forms
pattern FEATURE_TAG_cjct :: FeatureTag
pattern FEATURE_TAG_cjct = FeatureTag (#const KBTS_FEATURE_TAG_cjct)

-- | Contextual Ligatures
pattern FEATURE_TAG_clig :: FeatureTag
pattern FEATURE_TAG_clig = FeatureTag (#const KBTS_FEATURE_TAG_clig)

-- | Centered CJK Punctuation
pattern FEATURE_TAG_cpct :: FeatureTag
pattern FEATURE_TAG_cpct = FeatureTag (#const KBTS_FEATURE_TAG_cpct)

-- | Capital Spacing
pattern FEATURE_TAG_cpsp :: FeatureTag
pattern FEATURE_TAG_cpsp = FeatureTag (#const KBTS_FEATURE_TAG_cpsp)

-- | Contextual Swash
pattern FEATURE_TAG_cswh :: FeatureTag
pattern FEATURE_TAG_cswh = FeatureTag (#const KBTS_FEATURE_TAG_cswh)

-- | Cursive Positioning
pattern FEATURE_TAG_curs :: FeatureTag
pattern FEATURE_TAG_curs = FeatureTag (#const KBTS_FEATURE_TAG_curs)

-- | Character Variant 1
pattern FEATURE_TAG_cv01 :: FeatureTag
pattern FEATURE_TAG_cv01 = FeatureTag (#const KBTS_FEATURE_TAG_cv01)

-- | Character Variant 2
pattern FEATURE_TAG_cv02 :: FeatureTag
pattern FEATURE_TAG_cv02 = FeatureTag (#const KBTS_FEATURE_TAG_cv02)

-- | Character Variant 3
pattern FEATURE_TAG_cv03 :: FeatureTag
pattern FEATURE_TAG_cv03 = FeatureTag (#const KBTS_FEATURE_TAG_cv03)

-- | Character Variant 4
pattern FEATURE_TAG_cv04 :: FeatureTag
pattern FEATURE_TAG_cv04 = FeatureTag (#const KBTS_FEATURE_TAG_cv04)

-- | Character Variant 5
pattern FEATURE_TAG_cv05 :: FeatureTag
pattern FEATURE_TAG_cv05 = FeatureTag (#const KBTS_FEATURE_TAG_cv05)

-- | Character Variant 6
pattern FEATURE_TAG_cv06 :: FeatureTag
pattern FEATURE_TAG_cv06 = FeatureTag (#const KBTS_FEATURE_TAG_cv06)

-- | Character Variant 7
pattern FEATURE_TAG_cv07 :: FeatureTag
pattern FEATURE_TAG_cv07 = FeatureTag (#const KBTS_FEATURE_TAG_cv07)

-- | Character Variant 8
pattern FEATURE_TAG_cv08 :: FeatureTag
pattern FEATURE_TAG_cv08 = FeatureTag (#const KBTS_FEATURE_TAG_cv08)

-- | Character Variant 9
pattern FEATURE_TAG_cv09 :: FeatureTag
pattern FEATURE_TAG_cv09 = FeatureTag (#const KBTS_FEATURE_TAG_cv09)

-- | Character Variant 10
pattern FEATURE_TAG_cv10 :: FeatureTag
pattern FEATURE_TAG_cv10 = FeatureTag (#const KBTS_FEATURE_TAG_cv10)

-- | Character Variant 11
pattern FEATURE_TAG_cv11 :: FeatureTag
pattern FEATURE_TAG_cv11 = FeatureTag (#const KBTS_FEATURE_TAG_cv11)

-- | Character Variant 12
pattern FEATURE_TAG_cv12 :: FeatureTag
pattern FEATURE_TAG_cv12 = FeatureTag (#const KBTS_FEATURE_TAG_cv12)

-- | Character Variant 13
pattern FEATURE_TAG_cv13 :: FeatureTag
pattern FEATURE_TAG_cv13 = FeatureTag (#const KBTS_FEATURE_TAG_cv13)

-- | Character Variant 14
pattern FEATURE_TAG_cv14 :: FeatureTag
pattern FEATURE_TAG_cv14 = FeatureTag (#const KBTS_FEATURE_TAG_cv14)

-- | Character Variant 15
pattern FEATURE_TAG_cv15 :: FeatureTag
pattern FEATURE_TAG_cv15 = FeatureTag (#const KBTS_FEATURE_TAG_cv15)

-- | Character Variant 16
pattern FEATURE_TAG_cv16 :: FeatureTag
pattern FEATURE_TAG_cv16 = FeatureTag (#const KBTS_FEATURE_TAG_cv16)

-- | Character Variant 17
pattern FEATURE_TAG_cv17 :: FeatureTag
pattern FEATURE_TAG_cv17 = FeatureTag (#const KBTS_FEATURE_TAG_cv17)

-- | Character Variant 18
pattern FEATURE_TAG_cv18 :: FeatureTag
pattern FEATURE_TAG_cv18 = FeatureTag (#const KBTS_FEATURE_TAG_cv18)

-- | Character Variant 19
pattern FEATURE_TAG_cv19 :: FeatureTag
pattern FEATURE_TAG_cv19 = FeatureTag (#const KBTS_FEATURE_TAG_cv19)

-- | Character Variant 20
pattern FEATURE_TAG_cv20 :: FeatureTag
pattern FEATURE_TAG_cv20 = FeatureTag (#const KBTS_FEATURE_TAG_cv20)

-- | Character Variant 21
pattern FEATURE_TAG_cv21 :: FeatureTag
pattern FEATURE_TAG_cv21 = FeatureTag (#const KBTS_FEATURE_TAG_cv21)

-- | Character Variant 22
pattern FEATURE_TAG_cv22 :: FeatureTag
pattern FEATURE_TAG_cv22 = FeatureTag (#const KBTS_FEATURE_TAG_cv22)

-- | Character Variant 23
pattern FEATURE_TAG_cv23 :: FeatureTag
pattern FEATURE_TAG_cv23 = FeatureTag (#const KBTS_FEATURE_TAG_cv23)

-- | Character Variant 24
pattern FEATURE_TAG_cv24 :: FeatureTag
pattern FEATURE_TAG_cv24 = FeatureTag (#const KBTS_FEATURE_TAG_cv24)

-- | Character Variant 25
pattern FEATURE_TAG_cv25 :: FeatureTag
pattern FEATURE_TAG_cv25 = FeatureTag (#const KBTS_FEATURE_TAG_cv25)

-- | Character Variant 26
pattern FEATURE_TAG_cv26 :: FeatureTag
pattern FEATURE_TAG_cv26 = FeatureTag (#const KBTS_FEATURE_TAG_cv26)

-- | Character Variant 27
pattern FEATURE_TAG_cv27 :: FeatureTag
pattern FEATURE_TAG_cv27 = FeatureTag (#const KBTS_FEATURE_TAG_cv27)

-- | Character Variant 28
pattern FEATURE_TAG_cv28 :: FeatureTag
pattern FEATURE_TAG_cv28 = FeatureTag (#const KBTS_FEATURE_TAG_cv28)

-- | Character Variant 29
pattern FEATURE_TAG_cv29 :: FeatureTag
pattern FEATURE_TAG_cv29 = FeatureTag (#const KBTS_FEATURE_TAG_cv29)

-- | Character Variant 30
pattern FEATURE_TAG_cv30 :: FeatureTag
pattern FEATURE_TAG_cv30 = FeatureTag (#const KBTS_FEATURE_TAG_cv30)

-- | Character Variant 31
pattern FEATURE_TAG_cv31 :: FeatureTag
pattern FEATURE_TAG_cv31 = FeatureTag (#const KBTS_FEATURE_TAG_cv31)

-- | Character Variant 32
pattern FEATURE_TAG_cv32 :: FeatureTag
pattern FEATURE_TAG_cv32 = FeatureTag (#const KBTS_FEATURE_TAG_cv32)

-- | Character Variant 33
pattern FEATURE_TAG_cv33 :: FeatureTag
pattern FEATURE_TAG_cv33 = FeatureTag (#const KBTS_FEATURE_TAG_cv33)

-- | Character Variant 34
pattern FEATURE_TAG_cv34 :: FeatureTag
pattern FEATURE_TAG_cv34 = FeatureTag (#const KBTS_FEATURE_TAG_cv34)

-- | Character Variant 35
pattern FEATURE_TAG_cv35 :: FeatureTag
pattern FEATURE_TAG_cv35 = FeatureTag (#const KBTS_FEATURE_TAG_cv35)

-- | Character Variant 36
pattern FEATURE_TAG_cv36 :: FeatureTag
pattern FEATURE_TAG_cv36 = FeatureTag (#const KBTS_FEATURE_TAG_cv36)

-- | Character Variant 37
pattern FEATURE_TAG_cv37 :: FeatureTag
pattern FEATURE_TAG_cv37 = FeatureTag (#const KBTS_FEATURE_TAG_cv37)

-- | Character Variant 38
pattern FEATURE_TAG_cv38 :: FeatureTag
pattern FEATURE_TAG_cv38 = FeatureTag (#const KBTS_FEATURE_TAG_cv38)

-- | Character Variant 39
pattern FEATURE_TAG_cv39 :: FeatureTag
pattern FEATURE_TAG_cv39 = FeatureTag (#const KBTS_FEATURE_TAG_cv39)

-- | Character Variant 40
pattern FEATURE_TAG_cv40 :: FeatureTag
pattern FEATURE_TAG_cv40 = FeatureTag (#const KBTS_FEATURE_TAG_cv40)

-- | Character Variant 41
pattern FEATURE_TAG_cv41 :: FeatureTag
pattern FEATURE_TAG_cv41 = FeatureTag (#const KBTS_FEATURE_TAG_cv41)

-- | Character Variant 42
pattern FEATURE_TAG_cv42 :: FeatureTag
pattern FEATURE_TAG_cv42 = FeatureTag (#const KBTS_FEATURE_TAG_cv42)

-- | Character Variant 43
pattern FEATURE_TAG_cv43 :: FeatureTag
pattern FEATURE_TAG_cv43 = FeatureTag (#const KBTS_FEATURE_TAG_cv43)

-- | Character Variant 44
pattern FEATURE_TAG_cv44 :: FeatureTag
pattern FEATURE_TAG_cv44 = FeatureTag (#const KBTS_FEATURE_TAG_cv44)

-- | Character Variant 45
pattern FEATURE_TAG_cv45 :: FeatureTag
pattern FEATURE_TAG_cv45 = FeatureTag (#const KBTS_FEATURE_TAG_cv45)

-- | Character Variant 46
pattern FEATURE_TAG_cv46 :: FeatureTag
pattern FEATURE_TAG_cv46 = FeatureTag (#const KBTS_FEATURE_TAG_cv46)

-- | Character Variant 47
pattern FEATURE_TAG_cv47 :: FeatureTag
pattern FEATURE_TAG_cv47 = FeatureTag (#const KBTS_FEATURE_TAG_cv47)

-- | Character Variant 48
pattern FEATURE_TAG_cv48 :: FeatureTag
pattern FEATURE_TAG_cv48 = FeatureTag (#const KBTS_FEATURE_TAG_cv48)

-- | Character Variant 49
pattern FEATURE_TAG_cv49 :: FeatureTag
pattern FEATURE_TAG_cv49 = FeatureTag (#const KBTS_FEATURE_TAG_cv49)

-- | Character Variant 50
pattern FEATURE_TAG_cv50 :: FeatureTag
pattern FEATURE_TAG_cv50 = FeatureTag (#const KBTS_FEATURE_TAG_cv50)

-- | Character Variant 51
pattern FEATURE_TAG_cv51 :: FeatureTag
pattern FEATURE_TAG_cv51 = FeatureTag (#const KBTS_FEATURE_TAG_cv51)

-- | Character Variant 52
pattern FEATURE_TAG_cv52 :: FeatureTag
pattern FEATURE_TAG_cv52 = FeatureTag (#const KBTS_FEATURE_TAG_cv52)

-- | Character Variant 53
pattern FEATURE_TAG_cv53 :: FeatureTag
pattern FEATURE_TAG_cv53 = FeatureTag (#const KBTS_FEATURE_TAG_cv53)

-- | Character Variant 54
pattern FEATURE_TAG_cv54 :: FeatureTag
pattern FEATURE_TAG_cv54 = FeatureTag (#const KBTS_FEATURE_TAG_cv54)

-- | Character Variant 55
pattern FEATURE_TAG_cv55 :: FeatureTag
pattern FEATURE_TAG_cv55 = FeatureTag (#const KBTS_FEATURE_TAG_cv55)

-- | Character Variant 56
pattern FEATURE_TAG_cv56 :: FeatureTag
pattern FEATURE_TAG_cv56 = FeatureTag (#const KBTS_FEATURE_TAG_cv56)

-- | Character Variant 57
pattern FEATURE_TAG_cv57 :: FeatureTag
pattern FEATURE_TAG_cv57 = FeatureTag (#const KBTS_FEATURE_TAG_cv57)

-- | Character Variant 58
pattern FEATURE_TAG_cv58 :: FeatureTag
pattern FEATURE_TAG_cv58 = FeatureTag (#const KBTS_FEATURE_TAG_cv58)

-- | Character Variant 59
pattern FEATURE_TAG_cv59 :: FeatureTag
pattern FEATURE_TAG_cv59 = FeatureTag (#const KBTS_FEATURE_TAG_cv59)

-- | Character Variant 60
pattern FEATURE_TAG_cv60 :: FeatureTag
pattern FEATURE_TAG_cv60 = FeatureTag (#const KBTS_FEATURE_TAG_cv60)

-- | Character Variant 61
pattern FEATURE_TAG_cv61 :: FeatureTag
pattern FEATURE_TAG_cv61 = FeatureTag (#const KBTS_FEATURE_TAG_cv61)

-- | Character Variant 62
pattern FEATURE_TAG_cv62 :: FeatureTag
pattern FEATURE_TAG_cv62 = FeatureTag (#const KBTS_FEATURE_TAG_cv62)

-- | Character Variant 63
pattern FEATURE_TAG_cv63 :: FeatureTag
pattern FEATURE_TAG_cv63 = FeatureTag (#const KBTS_FEATURE_TAG_cv63)

-- | Character Variant 64
pattern FEATURE_TAG_cv64 :: FeatureTag
pattern FEATURE_TAG_cv64 = FeatureTag (#const KBTS_FEATURE_TAG_cv64)

-- | Character Variant 65
pattern FEATURE_TAG_cv65 :: FeatureTag
pattern FEATURE_TAG_cv65 = FeatureTag (#const KBTS_FEATURE_TAG_cv65)

-- | Character Variant 66
pattern FEATURE_TAG_cv66 :: FeatureTag
pattern FEATURE_TAG_cv66 = FeatureTag (#const KBTS_FEATURE_TAG_cv66)

-- | Character Variant 67
pattern FEATURE_TAG_cv67 :: FeatureTag
pattern FEATURE_TAG_cv67 = FeatureTag (#const KBTS_FEATURE_TAG_cv67)

-- | Character Variant 68
pattern FEATURE_TAG_cv68 :: FeatureTag
pattern FEATURE_TAG_cv68 = FeatureTag (#const KBTS_FEATURE_TAG_cv68)

-- | Character Variant 69
pattern FEATURE_TAG_cv69 :: FeatureTag
pattern FEATURE_TAG_cv69 = FeatureTag (#const KBTS_FEATURE_TAG_cv69)

-- | Character Variant 70
pattern FEATURE_TAG_cv70 :: FeatureTag
pattern FEATURE_TAG_cv70 = FeatureTag (#const KBTS_FEATURE_TAG_cv70)

-- | Character Variant 71
pattern FEATURE_TAG_cv71 :: FeatureTag
pattern FEATURE_TAG_cv71 = FeatureTag (#const KBTS_FEATURE_TAG_cv71)

-- | Character Variant 72
pattern FEATURE_TAG_cv72 :: FeatureTag
pattern FEATURE_TAG_cv72 = FeatureTag (#const KBTS_FEATURE_TAG_cv72)

-- | Character Variant 73
pattern FEATURE_TAG_cv73 :: FeatureTag
pattern FEATURE_TAG_cv73 = FeatureTag (#const KBTS_FEATURE_TAG_cv73)

-- | Character Variant 74
pattern FEATURE_TAG_cv74 :: FeatureTag
pattern FEATURE_TAG_cv74 = FeatureTag (#const KBTS_FEATURE_TAG_cv74)

-- | Character Variant 75
pattern FEATURE_TAG_cv75 :: FeatureTag
pattern FEATURE_TAG_cv75 = FeatureTag (#const KBTS_FEATURE_TAG_cv75)

-- | Character Variant 76
pattern FEATURE_TAG_cv76 :: FeatureTag
pattern FEATURE_TAG_cv76 = FeatureTag (#const KBTS_FEATURE_TAG_cv76)

-- | Character Variant 77
pattern FEATURE_TAG_cv77 :: FeatureTag
pattern FEATURE_TAG_cv77 = FeatureTag (#const KBTS_FEATURE_TAG_cv77)

-- | Character Variant 78
pattern FEATURE_TAG_cv78 :: FeatureTag
pattern FEATURE_TAG_cv78 = FeatureTag (#const KBTS_FEATURE_TAG_cv78)

-- | Character Variant 79
pattern FEATURE_TAG_cv79 :: FeatureTag
pattern FEATURE_TAG_cv79 = FeatureTag (#const KBTS_FEATURE_TAG_cv79)

-- | Character Variant 80
pattern FEATURE_TAG_cv80 :: FeatureTag
pattern FEATURE_TAG_cv80 = FeatureTag (#const KBTS_FEATURE_TAG_cv80)

-- | Character Variant 81
pattern FEATURE_TAG_cv81 :: FeatureTag
pattern FEATURE_TAG_cv81 = FeatureTag (#const KBTS_FEATURE_TAG_cv81)

-- | Character Variant 82
pattern FEATURE_TAG_cv82 :: FeatureTag
pattern FEATURE_TAG_cv82 = FeatureTag (#const KBTS_FEATURE_TAG_cv82)

-- | Character Variant 83
pattern FEATURE_TAG_cv83 :: FeatureTag
pattern FEATURE_TAG_cv83 = FeatureTag (#const KBTS_FEATURE_TAG_cv83)

-- | Character Variant 84
pattern FEATURE_TAG_cv84 :: FeatureTag
pattern FEATURE_TAG_cv84 = FeatureTag (#const KBTS_FEATURE_TAG_cv84)

-- | Character Variant 85
pattern FEATURE_TAG_cv85 :: FeatureTag
pattern FEATURE_TAG_cv85 = FeatureTag (#const KBTS_FEATURE_TAG_cv85)

-- | Character Variant 86
pattern FEATURE_TAG_cv86 :: FeatureTag
pattern FEATURE_TAG_cv86 = FeatureTag (#const KBTS_FEATURE_TAG_cv86)

-- | Character Variant 87
pattern FEATURE_TAG_cv87 :: FeatureTag
pattern FEATURE_TAG_cv87 = FeatureTag (#const KBTS_FEATURE_TAG_cv87)

-- | Character Variant 88
pattern FEATURE_TAG_cv88 :: FeatureTag
pattern FEATURE_TAG_cv88 = FeatureTag (#const KBTS_FEATURE_TAG_cv88)

-- | Character Variant 89
pattern FEATURE_TAG_cv89 :: FeatureTag
pattern FEATURE_TAG_cv89 = FeatureTag (#const KBTS_FEATURE_TAG_cv89)

-- | Character Variant 90
pattern FEATURE_TAG_cv90 :: FeatureTag
pattern FEATURE_TAG_cv90 = FeatureTag (#const KBTS_FEATURE_TAG_cv90)

-- | Character Variant 91
pattern FEATURE_TAG_cv91 :: FeatureTag
pattern FEATURE_TAG_cv91 = FeatureTag (#const KBTS_FEATURE_TAG_cv91)

-- | Character Variant 92
pattern FEATURE_TAG_cv92 :: FeatureTag
pattern FEATURE_TAG_cv92 = FeatureTag (#const KBTS_FEATURE_TAG_cv92)

-- | Character Variant 93
pattern FEATURE_TAG_cv93 :: FeatureTag
pattern FEATURE_TAG_cv93 = FeatureTag (#const KBTS_FEATURE_TAG_cv93)

-- | Character Variant 94
pattern FEATURE_TAG_cv94 :: FeatureTag
pattern FEATURE_TAG_cv94 = FeatureTag (#const KBTS_FEATURE_TAG_cv94)

-- | Character Variant 95
pattern FEATURE_TAG_cv95 :: FeatureTag
pattern FEATURE_TAG_cv95 = FeatureTag (#const KBTS_FEATURE_TAG_cv95)

-- | Character Variant 96
pattern FEATURE_TAG_cv96 :: FeatureTag
pattern FEATURE_TAG_cv96 = FeatureTag (#const KBTS_FEATURE_TAG_cv96)

-- | Character Variant 97
pattern FEATURE_TAG_cv97 :: FeatureTag
pattern FEATURE_TAG_cv97 = FeatureTag (#const KBTS_FEATURE_TAG_cv97)

-- | Character Variant 98
pattern FEATURE_TAG_cv98 :: FeatureTag
pattern FEATURE_TAG_cv98 = FeatureTag (#const KBTS_FEATURE_TAG_cv98)

-- | Character Variant 99
pattern FEATURE_TAG_cv99 :: FeatureTag
pattern FEATURE_TAG_cv99 = FeatureTag (#const KBTS_FEATURE_TAG_cv99)

-- | Petite Capitals From Capitals
pattern FEATURE_TAG_c2pc :: FeatureTag
pattern FEATURE_TAG_c2pc = FeatureTag (#const KBTS_FEATURE_TAG_c2pc)

-- | Small Capitals From Capitals
pattern FEATURE_TAG_c2sc :: FeatureTag
pattern FEATURE_TAG_c2sc = FeatureTag (#const KBTS_FEATURE_TAG_c2sc)

-- | Distances
pattern FEATURE_TAG_dist :: FeatureTag
pattern FEATURE_TAG_dist = FeatureTag (#const KBTS_FEATURE_TAG_dist)

-- | Discretionary Ligatures
pattern FEATURE_TAG_dlig :: FeatureTag
pattern FEATURE_TAG_dlig = FeatureTag (#const KBTS_FEATURE_TAG_dlig)

-- | Dotless Forms
pattern FEATURE_TAG_dtls :: FeatureTag
pattern FEATURE_TAG_dtls = FeatureTag (#const KBTS_FEATURE_TAG_dtls)

-- | Expert Forms
pattern FEATURE_TAG_expt :: FeatureTag
pattern FEATURE_TAG_expt = FeatureTag (#const KBTS_FEATURE_TAG_expt)

-- | Final Glyph on Line Alternates
pattern FEATURE_TAG_falt :: FeatureTag
pattern FEATURE_TAG_falt = FeatureTag (#const KBTS_FEATURE_TAG_falt)

-- | Flattened Accent Forms
pattern FEATURE_TAG_flac :: FeatureTag
pattern FEATURE_TAG_flac = FeatureTag (#const KBTS_FEATURE_TAG_flac)

-- | Full Widths
pattern FEATURE_TAG_fwid :: FeatureTag
pattern FEATURE_TAG_fwid = FeatureTag (#const KBTS_FEATURE_TAG_fwid)

-- | Halant Forms
pattern FEATURE_TAG_haln :: FeatureTag
pattern FEATURE_TAG_haln = FeatureTag (#const KBTS_FEATURE_TAG_haln)

-- | Alternate Half Widths
pattern FEATURE_TAG_halt :: FeatureTag
pattern FEATURE_TAG_halt = FeatureTag (#const KBTS_FEATURE_TAG_halt)

-- | Historical Forms
pattern FEATURE_TAG_hist :: FeatureTag
pattern FEATURE_TAG_hist = FeatureTag (#const KBTS_FEATURE_TAG_hist)

-- | Horizontal Kana Alternates
pattern FEATURE_TAG_hkna :: FeatureTag
pattern FEATURE_TAG_hkna = FeatureTag (#const KBTS_FEATURE_TAG_hkna)

-- | Historical Ligatures
pattern FEATURE_TAG_hlig :: FeatureTag
pattern FEATURE_TAG_hlig = FeatureTag (#const KBTS_FEATURE_TAG_hlig)

-- | Hangul
pattern FEATURE_TAG_hngl :: FeatureTag
pattern FEATURE_TAG_hngl = FeatureTag (#const KBTS_FEATURE_TAG_hngl)

-- | Hojo Kanji Forms (JIS X 0212-1990 Kanji Forms)
pattern FEATURE_TAG_hojo :: FeatureTag
pattern FEATURE_TAG_hojo = FeatureTag (#const KBTS_FEATURE_TAG_hojo)

-- | Half Widths
pattern FEATURE_TAG_hwid :: FeatureTag
pattern FEATURE_TAG_hwid = FeatureTag (#const KBTS_FEATURE_TAG_hwid)

-- | Italics
pattern FEATURE_TAG_ital :: FeatureTag
pattern FEATURE_TAG_ital = FeatureTag (#const KBTS_FEATURE_TAG_ital)

-- | Justification Alternates
pattern FEATURE_TAG_jalt :: FeatureTag
pattern FEATURE_TAG_jalt = FeatureTag (#const KBTS_FEATURE_TAG_jalt)

-- | JIS78 Forms
pattern FEATURE_TAG_jp78 :: FeatureTag
pattern FEATURE_TAG_jp78 = FeatureTag (#const KBTS_FEATURE_TAG_jp78)

-- | JIS83 Forms
pattern FEATURE_TAG_jp83 :: FeatureTag
pattern FEATURE_TAG_jp83 = FeatureTag (#const KBTS_FEATURE_TAG_jp83)

-- | JIS90 Forms
pattern FEATURE_TAG_jp90 :: FeatureTag
pattern FEATURE_TAG_jp90 = FeatureTag (#const KBTS_FEATURE_TAG_jp90)

-- | JIS2004 Forms
pattern FEATURE_TAG_jp04 :: FeatureTag
pattern FEATURE_TAG_jp04 = FeatureTag (#const KBTS_FEATURE_TAG_jp04)

-- | Kerning
pattern FEATURE_TAG_kern :: FeatureTag
pattern FEATURE_TAG_kern = FeatureTag (#const KBTS_FEATURE_TAG_kern)

-- | Left Bounds
pattern FEATURE_TAG_lfbd :: FeatureTag
pattern FEATURE_TAG_lfbd = FeatureTag (#const KBTS_FEATURE_TAG_lfbd)

-- | Standard Ligatures
pattern FEATURE_TAG_liga :: FeatureTag
pattern FEATURE_TAG_liga = FeatureTag (#const KBTS_FEATURE_TAG_liga)

-- | Lining Figures
pattern FEATURE_TAG_lnum :: FeatureTag
pattern FEATURE_TAG_lnum = FeatureTag (#const KBTS_FEATURE_TAG_lnum)

-- | Localized Forms
pattern FEATURE_TAG_locl :: FeatureTag
pattern FEATURE_TAG_locl = FeatureTag (#const KBTS_FEATURE_TAG_locl)

-- | Left-to-right Alternates
pattern FEATURE_TAG_ltra :: FeatureTag
pattern FEATURE_TAG_ltra = FeatureTag (#const KBTS_FEATURE_TAG_ltra)

-- | Left-to-right Mirrored Forms
pattern FEATURE_TAG_ltrm :: FeatureTag
pattern FEATURE_TAG_ltrm = FeatureTag (#const KBTS_FEATURE_TAG_ltrm)

-- | Mark Positioning
pattern FEATURE_TAG_mark :: FeatureTag
pattern FEATURE_TAG_mark = FeatureTag (#const KBTS_FEATURE_TAG_mark)

-- | Mathematical Greek
pattern FEATURE_TAG_mgrk :: FeatureTag
pattern FEATURE_TAG_mgrk = FeatureTag (#const KBTS_FEATURE_TAG_mgrk)

-- | Mark to Mark Positioning
pattern FEATURE_TAG_mkmk :: FeatureTag
pattern FEATURE_TAG_mkmk = FeatureTag (#const KBTS_FEATURE_TAG_mkmk)

-- | Mark Positioning via Substitution
pattern FEATURE_TAG_mset :: FeatureTag
pattern FEATURE_TAG_mset = FeatureTag (#const KBTS_FEATURE_TAG_mset)

-- | Alternate Annotation Forms
pattern FEATURE_TAG_nalt :: FeatureTag
pattern FEATURE_TAG_nalt = FeatureTag (#const KBTS_FEATURE_TAG_nalt)

-- | NLC Kanji Forms
pattern FEATURE_TAG_nlck :: FeatureTag
pattern FEATURE_TAG_nlck = FeatureTag (#const KBTS_FEATURE_TAG_nlck)

-- | Nukta Forms
pattern FEATURE_TAG_nukt :: FeatureTag
pattern FEATURE_TAG_nukt = FeatureTag (#const KBTS_FEATURE_TAG_nukt)

-- | Oldstyle Figures
pattern FEATURE_TAG_onum :: FeatureTag
pattern FEATURE_TAG_onum = FeatureTag (#const KBTS_FEATURE_TAG_onum)

-- | Optical Bounds
pattern FEATURE_TAG_opbd :: FeatureTag
pattern FEATURE_TAG_opbd = FeatureTag (#const KBTS_FEATURE_TAG_opbd)

-- | Ordinals
pattern FEATURE_TAG_ordn :: FeatureTag
pattern FEATURE_TAG_ordn = FeatureTag (#const KBTS_FEATURE_TAG_ordn)

-- | Ornaments
pattern FEATURE_TAG_ornm :: FeatureTag
pattern FEATURE_TAG_ornm = FeatureTag (#const KBTS_FEATURE_TAG_ornm)

-- | Proportional Alternate Widths
pattern FEATURE_TAG_palt :: FeatureTag
pattern FEATURE_TAG_palt = FeatureTag (#const KBTS_FEATURE_TAG_palt)

-- | Petite Capitals
pattern FEATURE_TAG_pcap :: FeatureTag
pattern FEATURE_TAG_pcap = FeatureTag (#const KBTS_FEATURE_TAG_pcap)

-- | Proportional Kana
pattern FEATURE_TAG_pkna :: FeatureTag
pattern FEATURE_TAG_pkna = FeatureTag (#const KBTS_FEATURE_TAG_pkna)

-- | Proportional Figures
pattern FEATURE_TAG_pnum :: FeatureTag
pattern FEATURE_TAG_pnum = FeatureTag (#const KBTS_FEATURE_TAG_pnum)

-- | Pre-base Substitutions
pattern FEATURE_TAG_pres :: FeatureTag
pattern FEATURE_TAG_pres = FeatureTag (#const KBTS_FEATURE_TAG_pres)

-- | Post-base Substitutions
pattern FEATURE_TAG_psts :: FeatureTag
pattern FEATURE_TAG_psts = FeatureTag (#const KBTS_FEATURE_TAG_psts)

-- | Proportional Widths
pattern FEATURE_TAG_pwid :: FeatureTag
pattern FEATURE_TAG_pwid = FeatureTag (#const KBTS_FEATURE_TAG_pwid)

-- | Quarter Widths
pattern FEATURE_TAG_qwid :: FeatureTag
pattern FEATURE_TAG_qwid = FeatureTag (#const KBTS_FEATURE_TAG_qwid)

-- | Randomize
pattern FEATURE_TAG_rand :: FeatureTag
pattern FEATURE_TAG_rand = FeatureTag (#const KBTS_FEATURE_TAG_rand)

-- | Required Contextual Alternates
pattern FEATURE_TAG_rclt :: FeatureTag
pattern FEATURE_TAG_rclt = FeatureTag (#const KBTS_FEATURE_TAG_rclt)

-- | Rakar Forms
pattern FEATURE_TAG_rkrf :: FeatureTag
pattern FEATURE_TAG_rkrf = FeatureTag (#const KBTS_FEATURE_TAG_rkrf)

-- | Required Ligatures
pattern FEATURE_TAG_rlig :: FeatureTag
pattern FEATURE_TAG_rlig = FeatureTag (#const KBTS_FEATURE_TAG_rlig)

-- | Right Bounds
pattern FEATURE_TAG_rtbd :: FeatureTag
pattern FEATURE_TAG_rtbd = FeatureTag (#const KBTS_FEATURE_TAG_rtbd)

-- | Right-to-left Alternates
pattern FEATURE_TAG_rtla :: FeatureTag
pattern FEATURE_TAG_rtla = FeatureTag (#const KBTS_FEATURE_TAG_rtla)

-- | Right-to-left Mirrored Forms
pattern FEATURE_TAG_rtlm :: FeatureTag
pattern FEATURE_TAG_rtlm = FeatureTag (#const KBTS_FEATURE_TAG_rtlm)

-- | Ruby Notation Forms
pattern FEATURE_TAG_ruby :: FeatureTag
pattern FEATURE_TAG_ruby = FeatureTag (#const KBTS_FEATURE_TAG_ruby)

-- | Required Variation Alternates
pattern FEATURE_TAG_rvrn :: FeatureTag
pattern FEATURE_TAG_rvrn = FeatureTag (#const KBTS_FEATURE_TAG_rvrn)

-- | Stylistic Alternates
pattern FEATURE_TAG_salt :: FeatureTag
pattern FEATURE_TAG_salt = FeatureTag (#const KBTS_FEATURE_TAG_salt)

-- | Scientific Inferiors
pattern FEATURE_TAG_sinf :: FeatureTag
pattern FEATURE_TAG_sinf = FeatureTag (#const KBTS_FEATURE_TAG_sinf)

-- | Optical size
pattern FEATURE_TAG_size :: FeatureTag
pattern FEATURE_TAG_size = FeatureTag (#const KBTS_FEATURE_TAG_size)

-- | Small Capitals
pattern FEATURE_TAG_smcp :: FeatureTag
pattern FEATURE_TAG_smcp = FeatureTag (#const KBTS_FEATURE_TAG_smcp)

-- | Simplified Forms
pattern FEATURE_TAG_smpl :: FeatureTag
pattern FEATURE_TAG_smpl = FeatureTag (#const KBTS_FEATURE_TAG_smpl)

-- | Stylistic Set 1
pattern FEATURE_TAG_ss01 :: FeatureTag
pattern FEATURE_TAG_ss01 = FeatureTag (#const KBTS_FEATURE_TAG_ss01)

-- | Stylistic Set 2
pattern FEATURE_TAG_ss02 :: FeatureTag
pattern FEATURE_TAG_ss02 = FeatureTag (#const KBTS_FEATURE_TAG_ss02)

-- | Stylistic Set 3
pattern FEATURE_TAG_ss03 :: FeatureTag
pattern FEATURE_TAG_ss03 = FeatureTag (#const KBTS_FEATURE_TAG_ss03)

-- | Stylistic Set 4
pattern FEATURE_TAG_ss04 :: FeatureTag
pattern FEATURE_TAG_ss04 = FeatureTag (#const KBTS_FEATURE_TAG_ss04)

-- | Stylistic Set 5
pattern FEATURE_TAG_ss05 :: FeatureTag
pattern FEATURE_TAG_ss05 = FeatureTag (#const KBTS_FEATURE_TAG_ss05)

-- | Stylistic Set 6
pattern FEATURE_TAG_ss06 :: FeatureTag
pattern FEATURE_TAG_ss06 = FeatureTag (#const KBTS_FEATURE_TAG_ss06)

-- | Stylistic Set 7
pattern FEATURE_TAG_ss07 :: FeatureTag
pattern FEATURE_TAG_ss07 = FeatureTag (#const KBTS_FEATURE_TAG_ss07)

-- | Stylistic Set 8
pattern FEATURE_TAG_ss08 :: FeatureTag
pattern FEATURE_TAG_ss08 = FeatureTag (#const KBTS_FEATURE_TAG_ss08)

-- | Stylistic Set 9
pattern FEATURE_TAG_ss09 :: FeatureTag
pattern FEATURE_TAG_ss09 = FeatureTag (#const KBTS_FEATURE_TAG_ss09)

-- | Stylistic Set 10
pattern FEATURE_TAG_ss10 :: FeatureTag
pattern FEATURE_TAG_ss10 = FeatureTag (#const KBTS_FEATURE_TAG_ss10)

-- | Stylistic Set 11
pattern FEATURE_TAG_ss11 :: FeatureTag
pattern FEATURE_TAG_ss11 = FeatureTag (#const KBTS_FEATURE_TAG_ss11)

-- | Stylistic Set 12
pattern FEATURE_TAG_ss12 :: FeatureTag
pattern FEATURE_TAG_ss12 = FeatureTag (#const KBTS_FEATURE_TAG_ss12)

-- | Stylistic Set 13
pattern FEATURE_TAG_ss13 :: FeatureTag
pattern FEATURE_TAG_ss13 = FeatureTag (#const KBTS_FEATURE_TAG_ss13)

-- | Stylistic Set 14
pattern FEATURE_TAG_ss14 :: FeatureTag
pattern FEATURE_TAG_ss14 = FeatureTag (#const KBTS_FEATURE_TAG_ss14)

-- | Stylistic Set 15
pattern FEATURE_TAG_ss15 :: FeatureTag
pattern FEATURE_TAG_ss15 = FeatureTag (#const KBTS_FEATURE_TAG_ss15)

-- | Stylistic Set 16
pattern FEATURE_TAG_ss16 :: FeatureTag
pattern FEATURE_TAG_ss16 = FeatureTag (#const KBTS_FEATURE_TAG_ss16)

-- | Stylistic Set 17
pattern FEATURE_TAG_ss17 :: FeatureTag
pattern FEATURE_TAG_ss17 = FeatureTag (#const KBTS_FEATURE_TAG_ss17)

-- | Stylistic Set 18
pattern FEATURE_TAG_ss18 :: FeatureTag
pattern FEATURE_TAG_ss18 = FeatureTag (#const KBTS_FEATURE_TAG_ss18)

-- | Stylistic Set 19
pattern FEATURE_TAG_ss19 :: FeatureTag
pattern FEATURE_TAG_ss19 = FeatureTag (#const KBTS_FEATURE_TAG_ss19)

-- | Stylistic Set 20
pattern FEATURE_TAG_ss20 :: FeatureTag
pattern FEATURE_TAG_ss20 = FeatureTag (#const KBTS_FEATURE_TAG_ss20)

-- | Math Script-style Alternates
pattern FEATURE_TAG_ssty :: FeatureTag
pattern FEATURE_TAG_ssty = FeatureTag (#const KBTS_FEATURE_TAG_ssty)

-- | Stretching Glyph Decomposition
pattern FEATURE_TAG_stch :: FeatureTag
pattern FEATURE_TAG_stch = FeatureTag (#const KBTS_FEATURE_TAG_stch)

-- | Subscript
pattern FEATURE_TAG_subs :: FeatureTag
pattern FEATURE_TAG_subs = FeatureTag (#const KBTS_FEATURE_TAG_subs)

-- | Superscript
pattern FEATURE_TAG_sups :: FeatureTag
pattern FEATURE_TAG_sups = FeatureTag (#const KBTS_FEATURE_TAG_sups)

-- | Swash
pattern FEATURE_TAG_swsh :: FeatureTag
pattern FEATURE_TAG_swsh = FeatureTag (#const KBTS_FEATURE_TAG_swsh)

-- | Test features, only for development
pattern FEATURE_TAG_test :: FeatureTag
pattern FEATURE_TAG_test = FeatureTag (#const KBTS_FEATURE_TAG_test)

-- | Titling
pattern FEATURE_TAG_titl :: FeatureTag
pattern FEATURE_TAG_titl = FeatureTag (#const KBTS_FEATURE_TAG_titl)

-- | Traditional Name Forms
pattern FEATURE_TAG_tnam :: FeatureTag
pattern FEATURE_TAG_tnam = FeatureTag (#const KBTS_FEATURE_TAG_tnam)

-- | Tabular Figures
pattern FEATURE_TAG_tnum :: FeatureTag
pattern FEATURE_TAG_tnum = FeatureTag (#const KBTS_FEATURE_TAG_tnum)

-- | Traditional Forms
pattern FEATURE_TAG_trad :: FeatureTag
pattern FEATURE_TAG_trad = FeatureTag (#const KBTS_FEATURE_TAG_trad)

-- | Third Widths
pattern FEATURE_TAG_twid :: FeatureTag
pattern FEATURE_TAG_twid = FeatureTag (#const KBTS_FEATURE_TAG_twid)

-- | Unicase
pattern FEATURE_TAG_unic :: FeatureTag
pattern FEATURE_TAG_unic = FeatureTag (#const KBTS_FEATURE_TAG_unic)

-- | Alternate Vertical Metrics
pattern FEATURE_TAG_valt :: FeatureTag
pattern FEATURE_TAG_valt = FeatureTag (#const KBTS_FEATURE_TAG_valt)

-- | Kerning for Alternate Proportional Vertical Metrics
pattern FEATURE_TAG_vapk :: FeatureTag
pattern FEATURE_TAG_vapk = FeatureTag (#const KBTS_FEATURE_TAG_vapk)

-- | Vattu Variants
pattern FEATURE_TAG_vatu :: FeatureTag
pattern FEATURE_TAG_vatu = FeatureTag (#const KBTS_FEATURE_TAG_vatu)

-- | Vertical Contextual Half-width Spacing
pattern FEATURE_TAG_vchw :: FeatureTag
pattern FEATURE_TAG_vchw = FeatureTag (#const KBTS_FEATURE_TAG_vchw)

-- | Vertical Alternates
pattern FEATURE_TAG_vert :: FeatureTag
pattern FEATURE_TAG_vert = FeatureTag (#const KBTS_FEATURE_TAG_vert)

-- | Alternate Vertical Half Metrics
pattern FEATURE_TAG_vhal :: FeatureTag
pattern FEATURE_TAG_vhal = FeatureTag (#const KBTS_FEATURE_TAG_vhal)

-- | Vertical Kana Alternates
pattern FEATURE_TAG_vkna :: FeatureTag
pattern FEATURE_TAG_vkna = FeatureTag (#const KBTS_FEATURE_TAG_vkna)

-- | Vertical Kerning
pattern FEATURE_TAG_vkrn :: FeatureTag
pattern FEATURE_TAG_vkrn = FeatureTag (#const KBTS_FEATURE_TAG_vkrn)

-- | Proportional Alternate Vertical Metrics
pattern FEATURE_TAG_vpal :: FeatureTag
pattern FEATURE_TAG_vpal = FeatureTag (#const KBTS_FEATURE_TAG_vpal)

-- | Vertical Alternates and Rotation
pattern FEATURE_TAG_vrt2 :: FeatureTag
pattern FEATURE_TAG_vrt2 = FeatureTag (#const KBTS_FEATURE_TAG_vrt2)

-- | Vertical Alternates for Rotation
pattern FEATURE_TAG_vrtr :: FeatureTag
pattern FEATURE_TAG_vrtr = FeatureTag (#const KBTS_FEATURE_TAG_vrtr)

-- | Slashed Zero
pattern FEATURE_TAG_zero :: FeatureTag
pattern FEATURE_TAG_zero = FeatureTag (#const KBTS_FEATURE_TAG_zero)
