module KB.Text.Shape.FFI.Enums.Script where

import Prelude hiding (id, error)

import Foreign

#include "kb_text_shape.h"

newtype Script = Script Word32
  deriving (Eq, Ord, Show)
  deriving newtype (Storable)

pattern SCRIPT_DONT_KNOW :: Script
pattern SCRIPT_DONT_KNOW = Script (#const KBTS_SCRIPT_DONT_KNOW)

pattern SCRIPT_ADLAM :: Script
pattern SCRIPT_ADLAM = Script (#const KBTS_SCRIPT_ADLAM)

pattern SCRIPT_AHOM :: Script
pattern SCRIPT_AHOM = Script (#const KBTS_SCRIPT_AHOM)

pattern SCRIPT_ANATOLIAN_HIEROGLYPHS :: Script
pattern SCRIPT_ANATOLIAN_HIEROGLYPHS = Script (#const KBTS_SCRIPT_ANATOLIAN_HIEROGLYPHS)

pattern SCRIPT_ARABIC :: Script
pattern SCRIPT_ARABIC = Script (#const KBTS_SCRIPT_ARABIC)

pattern SCRIPT_ARMENIAN :: Script
pattern SCRIPT_ARMENIAN = Script (#const KBTS_SCRIPT_ARMENIAN)

pattern SCRIPT_AVESTAN :: Script
pattern SCRIPT_AVESTAN = Script (#const KBTS_SCRIPT_AVESTAN)

pattern SCRIPT_BALINESE :: Script
pattern SCRIPT_BALINESE = Script (#const KBTS_SCRIPT_BALINESE)

pattern SCRIPT_BAMUM :: Script
pattern SCRIPT_BAMUM = Script (#const KBTS_SCRIPT_BAMUM)

pattern SCRIPT_BASSA_VAH :: Script
pattern SCRIPT_BASSA_VAH = Script (#const KBTS_SCRIPT_BASSA_VAH)

pattern SCRIPT_BATAK :: Script
pattern SCRIPT_BATAK = Script (#const KBTS_SCRIPT_BATAK)

pattern SCRIPT_BENGALI :: Script
pattern SCRIPT_BENGALI = Script (#const KBTS_SCRIPT_BENGALI)

pattern SCRIPT_BHAIKSUKI :: Script
pattern SCRIPT_BHAIKSUKI = Script (#const KBTS_SCRIPT_BHAIKSUKI)

pattern SCRIPT_BOPOMOFO :: Script
pattern SCRIPT_BOPOMOFO = Script (#const KBTS_SCRIPT_BOPOMOFO)

pattern SCRIPT_BRAHMI :: Script
pattern SCRIPT_BRAHMI = Script (#const KBTS_SCRIPT_BRAHMI)

pattern SCRIPT_BUGINESE :: Script
pattern SCRIPT_BUGINESE = Script (#const KBTS_SCRIPT_BUGINESE)

pattern SCRIPT_BUHID :: Script
pattern SCRIPT_BUHID = Script (#const KBTS_SCRIPT_BUHID)

pattern SCRIPT_CANADIAN_SYLLABICS :: Script
pattern SCRIPT_CANADIAN_SYLLABICS = Script (#const KBTS_SCRIPT_CANADIAN_SYLLABICS)

pattern SCRIPT_CARIAN :: Script
pattern SCRIPT_CARIAN = Script (#const KBTS_SCRIPT_CARIAN)

pattern SCRIPT_CAUCASIAN_ALBANIAN :: Script
pattern SCRIPT_CAUCASIAN_ALBANIAN = Script (#const KBTS_SCRIPT_CAUCASIAN_ALBANIAN)

pattern SCRIPT_CHAKMA :: Script
pattern SCRIPT_CHAKMA = Script (#const KBTS_SCRIPT_CHAKMA)

pattern SCRIPT_CHAM :: Script
pattern SCRIPT_CHAM = Script (#const KBTS_SCRIPT_CHAM)

pattern SCRIPT_CHEROKEE :: Script
pattern SCRIPT_CHEROKEE = Script (#const KBTS_SCRIPT_CHEROKEE)

pattern SCRIPT_CHORASMIAN :: Script
pattern SCRIPT_CHORASMIAN = Script (#const KBTS_SCRIPT_CHORASMIAN)

pattern SCRIPT_CJK_IDEOGRAPHIC :: Script
pattern SCRIPT_CJK_IDEOGRAPHIC = Script (#const KBTS_SCRIPT_CJK_IDEOGRAPHIC)

pattern SCRIPT_COPTIC :: Script
pattern SCRIPT_COPTIC = Script (#const KBTS_SCRIPT_COPTIC)

pattern SCRIPT_CYPRIOT_SYLLABARY :: Script
pattern SCRIPT_CYPRIOT_SYLLABARY = Script (#const KBTS_SCRIPT_CYPRIOT_SYLLABARY)

pattern SCRIPT_CYPRO_MINOAN :: Script
pattern SCRIPT_CYPRO_MINOAN = Script (#const KBTS_SCRIPT_CYPRO_MINOAN)

pattern SCRIPT_CYRILLIC :: Script
pattern SCRIPT_CYRILLIC = Script (#const KBTS_SCRIPT_CYRILLIC)

pattern SCRIPT_DEFAULT :: Script
pattern SCRIPT_DEFAULT = Script (#const KBTS_SCRIPT_DEFAULT)

pattern SCRIPT_DEFAULT2 :: Script
pattern SCRIPT_DEFAULT2 = Script (#const KBTS_SCRIPT_DEFAULT2)

pattern SCRIPT_DESERET :: Script
pattern SCRIPT_DESERET = Script (#const KBTS_SCRIPT_DESERET)

pattern SCRIPT_DEVANAGARI :: Script
pattern SCRIPT_DEVANAGARI = Script (#const KBTS_SCRIPT_DEVANAGARI)

pattern SCRIPT_DIVES_AKURU :: Script
pattern SCRIPT_DIVES_AKURU = Script (#const KBTS_SCRIPT_DIVES_AKURU)

pattern SCRIPT_DOGRA :: Script
pattern SCRIPT_DOGRA = Script (#const KBTS_SCRIPT_DOGRA)

pattern SCRIPT_DUPLOYAN :: Script
pattern SCRIPT_DUPLOYAN = Script (#const KBTS_SCRIPT_DUPLOYAN)

pattern SCRIPT_EGYPTIAN_HIEROGLYPHS :: Script
pattern SCRIPT_EGYPTIAN_HIEROGLYPHS = Script (#const KBTS_SCRIPT_EGYPTIAN_HIEROGLYPHS)

pattern SCRIPT_ELBASAN :: Script
pattern SCRIPT_ELBASAN = Script (#const KBTS_SCRIPT_ELBASAN)

pattern SCRIPT_ELYMAIC :: Script
pattern SCRIPT_ELYMAIC = Script (#const KBTS_SCRIPT_ELYMAIC)

pattern SCRIPT_ETHIOPIC :: Script
pattern SCRIPT_ETHIOPIC = Script (#const KBTS_SCRIPT_ETHIOPIC)

pattern SCRIPT_GARAY :: Script
pattern SCRIPT_GARAY = Script (#const KBTS_SCRIPT_GARAY)

pattern SCRIPT_GEORGIAN :: Script
pattern SCRIPT_GEORGIAN = Script (#const KBTS_SCRIPT_GEORGIAN)

pattern SCRIPT_GLAGOLITIC :: Script
pattern SCRIPT_GLAGOLITIC = Script (#const KBTS_SCRIPT_GLAGOLITIC)

pattern SCRIPT_GOTHIC :: Script
pattern SCRIPT_GOTHIC = Script (#const KBTS_SCRIPT_GOTHIC)

pattern SCRIPT_GRANTHA :: Script
pattern SCRIPT_GRANTHA = Script (#const KBTS_SCRIPT_GRANTHA)

pattern SCRIPT_GREEK :: Script
pattern SCRIPT_GREEK = Script (#const KBTS_SCRIPT_GREEK)

pattern SCRIPT_GUJARATI :: Script
pattern SCRIPT_GUJARATI = Script (#const KBTS_SCRIPT_GUJARATI)

pattern SCRIPT_GUNJALA_GONDI :: Script
pattern SCRIPT_GUNJALA_GONDI = Script (#const KBTS_SCRIPT_GUNJALA_GONDI)

pattern SCRIPT_GURMUKHI :: Script
pattern SCRIPT_GURMUKHI = Script (#const KBTS_SCRIPT_GURMUKHI)

pattern SCRIPT_GURUNG_KHEMA :: Script
pattern SCRIPT_GURUNG_KHEMA = Script (#const KBTS_SCRIPT_GURUNG_KHEMA)

pattern SCRIPT_HANGUL :: Script
pattern SCRIPT_HANGUL = Script (#const KBTS_SCRIPT_HANGUL)

pattern SCRIPT_HANIFI_ROHINGYA :: Script
pattern SCRIPT_HANIFI_ROHINGYA = Script (#const KBTS_SCRIPT_HANIFI_ROHINGYA)

pattern SCRIPT_HANUNOO :: Script
pattern SCRIPT_HANUNOO = Script (#const KBTS_SCRIPT_HANUNOO)

pattern SCRIPT_HATRAN :: Script
pattern SCRIPT_HATRAN = Script (#const KBTS_SCRIPT_HATRAN)

pattern SCRIPT_HEBREW :: Script
pattern SCRIPT_HEBREW = Script (#const KBTS_SCRIPT_HEBREW)

pattern SCRIPT_HIRAGANA :: Script
pattern SCRIPT_HIRAGANA = Script (#const KBTS_SCRIPT_HIRAGANA)

pattern SCRIPT_IMPERIAL_ARAMAIC :: Script
pattern SCRIPT_IMPERIAL_ARAMAIC = Script (#const KBTS_SCRIPT_IMPERIAL_ARAMAIC)

pattern SCRIPT_INSCRIPTIONAL_PAHLAVI :: Script
pattern SCRIPT_INSCRIPTIONAL_PAHLAVI = Script (#const KBTS_SCRIPT_INSCRIPTIONAL_PAHLAVI)

pattern SCRIPT_INSCRIPTIONAL_PARTHIAN :: Script
pattern SCRIPT_INSCRIPTIONAL_PARTHIAN = Script (#const KBTS_SCRIPT_INSCRIPTIONAL_PARTHIAN)

pattern SCRIPT_JAVANESE :: Script
pattern SCRIPT_JAVANESE = Script (#const KBTS_SCRIPT_JAVANESE)

pattern SCRIPT_KAITHI :: Script
pattern SCRIPT_KAITHI = Script (#const KBTS_SCRIPT_KAITHI)

pattern SCRIPT_KANNADA :: Script
pattern SCRIPT_KANNADA = Script (#const KBTS_SCRIPT_KANNADA)

pattern SCRIPT_KATAKANA :: Script
pattern SCRIPT_KATAKANA = Script (#const KBTS_SCRIPT_KATAKANA)

pattern SCRIPT_KAWI :: Script
pattern SCRIPT_KAWI = Script (#const KBTS_SCRIPT_KAWI)

pattern SCRIPT_KAYAH_LI :: Script
pattern SCRIPT_KAYAH_LI = Script (#const KBTS_SCRIPT_KAYAH_LI)

pattern SCRIPT_KHAROSHTHI :: Script
pattern SCRIPT_KHAROSHTHI = Script (#const KBTS_SCRIPT_KHAROSHTHI)

pattern SCRIPT_KHITAN_SMALL_SCRIPT :: Script
pattern SCRIPT_KHITAN_SMALL_SCRIPT = Script (#const KBTS_SCRIPT_KHITAN_SMALL_SCRIPT)

pattern SCRIPT_KHMER :: Script
pattern SCRIPT_KHMER = Script (#const KBTS_SCRIPT_KHMER)

pattern SCRIPT_KHOJKI :: Script
pattern SCRIPT_KHOJKI = Script (#const KBTS_SCRIPT_KHOJKI)

pattern SCRIPT_KHUDAWADI :: Script
pattern SCRIPT_KHUDAWADI = Script (#const KBTS_SCRIPT_KHUDAWADI)

pattern SCRIPT_KIRAT_RAI :: Script
pattern SCRIPT_KIRAT_RAI = Script (#const KBTS_SCRIPT_KIRAT_RAI)

pattern SCRIPT_LAO :: Script
pattern SCRIPT_LAO = Script (#const KBTS_SCRIPT_LAO)

pattern SCRIPT_LATIN :: Script
pattern SCRIPT_LATIN = Script (#const KBTS_SCRIPT_LATIN)

pattern SCRIPT_LEPCHA :: Script
pattern SCRIPT_LEPCHA = Script (#const KBTS_SCRIPT_LEPCHA)

pattern SCRIPT_LIMBU :: Script
pattern SCRIPT_LIMBU = Script (#const KBTS_SCRIPT_LIMBU)

pattern SCRIPT_LINEAR_A :: Script
pattern SCRIPT_LINEAR_A = Script (#const KBTS_SCRIPT_LINEAR_A)

pattern SCRIPT_LINEAR_B :: Script
pattern SCRIPT_LINEAR_B = Script (#const KBTS_SCRIPT_LINEAR_B)

pattern SCRIPT_LISU :: Script
pattern SCRIPT_LISU = Script (#const KBTS_SCRIPT_LISU)

pattern SCRIPT_LYCIAN :: Script
pattern SCRIPT_LYCIAN = Script (#const KBTS_SCRIPT_LYCIAN)

pattern SCRIPT_LYDIAN :: Script
pattern SCRIPT_LYDIAN = Script (#const KBTS_SCRIPT_LYDIAN)

pattern SCRIPT_MAHAJANI :: Script
pattern SCRIPT_MAHAJANI = Script (#const KBTS_SCRIPT_MAHAJANI)

pattern SCRIPT_MAKASAR :: Script
pattern SCRIPT_MAKASAR = Script (#const KBTS_SCRIPT_MAKASAR)

pattern SCRIPT_MALAYALAM :: Script
pattern SCRIPT_MALAYALAM = Script (#const KBTS_SCRIPT_MALAYALAM)

pattern SCRIPT_MANDAIC :: Script
pattern SCRIPT_MANDAIC = Script (#const KBTS_SCRIPT_MANDAIC)

pattern SCRIPT_MANICHAEAN :: Script
pattern SCRIPT_MANICHAEAN = Script (#const KBTS_SCRIPT_MANICHAEAN)

pattern SCRIPT_MARCHEN :: Script
pattern SCRIPT_MARCHEN = Script (#const KBTS_SCRIPT_MARCHEN)

pattern SCRIPT_MASARAM_GONDI :: Script
pattern SCRIPT_MASARAM_GONDI = Script (#const KBTS_SCRIPT_MASARAM_GONDI)

pattern SCRIPT_MEDEFAIDRIN :: Script
pattern SCRIPT_MEDEFAIDRIN = Script (#const KBTS_SCRIPT_MEDEFAIDRIN)

pattern SCRIPT_MEETEI_MAYEK :: Script
pattern SCRIPT_MEETEI_MAYEK = Script (#const KBTS_SCRIPT_MEETEI_MAYEK)

pattern SCRIPT_MENDE_KIKAKUI :: Script
pattern SCRIPT_MENDE_KIKAKUI = Script (#const KBTS_SCRIPT_MENDE_KIKAKUI)

pattern SCRIPT_MEROITIC_CURSIVE :: Script
pattern SCRIPT_MEROITIC_CURSIVE = Script (#const KBTS_SCRIPT_MEROITIC_CURSIVE)

pattern SCRIPT_MEROITIC_HIEROGLYPHS :: Script
pattern SCRIPT_MEROITIC_HIEROGLYPHS = Script (#const KBTS_SCRIPT_MEROITIC_HIEROGLYPHS)

pattern SCRIPT_MIAO :: Script
pattern SCRIPT_MIAO = Script (#const KBTS_SCRIPT_MIAO)

pattern SCRIPT_MODI :: Script
pattern SCRIPT_MODI = Script (#const KBTS_SCRIPT_MODI)

pattern SCRIPT_MONGOLIAN :: Script
pattern SCRIPT_MONGOLIAN = Script (#const KBTS_SCRIPT_MONGOLIAN)

pattern SCRIPT_MRO :: Script
pattern SCRIPT_MRO = Script (#const KBTS_SCRIPT_MRO)

pattern SCRIPT_MULTANI :: Script
pattern SCRIPT_MULTANI = Script (#const KBTS_SCRIPT_MULTANI)

pattern SCRIPT_MYANMAR :: Script
pattern SCRIPT_MYANMAR = Script (#const KBTS_SCRIPT_MYANMAR)

pattern SCRIPT_NABATAEAN :: Script
pattern SCRIPT_NABATAEAN = Script (#const KBTS_SCRIPT_NABATAEAN)

pattern SCRIPT_NAG_MUNDARI :: Script
pattern SCRIPT_NAG_MUNDARI = Script (#const KBTS_SCRIPT_NAG_MUNDARI)

pattern SCRIPT_NANDINAGARI :: Script
pattern SCRIPT_NANDINAGARI = Script (#const KBTS_SCRIPT_NANDINAGARI)

pattern SCRIPT_NEWA :: Script
pattern SCRIPT_NEWA = Script (#const KBTS_SCRIPT_NEWA)

pattern SCRIPT_NEW_TAI_LUE :: Script
pattern SCRIPT_NEW_TAI_LUE = Script (#const KBTS_SCRIPT_NEW_TAI_LUE)

pattern SCRIPT_NKO :: Script
pattern SCRIPT_NKO = Script (#const KBTS_SCRIPT_NKO)

pattern SCRIPT_NUSHU :: Script
pattern SCRIPT_NUSHU = Script (#const KBTS_SCRIPT_NUSHU)

pattern SCRIPT_NYIAKENG_PUACHUE_HMONG :: Script
pattern SCRIPT_NYIAKENG_PUACHUE_HMONG = Script (#const KBTS_SCRIPT_NYIAKENG_PUACHUE_HMONG)

pattern SCRIPT_OGHAM :: Script
pattern SCRIPT_OGHAM = Script (#const KBTS_SCRIPT_OGHAM)

pattern SCRIPT_OL_CHIKI :: Script
pattern SCRIPT_OL_CHIKI = Script (#const KBTS_SCRIPT_OL_CHIKI)

pattern SCRIPT_OL_ONAL :: Script
pattern SCRIPT_OL_ONAL = Script (#const KBTS_SCRIPT_OL_ONAL)

pattern SCRIPT_OLD_ITALIC :: Script
pattern SCRIPT_OLD_ITALIC = Script (#const KBTS_SCRIPT_OLD_ITALIC)

pattern SCRIPT_OLD_HUNGARIAN :: Script
pattern SCRIPT_OLD_HUNGARIAN = Script (#const KBTS_SCRIPT_OLD_HUNGARIAN)

pattern SCRIPT_OLD_NORTH_ARABIAN :: Script
pattern SCRIPT_OLD_NORTH_ARABIAN = Script (#const KBTS_SCRIPT_OLD_NORTH_ARABIAN)

pattern SCRIPT_OLD_PERMIC :: Script
pattern SCRIPT_OLD_PERMIC = Script (#const KBTS_SCRIPT_OLD_PERMIC)

pattern SCRIPT_OLD_PERSIAN_CUNEIFORM :: Script
pattern SCRIPT_OLD_PERSIAN_CUNEIFORM = Script (#const KBTS_SCRIPT_OLD_PERSIAN_CUNEIFORM)

pattern SCRIPT_OLD_SOGDIAN :: Script
pattern SCRIPT_OLD_SOGDIAN = Script (#const KBTS_SCRIPT_OLD_SOGDIAN)

pattern SCRIPT_OLD_SOUTH_ARABIAN :: Script
pattern SCRIPT_OLD_SOUTH_ARABIAN = Script (#const KBTS_SCRIPT_OLD_SOUTH_ARABIAN)

pattern SCRIPT_OLD_TURKIC :: Script
pattern SCRIPT_OLD_TURKIC = Script (#const KBTS_SCRIPT_OLD_TURKIC)

pattern SCRIPT_OLD_UYGHUR :: Script
pattern SCRIPT_OLD_UYGHUR = Script (#const KBTS_SCRIPT_OLD_UYGHUR)

pattern SCRIPT_ODIA :: Script
pattern SCRIPT_ODIA = Script (#const KBTS_SCRIPT_ODIA)

pattern SCRIPT_OSAGE :: Script
pattern SCRIPT_OSAGE = Script (#const KBTS_SCRIPT_OSAGE)

pattern SCRIPT_OSMANYA :: Script
pattern SCRIPT_OSMANYA = Script (#const KBTS_SCRIPT_OSMANYA)

pattern SCRIPT_PAHAWH_HMONG :: Script
pattern SCRIPT_PAHAWH_HMONG = Script (#const KBTS_SCRIPT_PAHAWH_HMONG)

pattern SCRIPT_PALMYRENE :: Script
pattern SCRIPT_PALMYRENE = Script (#const KBTS_SCRIPT_PALMYRENE)

pattern SCRIPT_PAU_CIN_HAU :: Script
pattern SCRIPT_PAU_CIN_HAU = Script (#const KBTS_SCRIPT_PAU_CIN_HAU)

pattern SCRIPT_PHAGS_PA :: Script
pattern SCRIPT_PHAGS_PA = Script (#const KBTS_SCRIPT_PHAGS_PA)

pattern SCRIPT_PHOENICIAN :: Script
pattern SCRIPT_PHOENICIAN = Script (#const KBTS_SCRIPT_PHOENICIAN)

pattern SCRIPT_PSALTER_PAHLAVI :: Script
pattern SCRIPT_PSALTER_PAHLAVI = Script (#const KBTS_SCRIPT_PSALTER_PAHLAVI)

pattern SCRIPT_REJANG :: Script
pattern SCRIPT_REJANG = Script (#const KBTS_SCRIPT_REJANG)

pattern SCRIPT_RUNIC :: Script
pattern SCRIPT_RUNIC = Script (#const KBTS_SCRIPT_RUNIC)

pattern SCRIPT_SAMARITAN :: Script
pattern SCRIPT_SAMARITAN = Script (#const KBTS_SCRIPT_SAMARITAN)

pattern SCRIPT_SAURASHTRA :: Script
pattern SCRIPT_SAURASHTRA = Script (#const KBTS_SCRIPT_SAURASHTRA)

pattern SCRIPT_SHARADA :: Script
pattern SCRIPT_SHARADA = Script (#const KBTS_SCRIPT_SHARADA)

pattern SCRIPT_SHAVIAN :: Script
pattern SCRIPT_SHAVIAN = Script (#const KBTS_SCRIPT_SHAVIAN)

pattern SCRIPT_SIDDHAM :: Script
pattern SCRIPT_SIDDHAM = Script (#const KBTS_SCRIPT_SIDDHAM)

pattern SCRIPT_SIGN_WRITING :: Script
pattern SCRIPT_SIGN_WRITING = Script (#const KBTS_SCRIPT_SIGN_WRITING)

pattern SCRIPT_SOGDIAN :: Script
pattern SCRIPT_SOGDIAN = Script (#const KBTS_SCRIPT_SOGDIAN)

pattern SCRIPT_SINHALA :: Script
pattern SCRIPT_SINHALA = Script (#const KBTS_SCRIPT_SINHALA)

pattern SCRIPT_SORA_SOMPENG :: Script
pattern SCRIPT_SORA_SOMPENG = Script (#const KBTS_SCRIPT_SORA_SOMPENG)

pattern SCRIPT_SOYOMBO :: Script
pattern SCRIPT_SOYOMBO = Script (#const KBTS_SCRIPT_SOYOMBO)

pattern SCRIPT_SUMERO_AKKADIAN_CUNEIFORM :: Script
pattern SCRIPT_SUMERO_AKKADIAN_CUNEIFORM = Script (#const KBTS_SCRIPT_SUMERO_AKKADIAN_CUNEIFORM)

pattern SCRIPT_SUNDANESE :: Script
pattern SCRIPT_SUNDANESE = Script (#const KBTS_SCRIPT_SUNDANESE)

pattern SCRIPT_SUNUWAR :: Script
pattern SCRIPT_SUNUWAR = Script (#const KBTS_SCRIPT_SUNUWAR)

pattern SCRIPT_SYLOTI_NAGRI :: Script
pattern SCRIPT_SYLOTI_NAGRI = Script (#const KBTS_SCRIPT_SYLOTI_NAGRI)

pattern SCRIPT_SYRIAC :: Script
pattern SCRIPT_SYRIAC = Script (#const KBTS_SCRIPT_SYRIAC)

pattern SCRIPT_TAGALOG :: Script
pattern SCRIPT_TAGALOG = Script (#const KBTS_SCRIPT_TAGALOG)

pattern SCRIPT_TAGBANWA :: Script
pattern SCRIPT_TAGBANWA = Script (#const KBTS_SCRIPT_TAGBANWA)

pattern SCRIPT_TAI_LE :: Script
pattern SCRIPT_TAI_LE = Script (#const KBTS_SCRIPT_TAI_LE)

pattern SCRIPT_TAI_THAM :: Script
pattern SCRIPT_TAI_THAM = Script (#const KBTS_SCRIPT_TAI_THAM)

pattern SCRIPT_TAI_VIET :: Script
pattern SCRIPT_TAI_VIET = Script (#const KBTS_SCRIPT_TAI_VIET)

pattern SCRIPT_TAKRI :: Script
pattern SCRIPT_TAKRI = Script (#const KBTS_SCRIPT_TAKRI)

pattern SCRIPT_TAMIL :: Script
pattern SCRIPT_TAMIL = Script (#const KBTS_SCRIPT_TAMIL)

pattern SCRIPT_TANGSA :: Script
pattern SCRIPT_TANGSA = Script (#const KBTS_SCRIPT_TANGSA)

pattern SCRIPT_TANGUT :: Script
pattern SCRIPT_TANGUT = Script (#const KBTS_SCRIPT_TANGUT)

pattern SCRIPT_TELUGU :: Script
pattern SCRIPT_TELUGU = Script (#const KBTS_SCRIPT_TELUGU)

pattern SCRIPT_THAANA :: Script
pattern SCRIPT_THAANA = Script (#const KBTS_SCRIPT_THAANA)

pattern SCRIPT_THAI :: Script
pattern SCRIPT_THAI = Script (#const KBTS_SCRIPT_THAI)

pattern SCRIPT_TIBETAN :: Script
pattern SCRIPT_TIBETAN = Script (#const KBTS_SCRIPT_TIBETAN)

pattern SCRIPT_TIFINAGH :: Script
pattern SCRIPT_TIFINAGH = Script (#const KBTS_SCRIPT_TIFINAGH)

pattern SCRIPT_TIRHUTA :: Script
pattern SCRIPT_TIRHUTA = Script (#const KBTS_SCRIPT_TIRHUTA)

pattern SCRIPT_TODHRI :: Script
pattern SCRIPT_TODHRI = Script (#const KBTS_SCRIPT_TODHRI)

pattern SCRIPT_TOTO :: Script
pattern SCRIPT_TOTO = Script (#const KBTS_SCRIPT_TOTO)

pattern SCRIPT_TULU_TIGALARI :: Script
pattern SCRIPT_TULU_TIGALARI = Script (#const KBTS_SCRIPT_TULU_TIGALARI)

pattern SCRIPT_UGARITIC_CUNEIFORM :: Script
pattern SCRIPT_UGARITIC_CUNEIFORM = Script (#const KBTS_SCRIPT_UGARITIC_CUNEIFORM)

pattern SCRIPT_VAI :: Script
pattern SCRIPT_VAI = Script (#const KBTS_SCRIPT_VAI)

pattern SCRIPT_VITHKUQI :: Script
pattern SCRIPT_VITHKUQI = Script (#const KBTS_SCRIPT_VITHKUQI)

pattern SCRIPT_WANCHO :: Script
pattern SCRIPT_WANCHO = Script (#const KBTS_SCRIPT_WANCHO)

pattern SCRIPT_WARANG_CITI :: Script
pattern SCRIPT_WARANG_CITI = Script (#const KBTS_SCRIPT_WARANG_CITI)

pattern SCRIPT_YEZIDI :: Script
pattern SCRIPT_YEZIDI = Script (#const KBTS_SCRIPT_YEZIDI)

pattern SCRIPT_YI :: Script
pattern SCRIPT_YI = Script (#const KBTS_SCRIPT_YI)

pattern SCRIPT_ZANABAZAR_SQUARE :: Script
pattern SCRIPT_ZANABAZAR_SQUARE = Script (#const KBTS_SCRIPT_ZANABAZAR_SQUARE)
