module Render.Unlit.Colored.Code
  ( vert
  , frag
  ) where

import RIO

import Render.Code (Code, glsl)
import Render.DescSets.Set0.Code (set0binding0)

vert :: Code
vert = fromString
  [glsl|
    #version 450

    ${set0binding0}

    layout(location = 0) in vec3 vPosition;
    layout(location = 1) in vec4 vColor;

    layout(location = 2) in mat4 iModel;

    layout(location = 0) out vec4 fColor;

    void main() {
      vec4 fPosition = iModel * vec4(vPosition, 1.0);

      gl_Position
        = scene.projection
        * scene.view
        * fPosition;

      fColor = vColor;
      fColor.rgb * fColor.a;
    }
  |]

frag :: Code
frag = fromString
  [glsl|
    #version 450

    layout(location = 0) in vec4 fColor;
    layout(location = 0) out vec4 outColor;

    void main() {
      outColor = fColor;
    }
  |]
