module Codec.Ktx2
  ( Ktx2(..)
  ) where

import Codec.Ktx.KeyValue (KeyValueData)
import Codec.Ktx2.DFD qualified as DFD
import Codec.Ktx2.Header (Header)
import Data.ByteString (ByteString)
import Data.Vector (Vector)
import Data.Word (Word64)
import GHC.Generics (Generic)

{- | Shared wrapper for reading and writing files.

When uploading textures to GPU prefer reading only the needed chunks and using direct transfers.
-}
data Ktx2 = Ktx2
  { header :: Header
  , dfdBlocks :: Vector DFD.Block
  , kvd :: KeyValueData
  , sgd :: ByteString
  , levels :: [(Maybe Word64, ByteString)]
  }
  deriving (Eq, Show, Generic)
