> {-# OPTIONS_HADDOCK show-extensions #-}
> {-|
> Module    : LTK.Decide.GLPT
> Copyright : (c) 2021-2024 Dakotah Lambert
> License   : MIT

> This module implements an algorithm to decide whether a syntactic
> semigroup \(S\) is, on certain submonoids, Piecewise Testable (MePT).
> This is the case iff for each of its idempotents \(e\) it holds that
> \(eXe\) is \(\mathcal{J}\)-trivial, where X is the set generated by
> {ege : ugv=e for some u,v}.
>
> @since 1.0
> -}
> module LTK.Decide.GLPT (isGLPT, isGLPTM, isGLPTs) where

> import Data.Representation.FiniteSemigroup

> import LTK.FSA
> import LTK.Algebra(SynMon)

> -- |True iff the syntactic monoid of the automaton is in
> -- \(\mathbf{M_e J}\).
> -- This is a generalization of LPT in the same way that
> -- GLT is a generalization of LT.
> isGLPT :: (Ord n, Ord e) => FSA n e -> Bool
> isGLPT = isGLPTs . syntacticSemigroup

> -- |True iff the given monoid is in \(\mathbf{M_e J}\).
> isGLPTM :: (Ord n, Ord e) => SynMon n e -> Bool
> isGLPTM = isGLPT

> -- |True iff the given semigroup is in \(\mathbf{M_e J}\).
> --
> -- @since 1.2
> isGLPTs :: FiniteSemigroupRep s => s -> Bool
> isGLPTs = all isJTrivial . emee
