module Lazy.Scope.Test.HandleCloses where

import Data.List qualified as L
import Data.ByteString.Lazy qualified as LBS
import Foreign.C.String (withCString)
import Lazy.Scope qualified as S
import Relude
import System.IO (openTempFile, hClose, hPutStrLn)
import System.Posix.Internals (c_unlink)
import Test.Tasty (TestTree, testGroup, withResource)
import Test.Tasty.QuickCheck (testProperty, ioProperty)


n :: Int
n = 1000

test_suite :: TestTree
test_suite = withResource
  (do (fn, h) <- openTempFile "." "lazy-hclose-test.tmp"; hPutStrLn h "xaoeuaoeuaoeuaoeuaoeuaoeuao\naoeuaoeuaoeu"; hClose h; pure fn)
  removeFile $ \fn' ->
    testGroup "LazyHClose"
    [ testProperty "Testing hGetLine" $ ioProperty $
        forM_ [1..n] $ const $ do
          fn <- fn'
          r <- S.withBinaryFile fn ReadMode $ \h -> S.hGetLine h
          L.last r `seq` return ()
          appendFile fn "" -- will fail, if fn has not been closed yet
    , testProperty "Testing With lazy hGetContents" $ ioProperty $
        forM_ [1..n] $ const $ do
          fn <- fn'
          S.withBinaryFile fn ReadMode $
            \h -> do
              r <- S.hGetContents h
              S.unsnoc r `seq` return ()
          appendFile fn "" -- will fail, if fn has not been closed yet
    , testProperty "Testing lazy withBinaryFile seq result" $ ioProperty $
        forM_ [1..n] $ const $ do
          fn <- fn'
          r <- S.withBinaryFile fn ReadMode (S.hGetContents >=> S.toLbs)
          LBS.unsnoc r `seq` return ()
          appendFile fn "" -- will fail, if fn has not been closed yet
    ]

removeFile :: String -> IO ()
removeFile fn = void $ withCString fn c_unlink
