{-# LANGUAGE OverloadedStrings #-}

-- | Demo filter policy / bloom filter

module Main where

import Control.Monad.IO.Class (liftIO)
import Data.BloomFilter
import Data.BloomFilter.Easy  (easyList)
import Data.BloomFilter.Hash  (cheapHashes)
import Data.ByteString.Char8  (take)
import Data.Default

import Database.LevelDB

import qualified Data.Serialize as S


builtinBloom :: IO ()
builtinBloom = runResourceT $ do
    bloom <- bloomFilter 10
    db <- open "/tmp/lvlbloomtest"
               defaultOptions { createIfMissing = True
                              , filterPolicy    = Just . Left $ bloom
                              }

    put db def "zzz" "zzz"
    put db def "yyy" "yyy"
    put db def "xxx" "xxx"

    get db def "yyy" >>= liftIO . print
    get db def "xxx" >>= liftIO . print

    return ()

customFilterPolicy :: IO ()
customFilterPolicy = runResourceT $ do
    let create bs     = S.encode . bitArrayB $ easyList 0.01 bs
        maymatch k bs = False
        fp = FilterPolicy
               { fpName = "custom.filter.policy"
               , createFilter = create
               , keyMayMatch  = maymatch
               }

    db <- open "/tmp/lvlfptest"
               defaultOptions { createIfMissing = True
                              , filterPolicy    = Just . Right $ fp
                              }

    put db def "zzz" "zzz"
    put db def "yyy" "yyy"
    put db def "xxx" "xxx"

    get db def "yyy" >>= liftIO . print
    get db def "xxx" >>= liftIO . print

    return ()


main :: IO ()
main = do
    builtinBloom
    customFilterPolicy
