{-# LANGUAGE OverloadedStrings #-}
module Main where

import Control.Monad
import Control.Monad.IO.Class       (liftIO)
import Data.Default
import Data.Word
import Prelude               hiding (putStrLn)
import System.FilePath

import qualified Data.ByteString       as BS
import qualified Data.ByteString.Char8 as BC

import Database.LevelDB
import Debug.Trace


main :: IO ()
main = runResourceT $ do
    db <- open "/tmp/giantwrite"
               defaultOptions { createIfMissing = True }

    let w x = put db def x x
    mapM_ (w . BC.pack . show) [1..10000000]

    approximateSize db ("0", "z") >>= liftIO . print
