
-- generated by using spec/Declarations.yaml

{-# LANGUAGE DataKinds #-}
{-# LANGUAGE PolyKinds #-}
{-# LANGUAGE TemplateHaskell #-}
{-# LANGUAGE QuasiQuotes #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE OverloadedStrings #-}

module Torch.Internal.Unmanaged.Native.Native5 where


import Foreign.C.String
import Foreign.C.Types
import Foreign
import Torch.Internal.Type

import qualified Language.C.Inline.Cpp as C
import qualified Language.C.Inline.Cpp.Unsafe as C
import qualified Language.C.Inline.Context as C
import qualified Language.C.Types as C

C.context $ C.cppCtx <> mempty { C.ctxTypesTable = typeTable }

C.include "<vector>"
C.include "<ATen/Tensor.h>"
C.include "<ATen/Functions.h>"


std_tlb
  :: Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> IO (Ptr Tensor)
std_tlb _self _dim _unbiased =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _unbiased)));
  }|]

std_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
std_tl _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)));
  }|]

std_tllb
  :: Ptr Tensor
  -> Ptr IntArray
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
std_tllb _self _dim _correction _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(int64_t _correction)
  , $(bool _keepdim)));
  }|]

std_tll
  :: Ptr Tensor
  -> Ptr IntArray
  -> Int64
  -> IO (Ptr Tensor)
std_tll _self _dim _correction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(int64_t _correction)));
  }|]

-- std_t
--   :: Ptr Tensor
--   -> IO (Ptr Tensor)
-- std_t _self =
--   [C.throwBlock| at::Tensor* { return new at::Tensor(at::std(
--     *$(at::Tensor* _self)));
--   }|]

std_mean_tb
  :: Ptr Tensor
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
std_mean_tb _self _unbiased =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::std_mean(
    *$(at::Tensor* _self)
  , $(bool _unbiased)));
  }|]

std_mean_t
  :: Ptr Tensor
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
std_mean_t _self =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::std_mean(
    *$(at::Tensor* _self)));
  }|]

std_mean_tlbb
  :: Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
std_mean_tlbb _self _dim _unbiased _keepdim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::std_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _unbiased)
  , $(bool _keepdim)));
  }|]

std_mean_tlb
  :: Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
std_mean_tlb _self _dim _unbiased =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::std_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _unbiased)));
  }|]

std_mean_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
std_mean_tl _self _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::std_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)));
  }|]

std_mean_tllb
  :: Ptr Tensor
  -> Ptr IntArray
  -> Int64
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
std_mean_tllb _self _dim _correction _keepdim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::std_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(int64_t _correction)
  , $(bool _keepdim)));
  }|]

std_mean_tll
  :: Ptr Tensor
  -> Ptr IntArray
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
std_mean_tll _self _dim _correction =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::std_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(int64_t _correction)));
  }|]

std_mean_tNbb
  :: Ptr Tensor
  -> Ptr DimnameList
  -> CBool
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
std_mean_tNbb _self _dim _unbiased _keepdim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::std_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(bool _unbiased)
  , $(bool _keepdim)));
  }|]

std_mean_tNb
  :: Ptr Tensor
  -> Ptr DimnameList
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
std_mean_tNb _self _dim _unbiased =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::std_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(bool _unbiased)));
  }|]

std_mean_tN
  :: Ptr Tensor
  -> Ptr DimnameList
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
std_mean_tN _self _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::std_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)));
  }|]

std_mean_tNlb
  :: Ptr Tensor
  -> Ptr DimnameList
  -> Int64
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
std_mean_tNlb _self _dim _correction _keepdim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::std_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(int64_t _correction)
  , $(bool _keepdim)));
  }|]

std_mean_tNl
  :: Ptr Tensor
  -> Ptr DimnameList
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
std_mean_tNl _self _dim _correction =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::std_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(int64_t _correction)));
  }|]

std_out_ttlbb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> CBool
  -> IO (Ptr Tensor)
std_out_ttlbb _out _self _dim _unbiased _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _unbiased)
  , $(bool _keepdim)));
  }|]

std_out_ttlb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> IO (Ptr Tensor)
std_out_ttlb _out _self _dim _unbiased =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _unbiased)));
  }|]

std_out_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
std_out_ttl _out _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)));
  }|]

std_out_ttllb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
std_out_ttllb _out _self _dim _correction _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(int64_t _correction)
  , $(bool _keepdim)));
  }|]

std_out_ttll
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Int64
  -> IO (Ptr Tensor)
std_out_ttll _out _self _dim _correction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(int64_t _correction)));
  }|]

std_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
std_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

std_tNbb
  :: Ptr Tensor
  -> Ptr DimnameList
  -> CBool
  -> CBool
  -> IO (Ptr Tensor)
std_tNbb _self _dim _unbiased _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(bool _unbiased)
  , $(bool _keepdim)));
  }|]

std_tNb
  :: Ptr Tensor
  -> Ptr DimnameList
  -> CBool
  -> IO (Ptr Tensor)
std_tNb _self _dim _unbiased =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(bool _unbiased)));
  }|]

std_tN
  :: Ptr Tensor
  -> Ptr DimnameList
  -> IO (Ptr Tensor)
std_tN _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)));
  }|]

std_out_ttNbb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr DimnameList
  -> CBool
  -> CBool
  -> IO (Ptr Tensor)
std_out_ttNbb _out _self _dim _unbiased _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(bool _unbiased)
  , $(bool _keepdim)));
  }|]

std_out_ttNb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr DimnameList
  -> CBool
  -> IO (Ptr Tensor)
std_out_ttNb _out _self _dim _unbiased =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(bool _unbiased)));
  }|]

std_out_ttN
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr DimnameList
  -> IO (Ptr Tensor)
std_out_ttN _out _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)));
  }|]

std_tNlb
  :: Ptr Tensor
  -> Ptr DimnameList
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
std_tNlb _self _dim _correction _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(int64_t _correction)
  , $(bool _keepdim)));
  }|]

std_tNl
  :: Ptr Tensor
  -> Ptr DimnameList
  -> Int64
  -> IO (Ptr Tensor)
std_tNl _self _dim _correction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(int64_t _correction)));
  }|]

std_out_ttNlb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr DimnameList
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
std_out_ttNlb _out _self _dim _correction _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(int64_t _correction)
  , $(bool _keepdim)));
  }|]

std_out_ttNl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr DimnameList
  -> Int64
  -> IO (Ptr Tensor)
std_out_ttNl _out _self _dim _correction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::std_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(int64_t _correction)));
  }|]

prod_ts
  :: Ptr Tensor
  -> ScalarType
  -> IO (Ptr Tensor)
prod_ts _self _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::prod(
    *$(at::Tensor* _self)
  , $(at::ScalarType _dtype)));
  }|]

prod_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
prod_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::prod(
    *$(at::Tensor* _self)));
  }|]

prod_tlbs
  :: Ptr Tensor
  -> Int64
  -> CBool
  -> ScalarType
  -> IO (Ptr Tensor)
prod_tlbs _self _dim _keepdim _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::prod(
    *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _keepdim)
  , $(at::ScalarType _dtype)));
  }|]

prod_tlb
  :: Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
prod_tlb _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::prod(
    *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _keepdim)));
  }|]

prod_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
prod_tl _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::prod(
    *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

prod_out_ttlbs
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> CBool
  -> ScalarType
  -> IO (Ptr Tensor)
prod_out_ttlbs _out _self _dim _keepdim _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::prod_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _keepdim)
  , $(at::ScalarType _dtype)));
  }|]

prod_out_ttlb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
prod_out_ttlb _out _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::prod_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _keepdim)));
  }|]

prod_out_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
prod_out_ttl _out _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::prod_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

prod_tnbs
  :: Ptr Tensor
  -> Ptr Dimname
  -> CBool
  -> ScalarType
  -> IO (Ptr Tensor)
prod_tnbs _self _dim _keepdim _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::prod(
    *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)
  , $(bool _keepdim)
  , $(at::ScalarType _dtype)));
  }|]

prod_tnb
  :: Ptr Tensor
  -> Ptr Dimname
  -> CBool
  -> IO (Ptr Tensor)
prod_tnb _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::prod(
    *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)
  , $(bool _keepdim)));
  }|]

prod_tn
  :: Ptr Tensor
  -> Ptr Dimname
  -> IO (Ptr Tensor)
prod_tn _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::prod(
    *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)));
  }|]

prod_out_ttnbs
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Dimname
  -> CBool
  -> ScalarType
  -> IO (Ptr Tensor)
prod_out_ttnbs _out _self _dim _keepdim _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::prod_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)
  , $(bool _keepdim)
  , $(at::ScalarType _dtype)));
  }|]

prod_out_ttnb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Dimname
  -> CBool
  -> IO (Ptr Tensor)
prod_out_ttnb _out _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::prod_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)
  , $(bool _keepdim)));
  }|]

prod_out_ttn
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Dimname
  -> IO (Ptr Tensor)
prod_out_ttn _out _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::prod_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)));
  }|]

t_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
t_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::t(
    *$(at::Tensor* _self)));
  }|]

tan_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
tan_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::tan(
    *$(at::Tensor* _self)));
  }|]

tan__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
tan__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::tan_(
    *$(at::Tensor* _self)));
  }|]

tan_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
tan_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::tan_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

tanh_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
tanh_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::tanh(
    *$(at::Tensor* _self)));
  }|]

tanh__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
tanh__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::tanh_(
    *$(at::Tensor* _self)));
  }|]

tanh_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
tanh_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::tanh_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

tensordot_ttll
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr IntArray
  -> IO (Ptr Tensor)
tensordot_ttll _self _other _dims_self _dims_other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::tensordot(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)
  , *$(std::vector<int64_t>* _dims_self)
  , *$(std::vector<int64_t>* _dims_other)));
  }|]

tensordot_out_tttll
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr IntArray
  -> IO (Ptr Tensor)
tensordot_out_tttll _out _self _other _dims_self _dims_other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::tensordot_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _other)
  , *$(std::vector<int64_t>* _dims_self)
  , *$(std::vector<int64_t>* _dims_other)));
  }|]

threshold_tss
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
threshold_tss _self _threshold _value =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::threshold(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _threshold)
  , *$(at::Scalar* _value)));
  }|]

threshold__tss
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
threshold__tss _self _threshold _value =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::threshold_(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _threshold)
  , *$(at::Scalar* _value)));
  }|]

threshold_out_ttss
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
threshold_out_ttss _out _self _threshold _value =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::threshold_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Scalar* _threshold)
  , *$(at::Scalar* _value)));
  }|]

threshold_backward_out_ttts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
threshold_backward_out_ttts _grad_input _grad_output _self _threshold =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::threshold_backward_out(
    *$(at::Tensor* _grad_input)
  , *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Scalar* _threshold)));
  }|]

threshold_backward_tts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
threshold_backward_tts _grad_output _self _threshold =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::threshold_backward(
    *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Scalar* _threshold)));
  }|]

tile_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
tile_tl _self _dims =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::tile(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dims)));
  }|]

transpose_tll
  :: Ptr Tensor
  -> Int64
  -> Int64
  -> IO (Ptr Tensor)
transpose_tll _self _dim0 _dim1 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::transpose(
    *$(at::Tensor* _self)
  , $(int64_t _dim0)
  , $(int64_t _dim1)));
  }|]

transpose_tnn
  :: Ptr Tensor
  -> Ptr Dimname
  -> Ptr Dimname
  -> IO (Ptr Tensor)
transpose_tnn _self _dim0 _dim1 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::transpose(
    *$(at::Tensor* _self)
  , *$(at::Dimname* _dim0)
  , *$(at::Dimname* _dim1)));
  }|]

_mkldnn_transpose_tll
  :: Ptr Tensor
  -> Int64
  -> Int64
  -> IO (Ptr Tensor)
_mkldnn_transpose_tll _self _dim0 _dim1 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_mkldnn_transpose(
    *$(at::Tensor* _self)
  , $(int64_t _dim0)
  , $(int64_t _dim1)));
  }|]

_mkldnn_transpose__tll
  :: Ptr Tensor
  -> Int64
  -> Int64
  -> IO (Ptr Tensor)
_mkldnn_transpose__tll _self _dim0 _dim1 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_mkldnn_transpose_(
    *$(at::Tensor* _self)
  , $(int64_t _dim0)
  , $(int64_t _dim1)));
  }|]

one_hot_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
one_hot_tl _self _num_classes =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::one_hot(
    *$(at::Tensor* _self)
  , $(int64_t _num_classes)));
  }|]

one_hot_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
one_hot_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::one_hot(
    *$(at::Tensor* _self)));
  }|]

flip_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
flip_tl _self _dims =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::flip(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dims)));
  }|]

fliplr_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
fliplr_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::fliplr(
    *$(at::Tensor* _self)));
  }|]

flipud_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
flipud_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::flipud(
    *$(at::Tensor* _self)));
  }|]

roll_tll
  :: Ptr Tensor
  -> Ptr IntArray
  -> Ptr IntArray
  -> IO (Ptr Tensor)
roll_tll _self _shifts _dims =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::roll(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _shifts)
  , *$(std::vector<int64_t>* _dims)));
  }|]

roll_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
roll_tl _self _shifts =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::roll(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _shifts)));
  }|]

rot90_tll
  :: Ptr Tensor
  -> Int64
  -> Ptr IntArray
  -> IO (Ptr Tensor)
rot90_tll _self _k _dims =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::rot90(
    *$(at::Tensor* _self)
  , $(int64_t _k)
  , *$(std::vector<int64_t>* _dims)));
  }|]

rot90_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
rot90_tl _self _k =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::rot90(
    *$(at::Tensor* _self)
  , $(int64_t _k)));
  }|]

rot90_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
rot90_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::rot90(
    *$(at::Tensor* _self)));
  }|]

trapezoid_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
trapezoid_ttl _y _x _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::trapezoid(
    *$(at::Tensor* _y)
  , *$(at::Tensor* _x)
  , $(int64_t _dim)));
  }|]

trapezoid_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
trapezoid_tt _y _x =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::trapezoid(
    *$(at::Tensor* _y)
  , *$(at::Tensor* _x)));
  }|]

trapezoid_tsl
  :: Ptr Tensor
  -> Ptr Scalar
  -> Int64
  -> IO (Ptr Tensor)
trapezoid_tsl _y _dx _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::trapezoid(
    *$(at::Tensor* _y)
  , *$(at::Scalar* _dx)
  , $(int64_t _dim)));
  }|]

trapezoid_ts
  :: Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
trapezoid_ts _y _dx =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::trapezoid(
    *$(at::Tensor* _y)
  , *$(at::Scalar* _dx)));
  }|]

trapezoid_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
trapezoid_t _y =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::trapezoid(
    *$(at::Tensor* _y)));
  }|]

trapz_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
trapz_ttl _y _x _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::trapz(
    *$(at::Tensor* _y)
  , *$(at::Tensor* _x)
  , $(int64_t _dim)));
  }|]

trapz_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
trapz_tt _y _x =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::trapz(
    *$(at::Tensor* _y)
  , *$(at::Tensor* _x)));
  }|]

trapz_tdl
  :: Ptr Tensor
  -> CDouble
  -> Int64
  -> IO (Ptr Tensor)
trapz_tdl _y _dx _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::trapz(
    *$(at::Tensor* _y)
  , $(double _dx)
  , $(int64_t _dim)));
  }|]

trapz_td
  :: Ptr Tensor
  -> CDouble
  -> IO (Ptr Tensor)
trapz_td _y _dx =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::trapz(
    *$(at::Tensor* _y)
  , $(double _dx)));
  }|]

trapz_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
trapz_t _y =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::trapz(
    *$(at::Tensor* _y)));
  }|]

_transform_bias_rescale_qkv_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor)))
_transform_bias_rescale_qkv_ttl _qkv _qkv_bias _num_heads =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor>(at::_transform_bias_rescale_qkv(
    *$(at::Tensor* _qkv)
  , *$(at::Tensor* _qkv_bias)
  , $(int64_t _num_heads)));
  }|]

_nested_tensor_from_mask_ttb
  :: Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
_nested_tensor_from_mask_ttb _t _mask _mask_check =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_nested_tensor_from_mask(
    *$(at::Tensor* _t)
  , *$(at::Tensor* _mask)
  , $(bool _mask_check)));
  }|]

_nested_tensor_from_mask_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
_nested_tensor_from_mask_tt _t _mask =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_nested_tensor_from_mask(
    *$(at::Tensor* _t)
  , *$(at::Tensor* _mask)));
  }|]

_nested_tensor_from_mask_left_aligned_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (CBool)
_nested_tensor_from_mask_left_aligned_tt _t _mask =
  [C.throwBlock| bool { return (at::_nested_tensor_from_mask_left_aligned(
    *$(at::Tensor* _t)
  , *$(at::Tensor* _mask)));
  }|]

_nested_from_padded_ttb
  :: Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
_nested_from_padded_ttb _padded _cpu_nested_shape_example _fuse_transform_0213 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_nested_from_padded(
    *$(at::Tensor* _padded)
  , *$(at::Tensor* _cpu_nested_shape_example)
  , $(bool _fuse_transform_0213)));
  }|]

_nested_from_padded_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
_nested_from_padded_tt _padded _cpu_nested_shape_example =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_nested_from_padded(
    *$(at::Tensor* _padded)
  , *$(at::Tensor* _cpu_nested_shape_example)));
  }|]

_nested_from_padded_and_nested_example_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
_nested_from_padded_and_nested_example_tt _padded _nt_example =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_nested_from_padded_and_nested_example(
    *$(at::Tensor* _padded)
  , *$(at::Tensor* _nt_example)));
  }|]

_trilinear_tttlllll
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr IntArray
  -> Ptr IntArray
  -> Ptr IntArray
  -> Int64
  -> IO (Ptr Tensor)
_trilinear_tttlllll _i1 _i2 _i3 _expand1 _expand2 _expand3 _sumdim _unroll_dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_trilinear(
    *$(at::Tensor* _i1)
  , *$(at::Tensor* _i2)
  , *$(at::Tensor* _i3)
  , *$(std::vector<int64_t>* _expand1)
  , *$(std::vector<int64_t>* _expand2)
  , *$(std::vector<int64_t>* _expand3)
  , *$(std::vector<int64_t>* _sumdim)
  , $(int64_t _unroll_dim)));
  }|]

_trilinear_tttllll
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr IntArray
  -> Ptr IntArray
  -> Ptr IntArray
  -> IO (Ptr Tensor)
_trilinear_tttllll _i1 _i2 _i3 _expand1 _expand2 _expand3 _sumdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_trilinear(
    *$(at::Tensor* _i1)
  , *$(at::Tensor* _i2)
  , *$(at::Tensor* _i3)
  , *$(std::vector<int64_t>* _expand1)
  , *$(std::vector<int64_t>* _expand2)
  , *$(std::vector<int64_t>* _expand3)
  , *$(std::vector<int64_t>* _sumdim)));
  }|]

triplet_margin_loss_tttdddbl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CDouble
  -> CDouble
  -> CDouble
  -> CBool
  -> Int64
  -> IO (Ptr Tensor)
triplet_margin_loss_tttdddbl _anchor _positive _negative _margin _p _eps _swap _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::triplet_margin_loss(
    *$(at::Tensor* _anchor)
  , *$(at::Tensor* _positive)
  , *$(at::Tensor* _negative)
  , $(double _margin)
  , $(double _p)
  , $(double _eps)
  , $(bool _swap)
  , $(int64_t _reduction)));
  }|]

triplet_margin_loss_tttdddb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CDouble
  -> CDouble
  -> CDouble
  -> CBool
  -> IO (Ptr Tensor)
triplet_margin_loss_tttdddb _anchor _positive _negative _margin _p _eps _swap =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::triplet_margin_loss(
    *$(at::Tensor* _anchor)
  , *$(at::Tensor* _positive)
  , *$(at::Tensor* _negative)
  , $(double _margin)
  , $(double _p)
  , $(double _eps)
  , $(bool _swap)));
  }|]

triplet_margin_loss_tttddd
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CDouble
  -> CDouble
  -> CDouble
  -> IO (Ptr Tensor)
triplet_margin_loss_tttddd _anchor _positive _negative _margin _p _eps =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::triplet_margin_loss(
    *$(at::Tensor* _anchor)
  , *$(at::Tensor* _positive)
  , *$(at::Tensor* _negative)
  , $(double _margin)
  , $(double _p)
  , $(double _eps)));
  }|]

triplet_margin_loss_tttdd
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CDouble
  -> CDouble
  -> IO (Ptr Tensor)
triplet_margin_loss_tttdd _anchor _positive _negative _margin _p =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::triplet_margin_loss(
    *$(at::Tensor* _anchor)
  , *$(at::Tensor* _positive)
  , *$(at::Tensor* _negative)
  , $(double _margin)
  , $(double _p)));
  }|]

triplet_margin_loss_tttd
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CDouble
  -> IO (Ptr Tensor)
triplet_margin_loss_tttd _anchor _positive _negative _margin =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::triplet_margin_loss(
    *$(at::Tensor* _anchor)
  , *$(at::Tensor* _positive)
  , *$(at::Tensor* _negative)
  , $(double _margin)));
  }|]

triplet_margin_loss_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
triplet_margin_loss_ttt _anchor _positive _negative =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::triplet_margin_loss(
    *$(at::Tensor* _anchor)
  , *$(at::Tensor* _positive)
  , *$(at::Tensor* _negative)));
  }|]

trunc_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
trunc_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::trunc(
    *$(at::Tensor* _self)));
  }|]

trunc__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
trunc__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::trunc_(
    *$(at::Tensor* _self)));
  }|]

trunc_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
trunc_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::trunc_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

fix_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
fix_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::fix(
    *$(at::Tensor* _self)));
  }|]

fix__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
fix__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::fix_(
    *$(at::Tensor* _self)));
  }|]

fix_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
fix_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::fix_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

_has_compatible_shallow_copy_type_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (CBool)
_has_compatible_shallow_copy_type_tt _self _from =
  [C.throwBlock| bool { return (at::_has_compatible_shallow_copy_type(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _from)));
  }|]

_unique_tbb
  :: Ptr Tensor
  -> CBool
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
_unique_tbb _self _sorted _return_inverse =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::_unique(
    *$(at::Tensor* _self)
  , $(bool _sorted)
  , $(bool _return_inverse)));
  }|]

_unique_tb
  :: Ptr Tensor
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
_unique_tb _self _sorted =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::_unique(
    *$(at::Tensor* _self)
  , $(bool _sorted)));
  }|]

_unique_t
  :: Ptr Tensor
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
_unique_t _self =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::_unique(
    *$(at::Tensor* _self)));
  }|]

unique_dim_tlbbb
  :: Ptr Tensor
  -> Int64
  -> CBool
  -> CBool
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor)))
unique_dim_tlbbb _self _dim _sorted _return_inverse _return_counts =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor>(at::unique_dim(
    *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _sorted)
  , $(bool _return_inverse)
  , $(bool _return_counts)));
  }|]

unique_dim_tlbb
  :: Ptr Tensor
  -> Int64
  -> CBool
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor)))
unique_dim_tlbb _self _dim _sorted _return_inverse =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor>(at::unique_dim(
    *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _sorted)
  , $(bool _return_inverse)));
  }|]

unique_dim_tlb
  :: Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor)))
unique_dim_tlb _self _dim _sorted =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor>(at::unique_dim(
    *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _sorted)));
  }|]

unique_dim_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor)))
unique_dim_tl _self _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor>(at::unique_dim(
    *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

unique_consecutive_tbbl
  :: Ptr Tensor
  -> CBool
  -> CBool
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor)))
unique_consecutive_tbbl _self _return_inverse _return_counts _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor>(at::unique_consecutive(
    *$(at::Tensor* _self)
  , $(bool _return_inverse)
  , $(bool _return_counts)
  , $(int64_t _dim)));
  }|]

unique_consecutive_tbb
  :: Ptr Tensor
  -> CBool
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor)))
unique_consecutive_tbb _self _return_inverse _return_counts =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor>(at::unique_consecutive(
    *$(at::Tensor* _self)
  , $(bool _return_inverse)
  , $(bool _return_counts)));
  }|]

unique_consecutive_tb
  :: Ptr Tensor
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor)))
unique_consecutive_tb _self _return_inverse =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor>(at::unique_consecutive(
    *$(at::Tensor* _self)
  , $(bool _return_inverse)));
  }|]

unique_consecutive_t
  :: Ptr Tensor
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor)))
unique_consecutive_t _self =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor>(at::unique_consecutive(
    *$(at::Tensor* _self)));
  }|]

unique_dim_consecutive_tlbb
  :: Ptr Tensor
  -> Int64
  -> CBool
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor)))
unique_dim_consecutive_tlbb _self _dim _return_inverse _return_counts =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor>(at::unique_dim_consecutive(
    *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _return_inverse)
  , $(bool _return_counts)));
  }|]

unique_dim_consecutive_tlb
  :: Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor)))
unique_dim_consecutive_tlb _self _dim _return_inverse =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor>(at::unique_dim_consecutive(
    *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _return_inverse)));
  }|]

unique_dim_consecutive_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor)))
unique_dim_consecutive_tl _self _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor>(at::unique_dim_consecutive(
    *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

_unique2_tbbb
  :: Ptr Tensor
  -> CBool
  -> CBool
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor)))
_unique2_tbbb _self _sorted _return_inverse _return_counts =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor>(at::_unique2(
    *$(at::Tensor* _self)
  , $(bool _sorted)
  , $(bool _return_inverse)
  , $(bool _return_counts)));
  }|]

_unique2_tbb
  :: Ptr Tensor
  -> CBool
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor)))
_unique2_tbb _self _sorted _return_inverse =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor>(at::_unique2(
    *$(at::Tensor* _self)
  , $(bool _sorted)
  , $(bool _return_inverse)));
  }|]

_unique2_tb
  :: Ptr Tensor
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor)))
_unique2_tb _self _sorted =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor>(at::_unique2(
    *$(at::Tensor* _self)
  , $(bool _sorted)));
  }|]

_unique2_t
  :: Ptr Tensor
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor)))
_unique2_t _self =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor>(at::_unique2(
    *$(at::Tensor* _self)));
  }|]

_unsafe_view_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
_unsafe_view_tl _self _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_unsafe_view(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _size)));
  }|]

unsqueeze_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
unsqueeze_tl _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::unsqueeze(
    *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

vander_tlb
  :: Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
vander_tlb _x _N _increasing =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::vander(
    *$(at::Tensor* _x)
  , $(int64_t _N)
  , $(bool _increasing)));
  }|]

vander_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
vander_tl _x _N =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::vander(
    *$(at::Tensor* _x)
  , $(int64_t _N)));
  }|]

vander_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
vander_t _x =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::vander(
    *$(at::Tensor* _x)));
  }|]

var_tb
  :: Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
var_tb _self _unbiased =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var(
    *$(at::Tensor* _self)
  , $(bool _unbiased)));
  }|]

var_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
var_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var(
    *$(at::Tensor* _self)));
  }|]

var_tlbb
  :: Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> CBool
  -> IO (Ptr Tensor)
var_tlbb _self _dim _unbiased _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _unbiased)
  , $(bool _keepdim)));
  }|]

var_tlb
  :: Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> IO (Ptr Tensor)
var_tlb _self _dim _unbiased =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _unbiased)));
  }|]

var_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
var_tl _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)));
  }|]

var_tllb
  :: Ptr Tensor
  -> Ptr IntArray
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
var_tllb _self _dim _correction _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(int64_t _correction)
  , $(bool _keepdim)));
  }|]

var_tll
  :: Ptr Tensor
  -> Ptr IntArray
  -> Int64
  -> IO (Ptr Tensor)
var_tll _self _dim _correction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(int64_t _correction)));
  }|]

var_out_ttlbb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> CBool
  -> IO (Ptr Tensor)
var_out_ttlbb _out _self _dim _unbiased _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _unbiased)
  , $(bool _keepdim)));
  }|]

var_out_ttlb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> IO (Ptr Tensor)
var_out_ttlb _out _self _dim _unbiased =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _unbiased)));
  }|]

var_out_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
var_out_ttl _out _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)));
  }|]

var_out_ttllb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
var_out_ttllb _out _self _dim _correction _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(int64_t _correction)
  , $(bool _keepdim)));
  }|]

var_out_ttll
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Int64
  -> IO (Ptr Tensor)
var_out_ttll _out _self _dim _correction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(int64_t _correction)));
  }|]

var_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
var_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

var_tNbb
  :: Ptr Tensor
  -> Ptr DimnameList
  -> CBool
  -> CBool
  -> IO (Ptr Tensor)
var_tNbb _self _dim _unbiased _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(bool _unbiased)
  , $(bool _keepdim)));
  }|]

var_tNb
  :: Ptr Tensor
  -> Ptr DimnameList
  -> CBool
  -> IO (Ptr Tensor)
var_tNb _self _dim _unbiased =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(bool _unbiased)));
  }|]

var_tN
  :: Ptr Tensor
  -> Ptr DimnameList
  -> IO (Ptr Tensor)
var_tN _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)));
  }|]

var_out_ttNbb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr DimnameList
  -> CBool
  -> CBool
  -> IO (Ptr Tensor)
var_out_ttNbb _out _self _dim _unbiased _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(bool _unbiased)
  , $(bool _keepdim)));
  }|]

var_out_ttNb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr DimnameList
  -> CBool
  -> IO (Ptr Tensor)
var_out_ttNb _out _self _dim _unbiased =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(bool _unbiased)));
  }|]

var_out_ttN
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr DimnameList
  -> IO (Ptr Tensor)
var_out_ttN _out _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)));
  }|]

var_tNlb
  :: Ptr Tensor
  -> Ptr DimnameList
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
var_tNlb _self _dim _correction _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(int64_t _correction)
  , $(bool _keepdim)));
  }|]

var_tNl
  :: Ptr Tensor
  -> Ptr DimnameList
  -> Int64
  -> IO (Ptr Tensor)
var_tNl _self _dim _correction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(int64_t _correction)));
  }|]

var_out_ttNlb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr DimnameList
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
var_out_ttNlb _out _self _dim _correction _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(int64_t _correction)
  , $(bool _keepdim)));
  }|]

var_out_ttNl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr DimnameList
  -> Int64
  -> IO (Ptr Tensor)
var_out_ttNl _out _self _dim _correction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::var_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(int64_t _correction)));
  }|]

var_mean_tb
  :: Ptr Tensor
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
var_mean_tb _self _unbiased =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::var_mean(
    *$(at::Tensor* _self)
  , $(bool _unbiased)));
  }|]

var_mean_t
  :: Ptr Tensor
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
var_mean_t _self =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::var_mean(
    *$(at::Tensor* _self)));
  }|]

var_mean_tlbb
  :: Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
var_mean_tlbb _self _dim _unbiased _keepdim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::var_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _unbiased)
  , $(bool _keepdim)));
  }|]

var_mean_tlb
  :: Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
var_mean_tlb _self _dim _unbiased =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::var_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _unbiased)));
  }|]

var_mean_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
var_mean_tl _self _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::var_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)));
  }|]

var_mean_tllb
  :: Ptr Tensor
  -> Ptr IntArray
  -> Int64
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
var_mean_tllb _self _dim _correction _keepdim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::var_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(int64_t _correction)
  , $(bool _keepdim)));
  }|]

var_mean_tll
  :: Ptr Tensor
  -> Ptr IntArray
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
var_mean_tll _self _dim _correction =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::var_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(int64_t _correction)));
  }|]

var_mean_tNbb
  :: Ptr Tensor
  -> Ptr DimnameList
  -> CBool
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
var_mean_tNbb _self _dim _unbiased _keepdim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::var_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(bool _unbiased)
  , $(bool _keepdim)));
  }|]

var_mean_tNb
  :: Ptr Tensor
  -> Ptr DimnameList
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
var_mean_tNb _self _dim _unbiased =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::var_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(bool _unbiased)));
  }|]

var_mean_tN
  :: Ptr Tensor
  -> Ptr DimnameList
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
var_mean_tN _self _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::var_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)));
  }|]

var_mean_tNlb
  :: Ptr Tensor
  -> Ptr DimnameList
  -> Int64
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
var_mean_tNlb _self _dim _correction _keepdim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::var_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(int64_t _correction)
  , $(bool _keepdim)));
  }|]

var_mean_tNl
  :: Ptr Tensor
  -> Ptr DimnameList
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
var_mean_tNl _self _dim _correction =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::var_mean(
    *$(at::Tensor* _self)
  , *$(std::vector<at::Dimname>* _dim)
  , $(int64_t _correction)));
  }|]

where_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
where_ttt _condition _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::where(
    *$(at::Tensor* _condition)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

where_out_tttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
where_out_tttt _out _condition _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::where_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _condition)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

where_tst
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr Tensor
  -> IO (Ptr Tensor)
where_tst _condition _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::where(
    *$(at::Tensor* _condition)
  , *$(at::Scalar* _self)
  , *$(at::Tensor* _other)));
  }|]

where_tts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
where_tts _condition _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::where(
    *$(at::Tensor* _condition)
  , *$(at::Tensor* _self)
  , *$(at::Scalar* _other)));
  }|]

where_tss
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
where_tss _condition _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::where(
    *$(at::Tensor* _condition)
  , *$(at::Scalar* _self)
  , *$(at::Scalar* _other)));
  }|]

where_t
  :: Ptr Tensor
  -> IO (Ptr TensorList)
where_t _condition =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::where(
    *$(at::Tensor* _condition)));
  }|]

norm_except_dim_tll
  :: Ptr Tensor
  -> Int64
  -> Int64
  -> IO (Ptr Tensor)
norm_except_dim_tll _v _pow _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm_except_dim(
    *$(at::Tensor* _v)
  , $(int64_t _pow)
  , $(int64_t _dim)));
  }|]

norm_except_dim_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
norm_except_dim_tl _v _pow =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm_except_dim(
    *$(at::Tensor* _v)
  , $(int64_t _pow)));
  }|]

norm_except_dim_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
norm_except_dim_t _v =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm_except_dim(
    *$(at::Tensor* _v)));
  }|]

_weight_norm_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
_weight_norm_ttl _v _g _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_weight_norm(
    *$(at::Tensor* _v)
  , *$(at::Tensor* _g)
  , $(int64_t _dim)));
  }|]

_weight_norm_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
_weight_norm_tt _v _g =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_weight_norm(
    *$(at::Tensor* _v)
  , *$(at::Tensor* _g)));
  }|]

_weight_norm_interface_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
_weight_norm_interface_ttl _v _g _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::_weight_norm_interface(
    *$(at::Tensor* _v)
  , *$(at::Tensor* _g)
  , $(int64_t _dim)));
  }|]

_weight_norm_interface_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
_weight_norm_interface_tt _v _g =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::_weight_norm_interface(
    *$(at::Tensor* _v)
  , *$(at::Tensor* _g)));
  }|]

_weight_norm_interface_backward_ttttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
_weight_norm_interface_backward_ttttl _grad_w _saved_v _saved_g _saved_norms _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::_weight_norm_interface_backward(
    *$(at::Tensor* _grad_w)
  , *$(at::Tensor* _saved_v)
  , *$(at::Tensor* _saved_g)
  , *$(at::Tensor* _saved_norms)
  , $(int64_t _dim)));
  }|]

_weight_norm_differentiable_backward_ttttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
_weight_norm_differentiable_backward_ttttl _grad_w _saved_v _saved_g _saved_norms _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::_weight_norm_differentiable_backward(
    *$(at::Tensor* _grad_w)
  , *$(at::Tensor* _saved_v)
  , *$(at::Tensor* _saved_g)
  , *$(at::Tensor* _saved_norms)
  , $(int64_t _dim)));
  }|]

zeros_lNo
  :: Ptr IntArray
  -> Ptr DimnameList
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
zeros_lNo _size _names _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::zeros(
    *$(std::vector<int64_t>* _size)
  , *$(std::vector<at::Dimname>* _names)
  , *$(at::TensorOptions* _options)));
  }|]

zeros_lN
  :: Ptr IntArray
  -> Ptr DimnameList
  -> IO (Ptr Tensor)
zeros_lN _size _names =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::zeros(
    *$(std::vector<int64_t>* _size)
  , *$(std::vector<at::Dimname>* _names)));
  }|]

_efficientzerotensor_lo
  :: Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
_efficientzerotensor_lo _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_efficientzerotensor(
    *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

_efficientzerotensor_l
  :: Ptr IntArray
  -> IO (Ptr Tensor)
_efficientzerotensor_l _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_efficientzerotensor(
    *$(std::vector<int64_t>* _size)));
  }|]

zeros_lo
  :: Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
zeros_lo _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::zeros(
    *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

zeros_l
  :: Ptr IntArray
  -> IO (Ptr Tensor)
zeros_l _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::zeros(
    *$(std::vector<int64_t>* _size)));
  }|]

zeros_out_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
zeros_out_tl _out _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::zeros_out(
    *$(at::Tensor* _out)
  , *$(std::vector<int64_t>* _size)));
  }|]

zeros_like_toM
  :: Ptr Tensor
  -> Ptr TensorOptions
  -> MemoryFormat
  -> IO (Ptr Tensor)
zeros_like_toM _self _options _memory_format =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::zeros_like(
    *$(at::Tensor* _self)
  , *$(at::TensorOptions* _options)
  , $(at::MemoryFormat _memory_format)));
  }|]

zeros_like_to
  :: Ptr Tensor
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
zeros_like_to _self _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::zeros_like(
    *$(at::Tensor* _self)
  , *$(at::TensorOptions* _options)));
  }|]

zeros_like_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
zeros_like_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::zeros_like(
    *$(at::Tensor* _self)));
  }|]

_standard_gamma_grad_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
_standard_gamma_grad_tt _self _output =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_standard_gamma_grad(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _output)));
  }|]

_standard_gamma_tG
  :: Ptr Tensor
  -> Ptr Generator
  -> IO (Ptr Tensor)
_standard_gamma_tG _self _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_standard_gamma(
    *$(at::Tensor* _self)
  , *$(at::Generator* _generator)));
  }|]

_standard_gamma_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_standard_gamma_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_standard_gamma(
    *$(at::Tensor* _self)));
  }|]

_dirichlet_grad_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
_dirichlet_grad_ttt _x _alpha _total =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_dirichlet_grad(
    *$(at::Tensor* _x)
  , *$(at::Tensor* _alpha)
  , *$(at::Tensor* _total)));
  }|]

_sample_dirichlet_tG
  :: Ptr Tensor
  -> Ptr Generator
  -> IO (Ptr Tensor)
_sample_dirichlet_tG _self _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sample_dirichlet(
    *$(at::Tensor* _self)
  , *$(at::Generator* _generator)));
  }|]

_sample_dirichlet_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_sample_dirichlet_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sample_dirichlet(
    *$(at::Tensor* _self)));
  }|]

poisson_tG
  :: Ptr Tensor
  -> Ptr Generator
  -> IO (Ptr Tensor)
poisson_tG _self _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::poisson(
    *$(at::Tensor* _self)
  , *$(at::Generator* _generator)));
  }|]

poisson_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
poisson_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::poisson(
    *$(at::Tensor* _self)));
  }|]

binomial_ttG
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Generator
  -> IO (Ptr Tensor)
binomial_ttG _count _prob _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binomial(
    *$(at::Tensor* _count)
  , *$(at::Tensor* _prob)
  , *$(at::Generator* _generator)));
  }|]

binomial_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
binomial_tt _count _prob =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binomial(
    *$(at::Tensor* _count)
  , *$(at::Tensor* _prob)));
  }|]

native_norm_ts
  :: Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
native_norm_ts _self _p =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::native_norm(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _p)));
  }|]

native_norm_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
native_norm_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::native_norm(
    *$(at::Tensor* _self)));
  }|]

native_norm_tslbs
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr IntArray
  -> CBool
  -> ScalarType
  -> IO (Ptr Tensor)
native_norm_tslbs _self _p _dim _keepdim _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::native_norm(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _p)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _keepdim)
  , $(at::ScalarType _dtype)));
  }|]

_sparse_sum_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_sparse_sum_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_sum(
    *$(at::Tensor* _self)));
  }|]

_sparse_sum_ts
  :: Ptr Tensor
  -> ScalarType
  -> IO (Ptr Tensor)
_sparse_sum_ts _self _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_sum(
    *$(at::Tensor* _self)
  , $(at::ScalarType _dtype)));
  }|]

_sparse_sum_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
_sparse_sum_tl _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_sum(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)));
  }|]

_sparse_sum_tls
  :: Ptr Tensor
  -> Ptr IntArray
  -> ScalarType
  -> IO (Ptr Tensor)
_sparse_sum_tls _self _dim _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_sum(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(at::ScalarType _dtype)));
  }|]

_sparse_sum_backward_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
_sparse_sum_backward_ttl _grad _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_sum_backward(
    *$(at::Tensor* _grad)
  , *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)));
  }|]

_sparse_csr_sum_tlbs
  :: Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> ScalarType
  -> IO (Ptr Tensor)
_sparse_csr_sum_tlbs _self _dim _keepdim _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_csr_sum(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _keepdim)
  , $(at::ScalarType _dtype)));
  }|]

_sparse_csr_sum_tlb
  :: Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> IO (Ptr Tensor)
_sparse_csr_sum_tlb _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_csr_sum(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _keepdim)));
  }|]

_sparse_csr_sum_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
_sparse_csr_sum_tl _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_csr_sum(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)));
  }|]

_sparse_csr_prod_tlbs
  :: Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> ScalarType
  -> IO (Ptr Tensor)
_sparse_csr_prod_tlbs _self _dim _keepdim _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_csr_prod(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _keepdim)
  , $(at::ScalarType _dtype)));
  }|]

_sparse_csr_prod_tlb
  :: Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> IO (Ptr Tensor)
_sparse_csr_prod_tlb _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_csr_prod(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _keepdim)));
  }|]

_sparse_csr_prod_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
_sparse_csr_prod_tl _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_csr_prod(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)));
  }|]

_sparse_softmax_tls
  :: Ptr Tensor
  -> Int64
  -> ScalarType
  -> IO (Ptr Tensor)
_sparse_softmax_tls _self _dim _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_softmax(
    *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(at::ScalarType _dtype)));
  }|]

_sparse_softmax_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
_sparse_softmax_tl _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_softmax(
    *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

_sparse_softmax_tns
  :: Ptr Tensor
  -> Ptr Dimname
  -> ScalarType
  -> IO (Ptr Tensor)
_sparse_softmax_tns _self _dim _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_softmax(
    *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)
  , $(at::ScalarType _dtype)));
  }|]

_sparse_softmax_tn
  :: Ptr Tensor
  -> Ptr Dimname
  -> IO (Ptr Tensor)
_sparse_softmax_tn _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_softmax(
    *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)));
  }|]

_sparse_softmax_tlb
  :: Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
_sparse_softmax_tlb _self _dim _half_to_float =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_softmax(
    *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _half_to_float)));
  }|]

_sparse_softmax_backward_data_ttlt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> Ptr Tensor
  -> IO (Ptr Tensor)
_sparse_softmax_backward_data_ttlt _grad_output _output _dim _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_softmax_backward_data(
    *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _output)
  , $(int64_t _dim)
  , *$(at::Tensor* _self)));
  }|]

_sparse_log_softmax_tls
  :: Ptr Tensor
  -> Int64
  -> ScalarType
  -> IO (Ptr Tensor)
_sparse_log_softmax_tls _self _dim _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_log_softmax(
    *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(at::ScalarType _dtype)));
  }|]

_sparse_log_softmax_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
_sparse_log_softmax_tl _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_log_softmax(
    *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

_sparse_log_softmax_tns
  :: Ptr Tensor
  -> Ptr Dimname
  -> ScalarType
  -> IO (Ptr Tensor)
_sparse_log_softmax_tns _self _dim _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_log_softmax(
    *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)
  , $(at::ScalarType _dtype)));
  }|]

_sparse_log_softmax_tn
  :: Ptr Tensor
  -> Ptr Dimname
  -> IO (Ptr Tensor)
_sparse_log_softmax_tn _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_log_softmax(
    *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)));
  }|]

_sparse_log_softmax_tlb
  :: Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
_sparse_log_softmax_tlb _self _dim _half_to_float =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_log_softmax(
    *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _half_to_float)));
  }|]

_sparse_log_softmax_backward_data_ttlt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> Ptr Tensor
  -> IO (Ptr Tensor)
_sparse_log_softmax_backward_data_ttlt _grad_output _output _dim _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_log_softmax_backward_data(
    *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _output)
  , $(int64_t _dim)
  , *$(at::Tensor* _self)));
  }|]

_spdiags_ttlL
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Layout
  -> IO (Ptr Tensor)
_spdiags_ttlL _diagonals _offsets _shape _layout =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_spdiags(
    *$(at::Tensor* _diagonals)
  , *$(at::Tensor* _offsets)
  , *$(std::vector<int64_t>* _shape)
  , $(at::Layout _layout)));
  }|]

_spdiags_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
_spdiags_ttl _diagonals _offsets _shape =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_spdiags(
    *$(at::Tensor* _diagonals)
  , *$(at::Tensor* _offsets)
  , *$(std::vector<int64_t>* _shape)));
  }|]

norm_tss
  :: Ptr Tensor
  -> Ptr Scalar
  -> ScalarType
  -> IO (Ptr Tensor)
norm_tss _self _p _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _p)
  , $(at::ScalarType _dtype)));
  }|]

norm_ts
  :: Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
norm_ts _self _p =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _p)));
  }|]

norm_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
norm_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm(
    *$(at::Tensor* _self)));
  }|]

norm_tslbs
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr IntArray
  -> CBool
  -> ScalarType
  -> IO (Ptr Tensor)
norm_tslbs _self _p _dim _keepdim _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _p)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _keepdim)
  , $(at::ScalarType _dtype)));
  }|]

norm_tslb
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr IntArray
  -> CBool
  -> IO (Ptr Tensor)
norm_tslb _self _p _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _p)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _keepdim)));
  }|]

norm_tsl
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr IntArray
  -> IO (Ptr Tensor)
norm_tsl _self _p _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _p)
  , *$(std::vector<int64_t>* _dim)));
  }|]

norm_out_ttslbs
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr IntArray
  -> CBool
  -> ScalarType
  -> IO (Ptr Tensor)
norm_out_ttslbs _out _self _p _dim _keepdim _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Scalar* _p)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _keepdim)
  , $(at::ScalarType _dtype)));
  }|]

norm_out_ttslb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr IntArray
  -> CBool
  -> IO (Ptr Tensor)
norm_out_ttslb _out _self _p _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Scalar* _p)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _keepdim)));
  }|]

norm_out_ttsl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr IntArray
  -> IO (Ptr Tensor)
norm_out_ttsl _out _self _p _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Scalar* _p)
  , *$(std::vector<int64_t>* _dim)));
  }|]

norm_tsNbs
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr DimnameList
  -> CBool
  -> ScalarType
  -> IO (Ptr Tensor)
norm_tsNbs _self _p _dim _keepdim _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _p)
  , *$(std::vector<at::Dimname>* _dim)
  , $(bool _keepdim)
  , $(at::ScalarType _dtype)));
  }|]

norm_tsNb
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr DimnameList
  -> CBool
  -> IO (Ptr Tensor)
norm_tsNb _self _p _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _p)
  , *$(std::vector<at::Dimname>* _dim)
  , $(bool _keepdim)));
  }|]

norm_tsN
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr DimnameList
  -> IO (Ptr Tensor)
norm_tsN _self _p _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _p)
  , *$(std::vector<at::Dimname>* _dim)));
  }|]

norm_out_ttsNbs
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr DimnameList
  -> CBool
  -> ScalarType
  -> IO (Ptr Tensor)
norm_out_ttsNbs _out _self _p _dim _keepdim _dtype =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Scalar* _p)
  , *$(std::vector<at::Dimname>* _dim)
  , $(bool _keepdim)
  , $(at::ScalarType _dtype)));
  }|]

norm_out_ttsNb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr DimnameList
  -> CBool
  -> IO (Ptr Tensor)
norm_out_ttsNb _out _self _p _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Scalar* _p)
  , *$(std::vector<at::Dimname>* _dim)
  , $(bool _keepdim)));
  }|]

norm_out_ttsN
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr DimnameList
  -> IO (Ptr Tensor)
norm_out_ttsN _out _self _p _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::norm_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Scalar* _p)
  , *$(std::vector<at::Dimname>* _dim)));
  }|]

frexp_t
  :: Ptr Tensor
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
frexp_t _self =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::frexp(
    *$(at::Tensor* _self)));
  }|]

frexp_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
frexp_out_ttt _mantissa _exponent _self =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::frexp_out(
    *$(at::Tensor* _mantissa)
  , *$(at::Tensor* _exponent)
  , *$(at::Tensor* _self)));
  }|]

frobenius_norm_tlb
  :: Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> IO (Ptr Tensor)
frobenius_norm_tlb _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::frobenius_norm(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _keepdim)));
  }|]

frobenius_norm_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
frobenius_norm_tl _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::frobenius_norm(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)));
  }|]

frobenius_norm_out_ttlb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> IO (Ptr Tensor)
frobenius_norm_out_ttlb _out _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::frobenius_norm_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _keepdim)));
  }|]

frobenius_norm_out_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
frobenius_norm_out_ttl _out _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::frobenius_norm_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)));
  }|]

nuclear_norm_tb
  :: Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
nuclear_norm_tb _self _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nuclear_norm(
    *$(at::Tensor* _self)
  , $(bool _keepdim)));
  }|]

nuclear_norm_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
nuclear_norm_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nuclear_norm(
    *$(at::Tensor* _self)));
  }|]

nuclear_norm_out_ttb
  :: Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
nuclear_norm_out_ttb _out _self _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nuclear_norm_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , $(bool _keepdim)));
  }|]

nuclear_norm_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
nuclear_norm_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nuclear_norm_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

nuclear_norm_tlb
  :: Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> IO (Ptr Tensor)
nuclear_norm_tlb _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nuclear_norm(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _keepdim)));
  }|]

nuclear_norm_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
nuclear_norm_tl _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nuclear_norm(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)));
  }|]

nuclear_norm_out_ttlb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> IO (Ptr Tensor)
nuclear_norm_out_ttlb _out _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nuclear_norm_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)
  , $(bool _keepdim)));
  }|]

nuclear_norm_out_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
nuclear_norm_out_ttl _out _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nuclear_norm_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _dim)));
  }|]

clone_tM
  :: Ptr Tensor
  -> MemoryFormat
  -> IO (Ptr Tensor)
clone_tM _self _memory_format =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::clone(
    *$(at::Tensor* _self)
  , $(at::MemoryFormat _memory_format)));
  }|]

clone_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
clone_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::clone(
    *$(at::Tensor* _self)));
  }|]

positive_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
positive_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::positive(
    *$(at::Tensor* _self)));
  }|]

resize_as__ttM
  :: Ptr Tensor
  -> Ptr Tensor
  -> MemoryFormat
  -> IO (Ptr Tensor)
resize_as__ttM _self _the_template _memory_format =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::resize_as_(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _the_template)
  , $(at::MemoryFormat _memory_format)));
  }|]

resize_as__tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
resize_as__tt _self _the_template =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::resize_as_(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _the_template)));
  }|]

resize_as_sparse__tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
resize_as_sparse__tt _self _the_template =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::resize_as_sparse_(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _the_template)));
  }|]

zero__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
zero__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::zero_(
    *$(at::Tensor* _self)));
  }|]

sub_out_ttts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
sub_out_ttts _out _self _other _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::sub_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _other)
  , *$(at::Scalar* _alpha)));
  }|]

sub_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
sub_out_ttt _out _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::sub_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

sub_tts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
sub_tts _self _other _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::sub(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)
  , *$(at::Scalar* _alpha)));
  }|]

sub_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
sub_tt _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::sub(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

sub_tss
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
sub_tss _self _other _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::sub(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _other)
  , *$(at::Scalar* _alpha)));
  }|]

sub_ts
  :: Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
sub_ts _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::sub(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _other)));
  }|]

subtract_out_ttts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
subtract_out_ttts _out _self _other _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::subtract_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _other)
  , *$(at::Scalar* _alpha)));
  }|]

subtract_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
subtract_out_ttt _out _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::subtract_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

subtract_tts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
subtract_tts _self _other _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::subtract(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)
  , *$(at::Scalar* _alpha)));
  }|]

subtract_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
subtract_tt _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::subtract(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

