
-- generated by using spec/Declarations.yaml

{-# LANGUAGE DataKinds #-}
{-# LANGUAGE PolyKinds #-}
{-# LANGUAGE TemplateHaskell #-}
{-# LANGUAGE QuasiQuotes #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE OverloadedStrings #-}

module Torch.Internal.Unmanaged.TensorFactories where


import Foreign.C.String
import Foreign.C.Types
import Foreign
import Torch.Internal.Type

import qualified Language.C.Inline.Cpp as C
import qualified Language.C.Inline.Cpp.Unsafe as C
import qualified Language.C.Inline.Context as C
import qualified Language.C.Types as C

C.context $ C.cppCtx <> mempty { C.ctxTypesTable = typeTable }

C.include "<vector>"
C.include "<ATen/Tensor.h>"
C.include "<ATen/Functions.h>"

C.include "<torch/csrc/autograd/generated/variable_factories.h>"


_cudnn_init_dropout_state_dblo
  :: CDouble
  -> CBool
  -> Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
_cudnn_init_dropout_state_dblo _dropout _train _dropout_seed _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_cudnn_init_dropout_state(
    $(double _dropout)
  , $(bool _train)
  , $(int64_t _dropout_seed)
  , *$(at::TensorOptions* _options)));
  }|]

arange_so
  :: Ptr Scalar
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
arange_so _end _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::arange(
    *$(at::Scalar* _end)
  , *$(at::TensorOptions* _options)));
  }|]

arange_s
  :: Ptr Scalar
  -> IO (Ptr Tensor)
arange_s _end =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::arange(
    *$(at::Scalar* _end)));
  }|]

arange_sso
  :: Ptr Scalar
  -> Ptr Scalar
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
arange_sso _start _end _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::arange(
    *$(at::Scalar* _start)
  , *$(at::Scalar* _end)
  , *$(at::TensorOptions* _options)));
  }|]

arange_ss
  :: Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
arange_ss _start _end =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::arange(
    *$(at::Scalar* _start)
  , *$(at::Scalar* _end)));
  }|]

arange_ssso
  :: Ptr Scalar
  -> Ptr Scalar
  -> Ptr Scalar
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
arange_ssso _start _end _step _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::arange(
    *$(at::Scalar* _start)
  , *$(at::Scalar* _end)
  , *$(at::Scalar* _step)
  , *$(at::TensorOptions* _options)));
  }|]

arange_sss
  :: Ptr Scalar
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
arange_sss _start _end _step =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::arange(
    *$(at::Scalar* _start)
  , *$(at::Scalar* _end)
  , *$(at::Scalar* _step)));
  }|]

bartlett_window_lo
  :: Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
bartlett_window_lo _window_length _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::bartlett_window(
    $(int64_t _window_length)
  , *$(at::TensorOptions* _options)));
  }|]

bartlett_window_l
  :: Int64
  -> IO (Ptr Tensor)
bartlett_window_l _window_length =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::bartlett_window(
    $(int64_t _window_length)));
  }|]

bartlett_window_lbo
  :: Int64
  -> CBool
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
bartlett_window_lbo _window_length _periodic _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::bartlett_window(
    $(int64_t _window_length)
  , $(bool _periodic)
  , *$(at::TensorOptions* _options)));
  }|]

bartlett_window_lb
  :: Int64
  -> CBool
  -> IO (Ptr Tensor)
bartlett_window_lb _window_length _periodic =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::bartlett_window(
    $(int64_t _window_length)
  , $(bool _periodic)));
  }|]

blackman_window_lo
  :: Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
blackman_window_lo _window_length _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::blackman_window(
    $(int64_t _window_length)
  , *$(at::TensorOptions* _options)));
  }|]

blackman_window_l
  :: Int64
  -> IO (Ptr Tensor)
blackman_window_l _window_length =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::blackman_window(
    $(int64_t _window_length)));
  }|]

blackman_window_lbo
  :: Int64
  -> CBool
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
blackman_window_lbo _window_length _periodic _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::blackman_window(
    $(int64_t _window_length)
  , $(bool _periodic)
  , *$(at::TensorOptions* _options)));
  }|]

blackman_window_lb
  :: Int64
  -> CBool
  -> IO (Ptr Tensor)
blackman_window_lb _window_length _periodic =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::blackman_window(
    $(int64_t _window_length)
  , $(bool _periodic)));
  }|]

empty_lNoM
  :: Ptr IntArray
  -> Ptr DimnameList
  -> Ptr TensorOptions
  -> MemoryFormat
  -> IO (Ptr Tensor)
empty_lNoM _size _names _options _memory_format =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::empty(
    *$(std::vector<int64_t>* _size)
  , *$(std::vector<at::Dimname>* _names)
  , *$(at::TensorOptions* _options)
  , $(at::MemoryFormat _memory_format)));
  }|]

empty_lNo
  :: Ptr IntArray
  -> Ptr DimnameList
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
empty_lNo _size _names _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::empty(
    *$(std::vector<int64_t>* _size)
  , *$(std::vector<at::Dimname>* _names)
  , *$(at::TensorOptions* _options)));
  }|]

empty_lN
  :: Ptr IntArray
  -> Ptr DimnameList
  -> IO (Ptr Tensor)
empty_lN _size _names =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::empty(
    *$(std::vector<int64_t>* _size)
  , *$(std::vector<at::Dimname>* _names)));
  }|]

empty_loM
  :: Ptr IntArray
  -> Ptr TensorOptions
  -> MemoryFormat
  -> IO (Ptr Tensor)
empty_loM _size _options _memory_format =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::empty(
    *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)
  , $(at::MemoryFormat _memory_format)));
  }|]

empty_lo
  :: Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
empty_lo _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::empty(
    *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

empty_l
  :: Ptr IntArray
  -> IO (Ptr Tensor)
empty_l _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::empty(
    *$(std::vector<int64_t>* _size)));
  }|]

_empty_affine_quantized_lodlM
  :: Ptr IntArray
  -> Ptr TensorOptions
  -> CDouble
  -> Int64
  -> MemoryFormat
  -> IO (Ptr Tensor)
_empty_affine_quantized_lodlM _size _options _scale _zero_point _memory_format =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_empty_affine_quantized(
    *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)
  , $(double _scale)
  , $(int64_t _zero_point)
  , $(at::MemoryFormat _memory_format)));
  }|]

_empty_affine_quantized_lodl
  :: Ptr IntArray
  -> Ptr TensorOptions
  -> CDouble
  -> Int64
  -> IO (Ptr Tensor)
_empty_affine_quantized_lodl _size _options _scale _zero_point =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_empty_affine_quantized(
    *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)
  , $(double _scale)
  , $(int64_t _zero_point)));
  }|]

_empty_affine_quantized_lod
  :: Ptr IntArray
  -> Ptr TensorOptions
  -> CDouble
  -> IO (Ptr Tensor)
_empty_affine_quantized_lod _size _options _scale =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_empty_affine_quantized(
    *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)
  , $(double _scale)));
  }|]

_empty_affine_quantized_lo
  :: Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
_empty_affine_quantized_lo _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_empty_affine_quantized(
    *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

_empty_affine_quantized_l
  :: Ptr IntArray
  -> IO (Ptr Tensor)
_empty_affine_quantized_l _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_empty_affine_quantized(
    *$(std::vector<int64_t>* _size)));
  }|]

_empty_per_channel_affine_quantized_lttloM
  :: Ptr IntArray
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> Ptr TensorOptions
  -> MemoryFormat
  -> IO (Ptr Tensor)
_empty_per_channel_affine_quantized_lttloM _size _scales _zero_points _axis _options _memory_format =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_empty_per_channel_affine_quantized(
    *$(std::vector<int64_t>* _size)
  , *$(at::Tensor* _scales)
  , *$(at::Tensor* _zero_points)
  , $(int64_t _axis)
  , *$(at::TensorOptions* _options)
  , $(at::MemoryFormat _memory_format)));
  }|]

_empty_per_channel_affine_quantized_lttlo
  :: Ptr IntArray
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
_empty_per_channel_affine_quantized_lttlo _size _scales _zero_points _axis _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_empty_per_channel_affine_quantized(
    *$(std::vector<int64_t>* _size)
  , *$(at::Tensor* _scales)
  , *$(at::Tensor* _zero_points)
  , $(int64_t _axis)
  , *$(at::TensorOptions* _options)));
  }|]

_empty_per_channel_affine_quantized_lttl
  :: Ptr IntArray
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
_empty_per_channel_affine_quantized_lttl _size _scales _zero_points _axis =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_empty_per_channel_affine_quantized(
    *$(std::vector<int64_t>* _size)
  , *$(at::Tensor* _scales)
  , *$(at::Tensor* _zero_points)
  , $(int64_t _axis)));
  }|]

empty_quantized_ltoM
  :: Ptr IntArray
  -> Ptr Tensor
  -> Ptr TensorOptions
  -> MemoryFormat
  -> IO (Ptr Tensor)
empty_quantized_ltoM _size _qtensor _options _memory_format =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::empty_quantized(
    *$(std::vector<int64_t>* _size)
  , *$(at::Tensor* _qtensor)
  , *$(at::TensorOptions* _options)
  , $(at::MemoryFormat _memory_format)));
  }|]

empty_quantized_lto
  :: Ptr IntArray
  -> Ptr Tensor
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
empty_quantized_lto _size _qtensor _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::empty_quantized(
    *$(std::vector<int64_t>* _size)
  , *$(at::Tensor* _qtensor)
  , *$(at::TensorOptions* _options)));
  }|]

empty_quantized_lt
  :: Ptr IntArray
  -> Ptr Tensor
  -> IO (Ptr Tensor)
empty_quantized_lt _size _qtensor =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::empty_quantized(
    *$(std::vector<int64_t>* _size)
  , *$(at::Tensor* _qtensor)));
  }|]

empty_like_toM
  :: Ptr Tensor
  -> Ptr TensorOptions
  -> MemoryFormat
  -> IO (Ptr Tensor)
empty_like_toM _self _options _memory_format =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::empty_like(
    *$(at::Tensor* _self)
  , *$(at::TensorOptions* _options)
  , $(at::MemoryFormat _memory_format)));
  }|]

empty_like_to
  :: Ptr Tensor
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
empty_like_to _self _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::empty_like(
    *$(at::Tensor* _self)
  , *$(at::TensorOptions* _options)));
  }|]

empty_like_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
empty_like_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::empty_like(
    *$(at::Tensor* _self)));
  }|]

empty_strided_llo
  :: Ptr IntArray
  -> Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
empty_strided_llo _size _stride _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::empty_strided(
    *$(std::vector<int64_t>* _size)
  , *$(std::vector<int64_t>* _stride)
  , *$(at::TensorOptions* _options)));
  }|]

empty_strided_ll
  :: Ptr IntArray
  -> Ptr IntArray
  -> IO (Ptr Tensor)
empty_strided_ll _size _stride =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::empty_strided(
    *$(std::vector<int64_t>* _size)
  , *$(std::vector<int64_t>* _stride)));
  }|]

eye_lo
  :: Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
eye_lo _n _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::eye(
    $(int64_t _n)
  , *$(at::TensorOptions* _options)));
  }|]

eye_l
  :: Int64
  -> IO (Ptr Tensor)
eye_l _n =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::eye(
    $(int64_t _n)));
  }|]

eye_llo
  :: Int64
  -> Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
eye_llo _n _m _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::eye(
    $(int64_t _n)
  , $(int64_t _m)
  , *$(at::TensorOptions* _options)));
  }|]

eye_ll
  :: Int64
  -> Int64
  -> IO (Ptr Tensor)
eye_ll _n _m =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::eye(
    $(int64_t _n)
  , $(int64_t _m)));
  }|]

full_lsNo
  :: Ptr IntArray
  -> Ptr Scalar
  -> Ptr DimnameList
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
full_lsNo _size _fill_value _names _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::full(
    *$(std::vector<int64_t>* _size)
  , *$(at::Scalar* _fill_value)
  , *$(std::vector<at::Dimname>* _names)
  , *$(at::TensorOptions* _options)));
  }|]

full_lsN
  :: Ptr IntArray
  -> Ptr Scalar
  -> Ptr DimnameList
  -> IO (Ptr Tensor)
full_lsN _size _fill_value _names =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::full(
    *$(std::vector<int64_t>* _size)
  , *$(at::Scalar* _fill_value)
  , *$(std::vector<at::Dimname>* _names)));
  }|]

full_lso
  :: Ptr IntArray
  -> Ptr Scalar
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
full_lso _size _fill_value _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::full(
    *$(std::vector<int64_t>* _size)
  , *$(at::Scalar* _fill_value)
  , *$(at::TensorOptions* _options)));
  }|]

full_ls
  :: Ptr IntArray
  -> Ptr Scalar
  -> IO (Ptr Tensor)
full_ls _size _fill_value =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::full(
    *$(std::vector<int64_t>* _size)
  , *$(at::Scalar* _fill_value)));
  }|]

full_like_tsoM
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr TensorOptions
  -> MemoryFormat
  -> IO (Ptr Tensor)
full_like_tsoM _self _fill_value _options _memory_format =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::full_like(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _fill_value)
  , *$(at::TensorOptions* _options)
  , $(at::MemoryFormat _memory_format)));
  }|]

full_like_tso
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
full_like_tso _self _fill_value _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::full_like(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _fill_value)
  , *$(at::TensorOptions* _options)));
  }|]

full_like_ts
  :: Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
full_like_ts _self _fill_value =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::full_like(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _fill_value)));
  }|]

from_file_sblo
  :: Ptr StdString
  -> CBool
  -> Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
from_file_sblo _filename _shared _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::from_file(
    *$(std::string* _filename)
  , $(bool _shared)
  , $(int64_t _size)
  , *$(at::TensorOptions* _options)));
  }|]

from_file_sbl
  :: Ptr StdString
  -> CBool
  -> Int64
  -> IO (Ptr Tensor)
from_file_sbl _filename _shared _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::from_file(
    *$(std::string* _filename)
  , $(bool _shared)
  , $(int64_t _size)));
  }|]

from_file_sb
  :: Ptr StdString
  -> CBool
  -> IO (Ptr Tensor)
from_file_sb _filename _shared =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::from_file(
    *$(std::string* _filename)
  , $(bool _shared)));
  }|]

from_file_s
  :: Ptr StdString
  -> IO (Ptr Tensor)
from_file_s _filename =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::from_file(
    *$(std::string* _filename)));
  }|]

hann_window_lo
  :: Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
hann_window_lo _window_length _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::hann_window(
    $(int64_t _window_length)
  , *$(at::TensorOptions* _options)));
  }|]

hann_window_l
  :: Int64
  -> IO (Ptr Tensor)
hann_window_l _window_length =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::hann_window(
    $(int64_t _window_length)));
  }|]

hann_window_lbo
  :: Int64
  -> CBool
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
hann_window_lbo _window_length _periodic _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::hann_window(
    $(int64_t _window_length)
  , $(bool _periodic)
  , *$(at::TensorOptions* _options)));
  }|]

hann_window_lb
  :: Int64
  -> CBool
  -> IO (Ptr Tensor)
hann_window_lb _window_length _periodic =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::hann_window(
    $(int64_t _window_length)
  , $(bool _periodic)));
  }|]

hamming_window_lo
  :: Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
hamming_window_lo _window_length _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::hamming_window(
    $(int64_t _window_length)
  , *$(at::TensorOptions* _options)));
  }|]

hamming_window_l
  :: Int64
  -> IO (Ptr Tensor)
hamming_window_l _window_length =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::hamming_window(
    $(int64_t _window_length)));
  }|]

hamming_window_lbo
  :: Int64
  -> CBool
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
hamming_window_lbo _window_length _periodic _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::hamming_window(
    $(int64_t _window_length)
  , $(bool _periodic)
  , *$(at::TensorOptions* _options)));
  }|]

hamming_window_lb
  :: Int64
  -> CBool
  -> IO (Ptr Tensor)
hamming_window_lb _window_length _periodic =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::hamming_window(
    $(int64_t _window_length)
  , $(bool _periodic)));
  }|]

hamming_window_lbdo
  :: Int64
  -> CBool
  -> CDouble
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
hamming_window_lbdo _window_length _periodic _alpha _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::hamming_window(
    $(int64_t _window_length)
  , $(bool _periodic)
  , $(double _alpha)
  , *$(at::TensorOptions* _options)));
  }|]

hamming_window_lbd
  :: Int64
  -> CBool
  -> CDouble
  -> IO (Ptr Tensor)
hamming_window_lbd _window_length _periodic _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::hamming_window(
    $(int64_t _window_length)
  , $(bool _periodic)
  , $(double _alpha)));
  }|]

hamming_window_lbddo
  :: Int64
  -> CBool
  -> CDouble
  -> CDouble
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
hamming_window_lbddo _window_length _periodic _alpha _beta _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::hamming_window(
    $(int64_t _window_length)
  , $(bool _periodic)
  , $(double _alpha)
  , $(double _beta)
  , *$(at::TensorOptions* _options)));
  }|]

hamming_window_lbdd
  :: Int64
  -> CBool
  -> CDouble
  -> CDouble
  -> IO (Ptr Tensor)
hamming_window_lbdd _window_length _periodic _alpha _beta =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::hamming_window(
    $(int64_t _window_length)
  , $(bool _periodic)
  , $(double _alpha)
  , $(double _beta)));
  }|]

kaiser_window_lo
  :: Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
kaiser_window_lo _window_length _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::kaiser_window(
    $(int64_t _window_length)
  , *$(at::TensorOptions* _options)));
  }|]

kaiser_window_l
  :: Int64
  -> IO (Ptr Tensor)
kaiser_window_l _window_length =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::kaiser_window(
    $(int64_t _window_length)));
  }|]

kaiser_window_lbo
  :: Int64
  -> CBool
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
kaiser_window_lbo _window_length _periodic _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::kaiser_window(
    $(int64_t _window_length)
  , $(bool _periodic)
  , *$(at::TensorOptions* _options)));
  }|]

kaiser_window_lb
  :: Int64
  -> CBool
  -> IO (Ptr Tensor)
kaiser_window_lb _window_length _periodic =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::kaiser_window(
    $(int64_t _window_length)
  , $(bool _periodic)));
  }|]

kaiser_window_lbdo
  :: Int64
  -> CBool
  -> CDouble
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
kaiser_window_lbdo _window_length _periodic _beta _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::kaiser_window(
    $(int64_t _window_length)
  , $(bool _periodic)
  , $(double _beta)
  , *$(at::TensorOptions* _options)));
  }|]

kaiser_window_lbd
  :: Int64
  -> CBool
  -> CDouble
  -> IO (Ptr Tensor)
kaiser_window_lbd _window_length _periodic _beta =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::kaiser_window(
    $(int64_t _window_length)
  , $(bool _periodic)
  , $(double _beta)));
  }|]

linspace_sslo
  :: Ptr Scalar
  -> Ptr Scalar
  -> Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
linspace_sslo _start _end _steps _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::linspace(
    *$(at::Scalar* _start)
  , *$(at::Scalar* _end)
  , $(int64_t _steps)
  , *$(at::TensorOptions* _options)));
  }|]

linspace_ssl
  :: Ptr Scalar
  -> Ptr Scalar
  -> Int64
  -> IO (Ptr Tensor)
linspace_ssl _start _end _steps =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::linspace(
    *$(at::Scalar* _start)
  , *$(at::Scalar* _end)
  , $(int64_t _steps)));
  }|]

logspace_ssldo
  :: Ptr Scalar
  -> Ptr Scalar
  -> Int64
  -> CDouble
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
logspace_ssldo _start _end _steps _base _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::logspace(
    *$(at::Scalar* _start)
  , *$(at::Scalar* _end)
  , $(int64_t _steps)
  , $(double _base)
  , *$(at::TensorOptions* _options)));
  }|]

logspace_ssld
  :: Ptr Scalar
  -> Ptr Scalar
  -> Int64
  -> CDouble
  -> IO (Ptr Tensor)
logspace_ssld _start _end _steps _base =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::logspace(
    *$(at::Scalar* _start)
  , *$(at::Scalar* _end)
  , $(int64_t _steps)
  , $(double _base)));
  }|]

logspace_ssl
  :: Ptr Scalar
  -> Ptr Scalar
  -> Int64
  -> IO (Ptr Tensor)
logspace_ssl _start _end _steps =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::logspace(
    *$(at::Scalar* _start)
  , *$(at::Scalar* _end)
  , $(int64_t _steps)));
  }|]

ones_lNo
  :: Ptr IntArray
  -> Ptr DimnameList
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
ones_lNo _size _names _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::ones(
    *$(std::vector<int64_t>* _size)
  , *$(std::vector<at::Dimname>* _names)
  , *$(at::TensorOptions* _options)));
  }|]

ones_lN
  :: Ptr IntArray
  -> Ptr DimnameList
  -> IO (Ptr Tensor)
ones_lN _size _names =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::ones(
    *$(std::vector<int64_t>* _size)
  , *$(std::vector<at::Dimname>* _names)));
  }|]

ones_lo
  :: Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
ones_lo _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::ones(
    *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

ones_l
  :: Ptr IntArray
  -> IO (Ptr Tensor)
ones_l _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::ones(
    *$(std::vector<int64_t>* _size)));
  }|]

ones_like_toM
  :: Ptr Tensor
  -> Ptr TensorOptions
  -> MemoryFormat
  -> IO (Ptr Tensor)
ones_like_toM _self _options _memory_format =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::ones_like(
    *$(at::Tensor* _self)
  , *$(at::TensorOptions* _options)
  , $(at::MemoryFormat _memory_format)));
  }|]

ones_like_to
  :: Ptr Tensor
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
ones_like_to _self _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::ones_like(
    *$(at::Tensor* _self)
  , *$(at::TensorOptions* _options)));
  }|]

ones_like_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
ones_like_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::ones_like(
    *$(at::Tensor* _self)));
  }|]

scalar_tensor_so
  :: Ptr Scalar
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
scalar_tensor_so _s _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::scalar_tensor(
    *$(at::Scalar* _s)
  , *$(at::TensorOptions* _options)));
  }|]

scalar_tensor_s
  :: Ptr Scalar
  -> IO (Ptr Tensor)
scalar_tensor_s _s =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::scalar_tensor(
    *$(at::Scalar* _s)));
  }|]

rand_lNo
  :: Ptr IntArray
  -> Ptr DimnameList
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
rand_lNo _size _names _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::rand(
    *$(std::vector<int64_t>* _size)
  , *$(std::vector<at::Dimname>* _names)
  , *$(at::TensorOptions* _options)));
  }|]

rand_lN
  :: Ptr IntArray
  -> Ptr DimnameList
  -> IO (Ptr Tensor)
rand_lN _size _names =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::rand(
    *$(std::vector<int64_t>* _size)
  , *$(std::vector<at::Dimname>* _names)));
  }|]

rand_lGNo
  :: Ptr IntArray
  -> Ptr Generator
  -> Ptr DimnameList
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
rand_lGNo _size _generator _names _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::rand(
    *$(std::vector<int64_t>* _size)
  , *$(at::Generator* _generator)
  , *$(std::vector<at::Dimname>* _names)
  , *$(at::TensorOptions* _options)));
  }|]

rand_lGN
  :: Ptr IntArray
  -> Ptr Generator
  -> Ptr DimnameList
  -> IO (Ptr Tensor)
rand_lGN _size _generator _names =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::rand(
    *$(std::vector<int64_t>* _size)
  , *$(at::Generator* _generator)
  , *$(std::vector<at::Dimname>* _names)));
  }|]

rand_lo
  :: Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
rand_lo _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::rand(
    *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

rand_l
  :: Ptr IntArray
  -> IO (Ptr Tensor)
rand_l _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::rand(
    *$(std::vector<int64_t>* _size)));
  }|]

rand_lGo
  :: Ptr IntArray
  -> Ptr Generator
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
rand_lGo _size _generator _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::rand(
    *$(std::vector<int64_t>* _size)
  , *$(at::Generator* _generator)
  , *$(at::TensorOptions* _options)));
  }|]

rand_lG
  :: Ptr IntArray
  -> Ptr Generator
  -> IO (Ptr Tensor)
rand_lG _size _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::rand(
    *$(std::vector<int64_t>* _size)
  , *$(at::Generator* _generator)));
  }|]

rand_like_toM
  :: Ptr Tensor
  -> Ptr TensorOptions
  -> MemoryFormat
  -> IO (Ptr Tensor)
rand_like_toM _self _options _memory_format =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::rand_like(
    *$(at::Tensor* _self)
  , *$(at::TensorOptions* _options)
  , $(at::MemoryFormat _memory_format)));
  }|]

rand_like_to
  :: Ptr Tensor
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
rand_like_to _self _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::rand_like(
    *$(at::Tensor* _self)
  , *$(at::TensorOptions* _options)));
  }|]

rand_like_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
rand_like_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::rand_like(
    *$(at::Tensor* _self)));
  }|]

randint_llo
  :: Int64
  -> Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
randint_llo _high _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randint(
    $(int64_t _high)
  , *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

randint_ll
  :: Int64
  -> Ptr IntArray
  -> IO (Ptr Tensor)
randint_ll _high _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randint(
    $(int64_t _high)
  , *$(std::vector<int64_t>* _size)));
  }|]

randint_llGo
  :: Int64
  -> Ptr IntArray
  -> Ptr Generator
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
randint_llGo _high _size _generator _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randint(
    $(int64_t _high)
  , *$(std::vector<int64_t>* _size)
  , *$(at::Generator* _generator)
  , *$(at::TensorOptions* _options)));
  }|]

randint_llG
  :: Int64
  -> Ptr IntArray
  -> Ptr Generator
  -> IO (Ptr Tensor)
randint_llG _high _size _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randint(
    $(int64_t _high)
  , *$(std::vector<int64_t>* _size)
  , *$(at::Generator* _generator)));
  }|]

randint_lllo
  :: Int64
  -> Int64
  -> Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
randint_lllo _low _high _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randint(
    $(int64_t _low)
  , $(int64_t _high)
  , *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

randint_lll
  :: Int64
  -> Int64
  -> Ptr IntArray
  -> IO (Ptr Tensor)
randint_lll _low _high _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randint(
    $(int64_t _low)
  , $(int64_t _high)
  , *$(std::vector<int64_t>* _size)));
  }|]

randint_lllGo
  :: Int64
  -> Int64
  -> Ptr IntArray
  -> Ptr Generator
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
randint_lllGo _low _high _size _generator _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randint(
    $(int64_t _low)
  , $(int64_t _high)
  , *$(std::vector<int64_t>* _size)
  , *$(at::Generator* _generator)
  , *$(at::TensorOptions* _options)));
  }|]

randint_lllG
  :: Int64
  -> Int64
  -> Ptr IntArray
  -> Ptr Generator
  -> IO (Ptr Tensor)
randint_lllG _low _high _size _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randint(
    $(int64_t _low)
  , $(int64_t _high)
  , *$(std::vector<int64_t>* _size)
  , *$(at::Generator* _generator)));
  }|]

randint_like_tloM
  :: Ptr Tensor
  -> Int64
  -> Ptr TensorOptions
  -> MemoryFormat
  -> IO (Ptr Tensor)
randint_like_tloM _self _high _options _memory_format =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randint_like(
    *$(at::Tensor* _self)
  , $(int64_t _high)
  , *$(at::TensorOptions* _options)
  , $(at::MemoryFormat _memory_format)));
  }|]

randint_like_tlo
  :: Ptr Tensor
  -> Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
randint_like_tlo _self _high _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randint_like(
    *$(at::Tensor* _self)
  , $(int64_t _high)
  , *$(at::TensorOptions* _options)));
  }|]

randint_like_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
randint_like_tl _self _high =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randint_like(
    *$(at::Tensor* _self)
  , $(int64_t _high)));
  }|]

randint_like_tlloM
  :: Ptr Tensor
  -> Int64
  -> Int64
  -> Ptr TensorOptions
  -> MemoryFormat
  -> IO (Ptr Tensor)
randint_like_tlloM _self _low _high _options _memory_format =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randint_like(
    *$(at::Tensor* _self)
  , $(int64_t _low)
  , $(int64_t _high)
  , *$(at::TensorOptions* _options)
  , $(at::MemoryFormat _memory_format)));
  }|]

randint_like_tllo
  :: Ptr Tensor
  -> Int64
  -> Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
randint_like_tllo _self _low _high _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randint_like(
    *$(at::Tensor* _self)
  , $(int64_t _low)
  , $(int64_t _high)
  , *$(at::TensorOptions* _options)));
  }|]

randint_like_tll
  :: Ptr Tensor
  -> Int64
  -> Int64
  -> IO (Ptr Tensor)
randint_like_tll _self _low _high =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randint_like(
    *$(at::Tensor* _self)
  , $(int64_t _low)
  , $(int64_t _high)));
  }|]

randn_lo
  :: Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
randn_lo _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randn(
    *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

randn_l
  :: Ptr IntArray
  -> IO (Ptr Tensor)
randn_l _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randn(
    *$(std::vector<int64_t>* _size)));
  }|]

randn_lGo
  :: Ptr IntArray
  -> Ptr Generator
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
randn_lGo _size _generator _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randn(
    *$(std::vector<int64_t>* _size)
  , *$(at::Generator* _generator)
  , *$(at::TensorOptions* _options)));
  }|]

randn_lG
  :: Ptr IntArray
  -> Ptr Generator
  -> IO (Ptr Tensor)
randn_lG _size _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randn(
    *$(std::vector<int64_t>* _size)
  , *$(at::Generator* _generator)));
  }|]

randn_lNo
  :: Ptr IntArray
  -> Ptr DimnameList
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
randn_lNo _size _names _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randn(
    *$(std::vector<int64_t>* _size)
  , *$(std::vector<at::Dimname>* _names)
  , *$(at::TensorOptions* _options)));
  }|]

randn_lN
  :: Ptr IntArray
  -> Ptr DimnameList
  -> IO (Ptr Tensor)
randn_lN _size _names =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randn(
    *$(std::vector<int64_t>* _size)
  , *$(std::vector<at::Dimname>* _names)));
  }|]

randn_lGNo
  :: Ptr IntArray
  -> Ptr Generator
  -> Ptr DimnameList
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
randn_lGNo _size _generator _names _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randn(
    *$(std::vector<int64_t>* _size)
  , *$(at::Generator* _generator)
  , *$(std::vector<at::Dimname>* _names)
  , *$(at::TensorOptions* _options)));
  }|]

randn_lGN
  :: Ptr IntArray
  -> Ptr Generator
  -> Ptr DimnameList
  -> IO (Ptr Tensor)
randn_lGN _size _generator _names =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randn(
    *$(std::vector<int64_t>* _size)
  , *$(at::Generator* _generator)
  , *$(std::vector<at::Dimname>* _names)));
  }|]

randn_like_toM
  :: Ptr Tensor
  -> Ptr TensorOptions
  -> MemoryFormat
  -> IO (Ptr Tensor)
randn_like_toM _self _options _memory_format =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randn_like(
    *$(at::Tensor* _self)
  , *$(at::TensorOptions* _options)
  , $(at::MemoryFormat _memory_format)));
  }|]

randn_like_to
  :: Ptr Tensor
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
randn_like_to _self _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randn_like(
    *$(at::Tensor* _self)
  , *$(at::TensorOptions* _options)));
  }|]

randn_like_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
randn_like_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randn_like(
    *$(at::Tensor* _self)));
  }|]

randperm_lo
  :: Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
randperm_lo _n _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randperm(
    $(int64_t _n)
  , *$(at::TensorOptions* _options)));
  }|]

randperm_l
  :: Int64
  -> IO (Ptr Tensor)
randperm_l _n =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randperm(
    $(int64_t _n)));
  }|]

randperm_lGo
  :: Int64
  -> Ptr Generator
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
randperm_lGo _n _generator _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randperm(
    $(int64_t _n)
  , *$(at::Generator* _generator)
  , *$(at::TensorOptions* _options)));
  }|]

randperm_lG
  :: Int64
  -> Ptr Generator
  -> IO (Ptr Tensor)
randperm_lG _n _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::randperm(
    $(int64_t _n)
  , *$(at::Generator* _generator)));
  }|]

range_ssso
  :: Ptr Scalar
  -> Ptr Scalar
  -> Ptr Scalar
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
range_ssso _start _end _step _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::range(
    *$(at::Scalar* _start)
  , *$(at::Scalar* _end)
  , *$(at::Scalar* _step)
  , *$(at::TensorOptions* _options)));
  }|]

range_sss
  :: Ptr Scalar
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
range_sss _start _end _step =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::range(
    *$(at::Scalar* _start)
  , *$(at::Scalar* _end)
  , *$(at::Scalar* _step)));
  }|]

zeros_lNo
  :: Ptr IntArray
  -> Ptr DimnameList
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
zeros_lNo _size _names _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::zeros(
    *$(std::vector<int64_t>* _size)
  , *$(std::vector<at::Dimname>* _names)
  , *$(at::TensorOptions* _options)));
  }|]

zeros_lN
  :: Ptr IntArray
  -> Ptr DimnameList
  -> IO (Ptr Tensor)
zeros_lN _size _names =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::zeros(
    *$(std::vector<int64_t>* _size)
  , *$(std::vector<at::Dimname>* _names)));
  }|]

_efficientzerotensor_lo
  :: Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
_efficientzerotensor_lo _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_efficientzerotensor(
    *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

_efficientzerotensor_l
  :: Ptr IntArray
  -> IO (Ptr Tensor)
_efficientzerotensor_l _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_efficientzerotensor(
    *$(std::vector<int64_t>* _size)));
  }|]

zeros_lo
  :: Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
zeros_lo _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::zeros(
    *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

zeros_l
  :: Ptr IntArray
  -> IO (Ptr Tensor)
zeros_l _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::zeros(
    *$(std::vector<int64_t>* _size)));
  }|]

zeros_like_toM
  :: Ptr Tensor
  -> Ptr TensorOptions
  -> MemoryFormat
  -> IO (Ptr Tensor)
zeros_like_toM _self _options _memory_format =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::zeros_like(
    *$(at::Tensor* _self)
  , *$(at::TensorOptions* _options)
  , $(at::MemoryFormat _memory_format)));
  }|]

zeros_like_to
  :: Ptr Tensor
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
zeros_like_to _self _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::zeros_like(
    *$(at::Tensor* _self)
  , *$(at::TensorOptions* _options)));
  }|]

zeros_like_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
zeros_like_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::zeros_like(
    *$(at::Tensor* _self)));
  }|]

sparse_compressed_tensor_tttlo
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
sparse_compressed_tensor_tttlo _compressed_indices _plain_indices _values _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::sparse_compressed_tensor(
    *$(at::Tensor* _compressed_indices)
  , *$(at::Tensor* _plain_indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

sparse_csr_tensor_tttlo
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
sparse_csr_tensor_tttlo _crow_indices _col_indices _values _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::sparse_csr_tensor(
    *$(at::Tensor* _crow_indices)
  , *$(at::Tensor* _col_indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

sparse_csc_tensor_tttlo
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
sparse_csc_tensor_tttlo _ccol_indices _row_indices _values _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::sparse_csc_tensor(
    *$(at::Tensor* _ccol_indices)
  , *$(at::Tensor* _row_indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

sparse_bsr_tensor_tttlo
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
sparse_bsr_tensor_tttlo _crow_indices _col_indices _values _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::sparse_bsr_tensor(
    *$(at::Tensor* _crow_indices)
  , *$(at::Tensor* _col_indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

sparse_bsc_tensor_tttlo
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
sparse_bsc_tensor_tttlo _ccol_indices _row_indices _values _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::sparse_bsc_tensor(
    *$(at::Tensor* _ccol_indices)
  , *$(at::Tensor* _row_indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

sparse_compressed_tensor_ttto
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
sparse_compressed_tensor_ttto _compressed_indices _plain_indices _values _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::sparse_compressed_tensor(
    *$(at::Tensor* _compressed_indices)
  , *$(at::Tensor* _plain_indices)
  , *$(at::Tensor* _values)
  , *$(at::TensorOptions* _options)));
  }|]

sparse_csr_tensor_ttto
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
sparse_csr_tensor_ttto _crow_indices _col_indices _values _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::sparse_csr_tensor(
    *$(at::Tensor* _crow_indices)
  , *$(at::Tensor* _col_indices)
  , *$(at::Tensor* _values)
  , *$(at::TensorOptions* _options)));
  }|]

sparse_csc_tensor_ttto
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
sparse_csc_tensor_ttto _ccol_indices _row_indices _values _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::sparse_csc_tensor(
    *$(at::Tensor* _ccol_indices)
  , *$(at::Tensor* _row_indices)
  , *$(at::Tensor* _values)
  , *$(at::TensorOptions* _options)));
  }|]

sparse_bsr_tensor_ttto
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
sparse_bsr_tensor_ttto _crow_indices _col_indices _values _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::sparse_bsr_tensor(
    *$(at::Tensor* _crow_indices)
  , *$(at::Tensor* _col_indices)
  , *$(at::Tensor* _values)
  , *$(at::TensorOptions* _options)));
  }|]

sparse_bsc_tensor_ttto
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
sparse_bsc_tensor_ttto _ccol_indices _row_indices _values _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::sparse_bsc_tensor(
    *$(at::Tensor* _ccol_indices)
  , *$(at::Tensor* _row_indices)
  , *$(at::Tensor* _values)
  , *$(at::TensorOptions* _options)));
  }|]

_sparse_compressed_tensor_unsafe_tttlo
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
_sparse_compressed_tensor_unsafe_tttlo _compressed_indices _plain_indices _values _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_sparse_compressed_tensor_unsafe(
    *$(at::Tensor* _compressed_indices)
  , *$(at::Tensor* _plain_indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

_sparse_compressed_tensor_unsafe_tttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
_sparse_compressed_tensor_unsafe_tttl _compressed_indices _plain_indices _values _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_sparse_compressed_tensor_unsafe(
    *$(at::Tensor* _compressed_indices)
  , *$(at::Tensor* _plain_indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)));
  }|]

_sparse_csr_tensor_unsafe_tttlo
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
_sparse_csr_tensor_unsafe_tttlo _crow_indices _col_indices _values _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_sparse_csr_tensor_unsafe(
    *$(at::Tensor* _crow_indices)
  , *$(at::Tensor* _col_indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

_sparse_csr_tensor_unsafe_tttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
_sparse_csr_tensor_unsafe_tttl _crow_indices _col_indices _values _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_sparse_csr_tensor_unsafe(
    *$(at::Tensor* _crow_indices)
  , *$(at::Tensor* _col_indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)));
  }|]

_sparse_csc_tensor_unsafe_tttlo
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
_sparse_csc_tensor_unsafe_tttlo _ccol_indices _row_indices _values _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_sparse_csc_tensor_unsafe(
    *$(at::Tensor* _ccol_indices)
  , *$(at::Tensor* _row_indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

_sparse_csc_tensor_unsafe_tttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
_sparse_csc_tensor_unsafe_tttl _ccol_indices _row_indices _values _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_sparse_csc_tensor_unsafe(
    *$(at::Tensor* _ccol_indices)
  , *$(at::Tensor* _row_indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)));
  }|]

_sparse_bsr_tensor_unsafe_tttlo
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
_sparse_bsr_tensor_unsafe_tttlo _crow_indices _col_indices _values _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_sparse_bsr_tensor_unsafe(
    *$(at::Tensor* _crow_indices)
  , *$(at::Tensor* _col_indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

_sparse_bsr_tensor_unsafe_tttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
_sparse_bsr_tensor_unsafe_tttl _crow_indices _col_indices _values _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_sparse_bsr_tensor_unsafe(
    *$(at::Tensor* _crow_indices)
  , *$(at::Tensor* _col_indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)));
  }|]

_sparse_bsc_tensor_unsafe_tttlo
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
_sparse_bsc_tensor_unsafe_tttlo _ccol_indices _row_indices _values _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_sparse_bsc_tensor_unsafe(
    *$(at::Tensor* _ccol_indices)
  , *$(at::Tensor* _row_indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

_sparse_bsc_tensor_unsafe_tttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
_sparse_bsc_tensor_unsafe_tttl _ccol_indices _row_indices _values _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_sparse_bsc_tensor_unsafe(
    *$(at::Tensor* _ccol_indices)
  , *$(at::Tensor* _row_indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)));
  }|]

sparse_coo_tensor_lo
  :: Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
sparse_coo_tensor_lo _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::sparse_coo_tensor(
    *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

sparse_coo_tensor_tto
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
sparse_coo_tensor_tto _indices _values _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::sparse_coo_tensor(
    *$(at::Tensor* _indices)
  , *$(at::Tensor* _values)
  , *$(at::TensorOptions* _options)));
  }|]

sparse_coo_tensor_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
sparse_coo_tensor_tt _indices _values =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::sparse_coo_tensor(
    *$(at::Tensor* _indices)
  , *$(at::Tensor* _values)));
  }|]

sparse_coo_tensor_ttlo
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
sparse_coo_tensor_ttlo _indices _values _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::sparse_coo_tensor(
    *$(at::Tensor* _indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

sparse_coo_tensor_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
sparse_coo_tensor_ttl _indices _values _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::sparse_coo_tensor(
    *$(at::Tensor* _indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)));
  }|]

_sparse_coo_tensor_unsafe_ttlo
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
_sparse_coo_tensor_unsafe_ttlo _indices _values _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_sparse_coo_tensor_unsafe(
    *$(at::Tensor* _indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

_sparse_coo_tensor_unsafe_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
_sparse_coo_tensor_unsafe_ttl _indices _values _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_sparse_coo_tensor_unsafe(
    *$(at::Tensor* _indices)
  , *$(at::Tensor* _values)
  , *$(std::vector<int64_t>* _size)));
  }|]

_sparse_coo_tensor_with_dims_lllo
  :: Int64
  -> Int64
  -> Ptr IntArray
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
_sparse_coo_tensor_with_dims_lllo _sparse_dim _dense_dim _size _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_sparse_coo_tensor_with_dims(
    $(int64_t _sparse_dim)
  , $(int64_t _dense_dim)
  , *$(std::vector<int64_t>* _size)
  , *$(at::TensorOptions* _options)));
  }|]

_sparse_coo_tensor_with_dims_and_tensors_llltto
  :: Int64
  -> Int64
  -> Ptr IntArray
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
_sparse_coo_tensor_with_dims_and_tensors_llltto _sparse_dim _dense_dim _size _indices _values _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_sparse_coo_tensor_with_dims_and_tensors(
    $(int64_t _sparse_dim)
  , $(int64_t _dense_dim)
  , *$(std::vector<int64_t>* _size)
  , *$(at::Tensor* _indices)
  , *$(at::Tensor* _values)
  , *$(at::TensorOptions* _options)));
  }|]

_to_copy_tobM
  :: Ptr Tensor
  -> Ptr TensorOptions
  -> CBool
  -> MemoryFormat
  -> IO (Ptr Tensor)
_to_copy_tobM _self _options _non_blocking _memory_format =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_to_copy(
    *$(at::Tensor* _self)
  , *$(at::TensorOptions* _options)
  , $(bool _non_blocking)
  , $(at::MemoryFormat _memory_format)));
  }|]

_to_copy_tob
  :: Ptr Tensor
  -> Ptr TensorOptions
  -> CBool
  -> IO (Ptr Tensor)
_to_copy_tob _self _options _non_blocking =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_to_copy(
    *$(at::Tensor* _self)
  , *$(at::TensorOptions* _options)
  , $(bool _non_blocking)));
  }|]

_to_copy_to
  :: Ptr Tensor
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
_to_copy_to _self _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_to_copy(
    *$(at::Tensor* _self)
  , *$(at::TensorOptions* _options)));
  }|]

_to_copy_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_to_copy_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::_to_copy(
    *$(at::Tensor* _self)));
  }|]

tril_indices_lllo
  :: Int64
  -> Int64
  -> Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
tril_indices_lllo _row _col _offset _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::tril_indices(
    $(int64_t _row)
  , $(int64_t _col)
  , $(int64_t _offset)
  , *$(at::TensorOptions* _options)));
  }|]

tril_indices_lll
  :: Int64
  -> Int64
  -> Int64
  -> IO (Ptr Tensor)
tril_indices_lll _row _col _offset =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::tril_indices(
    $(int64_t _row)
  , $(int64_t _col)
  , $(int64_t _offset)));
  }|]

tril_indices_ll
  :: Int64
  -> Int64
  -> IO (Ptr Tensor)
tril_indices_ll _row _col =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::tril_indices(
    $(int64_t _row)
  , $(int64_t _col)));
  }|]

triu_indices_lllo
  :: Int64
  -> Int64
  -> Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
triu_indices_lllo _row _col _offset _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::triu_indices(
    $(int64_t _row)
  , $(int64_t _col)
  , $(int64_t _offset)
  , *$(at::TensorOptions* _options)));
  }|]

triu_indices_lll
  :: Int64
  -> Int64
  -> Int64
  -> IO (Ptr Tensor)
triu_indices_lll _row _col _offset =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::triu_indices(
    $(int64_t _row)
  , $(int64_t _col)
  , $(int64_t _offset)));
  }|]

triu_indices_ll
  :: Int64
  -> Int64
  -> IO (Ptr Tensor)
triu_indices_ll _row _col =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::triu_indices(
    $(int64_t _row)
  , $(int64_t _col)));
  }|]

normal_ddlGo
  :: CDouble
  -> CDouble
  -> Ptr IntArray
  -> Ptr Generator
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
normal_ddlGo _mean _std _size _generator _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::normal(
    $(double _mean)
  , $(double _std)
  , *$(std::vector<int64_t>* _size)
  , *$(at::Generator* _generator)
  , *$(at::TensorOptions* _options)));
  }|]

normal_ddlG
  :: CDouble
  -> CDouble
  -> Ptr IntArray
  -> Ptr Generator
  -> IO (Ptr Tensor)
normal_ddlG _mean _std _size _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::normal(
    $(double _mean)
  , $(double _std)
  , *$(std::vector<int64_t>* _size)
  , *$(at::Generator* _generator)));
  }|]

normal_ddl
  :: CDouble
  -> CDouble
  -> Ptr IntArray
  -> IO (Ptr Tensor)
normal_ddl _mean _std _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::normal(
    $(double _mean)
  , $(double _std)
  , *$(std::vector<int64_t>* _size)));
  }|]

fft_fftfreq_ldo
  :: Int64
  -> CDouble
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
fft_fftfreq_ldo _n _d _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::fft_fftfreq(
    $(int64_t _n)
  , $(double _d)
  , *$(at::TensorOptions* _options)));
  }|]

fft_fftfreq_ld
  :: Int64
  -> CDouble
  -> IO (Ptr Tensor)
fft_fftfreq_ld _n _d =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::fft_fftfreq(
    $(int64_t _n)
  , $(double _d)));
  }|]

fft_fftfreq_l
  :: Int64
  -> IO (Ptr Tensor)
fft_fftfreq_l _n =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::fft_fftfreq(
    $(int64_t _n)));
  }|]

fft_rfftfreq_ldo
  :: Int64
  -> CDouble
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
fft_rfftfreq_ldo _n _d _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::fft_rfftfreq(
    $(int64_t _n)
  , $(double _d)
  , *$(at::TensorOptions* _options)));
  }|]

fft_rfftfreq_ld
  :: Int64
  -> CDouble
  -> IO (Ptr Tensor)
fft_rfftfreq_ld _n _d =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::fft_rfftfreq(
    $(int64_t _n)
  , $(double _d)));
  }|]

fft_rfftfreq_l
  :: Int64
  -> IO (Ptr Tensor)
fft_rfftfreq_l _n =
  [C.throwBlock| at::Tensor* { return new at::Tensor(torch::fft_rfftfreq(
    $(int64_t _n)));
  }|]

