
-- generated by using spec/Declarations.yaml

{-# LANGUAGE DataKinds #-}
{-# LANGUAGE PolyKinds #-}
{-# LANGUAGE TemplateHaskell #-}
{-# LANGUAGE QuasiQuotes #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE OverloadedStrings #-}

module Torch.Internal.Unmanaged.Native.Native8 where


import Foreign.C.String
import Foreign.C.Types
import Foreign
import Torch.Internal.Type

import qualified Language.C.Inline.Cpp as C
import qualified Language.C.Inline.Cpp.Unsafe as C
import qualified Language.C.Inline.Context as C
import qualified Language.C.Types as C

C.context $ C.cppCtx <> mempty { C.ctxTypesTable = typeTable }

C.include "<vector>"
C.include "<ATen/Tensor.h>"
C.include "<ATen/Functions.h>"


nanquantile_out_ttdlb
  :: Ptr Tensor
  -> Ptr Tensor
  -> CDouble
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
nanquantile_out_ttdlb _out _self _q _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nanquantile_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , $(double _q)
  , $(int64_t _dim)
  , $(bool _keepdim)));
  }|]

nanquantile_out_ttdl
  :: Ptr Tensor
  -> Ptr Tensor
  -> CDouble
  -> Int64
  -> IO (Ptr Tensor)
nanquantile_out_ttdl _out _self _q _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nanquantile_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , $(double _q)
  , $(int64_t _dim)));
  }|]

nanquantile_out_ttd
  :: Ptr Tensor
  -> Ptr Tensor
  -> CDouble
  -> IO (Ptr Tensor)
nanquantile_out_ttd _out _self _q =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nanquantile_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , $(double _q)));
  }|]

sort_out_tttlb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_out_tttlb _values _indices _self _dim _descending =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort_out(
    *$(at::Tensor* _values)
  , *$(at::Tensor* _indices)
  , *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _descending)));
  }|]

sort_out_tttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_out_tttl _values _indices _self _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort_out(
    *$(at::Tensor* _values)
  , *$(at::Tensor* _indices)
  , *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

sort_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_out_ttt _values _indices _self =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort_out(
    *$(at::Tensor* _values)
  , *$(at::Tensor* _indices)
  , *$(at::Tensor* _self)));
  }|]

sort_out_tttblb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> Int64
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_out_tttblb _values _indices _self _stable _dim _descending =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort_out(
    *$(at::Tensor* _values)
  , *$(at::Tensor* _indices)
  , *$(at::Tensor* _self)
  , $(bool _stable)
  , $(int64_t _dim)
  , $(bool _descending)));
  }|]

sort_out_tttb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_out_tttb _values _indices _self _stable =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort_out(
    *$(at::Tensor* _values)
  , *$(at::Tensor* _indices)
  , *$(at::Tensor* _self)
  , $(bool _stable)));
  }|]

sort_tlb
  :: Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_tlb _self _dim _descending =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort(
    *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _descending)));
  }|]

sort_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_tl _self _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort(
    *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

sort_t
  :: Ptr Tensor
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_t _self =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort(
    *$(at::Tensor* _self)));
  }|]

sort_tblb
  :: Ptr Tensor
  -> CBool
  -> Int64
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_tblb _self _stable _dim _descending =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort(
    *$(at::Tensor* _self)
  , $(bool _stable)
  , $(int64_t _dim)
  , $(bool _descending)));
  }|]

-- sort_tbl
--   :: Ptr Tensor
--   -> CBool
--   -> Int64
--   -> IO (Ptr (StdTuple '(Tensor,Tensor)))
-- sort_tbl _self _stable _dim =
--   [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort(
--     *$(at::Tensor* _self)
--   , $(bool _stable)
--   , $(int64_t _dim)));
--   }|]

sort_tb
  :: Ptr Tensor
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_tb _self _stable =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort(
    *$(at::Tensor* _self)
  , $(bool _stable)));
  }|]

sort_out_tttnb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Dimname
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_out_tttnb _values _indices _self _dim _descending =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort_out(
    *$(at::Tensor* _values)
  , *$(at::Tensor* _indices)
  , *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)
  , $(bool _descending)));
  }|]

sort_out_tttn
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Dimname
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_out_tttn _values _indices _self _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort_out(
    *$(at::Tensor* _values)
  , *$(at::Tensor* _indices)
  , *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)));
  }|]

sort_out_tttbnb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> Ptr Dimname
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_out_tttbnb _values _indices _self _stable _dim _descending =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort_out(
    *$(at::Tensor* _values)
  , *$(at::Tensor* _indices)
  , *$(at::Tensor* _self)
  , $(bool _stable)
  , *$(at::Dimname* _dim)
  , $(bool _descending)));
  }|]

sort_out_tttbn
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> Ptr Dimname
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_out_tttbn _values _indices _self _stable _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort_out(
    *$(at::Tensor* _values)
  , *$(at::Tensor* _indices)
  , *$(at::Tensor* _self)
  , $(bool _stable)
  , *$(at::Dimname* _dim)));
  }|]

sort_tnb
  :: Ptr Tensor
  -> Ptr Dimname
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_tnb _self _dim _descending =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort(
    *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)
  , $(bool _descending)));
  }|]

sort_tn
  :: Ptr Tensor
  -> Ptr Dimname
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_tn _self _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort(
    *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)));
  }|]

sort_tbnb
  :: Ptr Tensor
  -> CBool
  -> Ptr Dimname
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_tbnb _self _stable _dim _descending =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort(
    *$(at::Tensor* _self)
  , $(bool _stable)
  , *$(at::Dimname* _dim)
  , $(bool _descending)));
  }|]

sort_tbn
  :: Ptr Tensor
  -> CBool
  -> Ptr Dimname
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
sort_tbn _self _stable _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::sort(
    *$(at::Tensor* _self)
  , $(bool _stable)
  , *$(at::Dimname* _dim)));
  }|]

msort_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
msort_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::msort_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

msort_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
msort_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::msort(
    *$(at::Tensor* _self)));
  }|]

argsort_tlb
  :: Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
argsort_tlb _self _dim _descending =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argsort(
    *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _descending)));
  }|]

argsort_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
argsort_tl _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argsort(
    *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

argsort_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
argsort_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argsort(
    *$(at::Tensor* _self)));
  }|]

argsort_tblb
  :: Ptr Tensor
  -> CBool
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
argsort_tblb _self _stable _dim _descending =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argsort(
    *$(at::Tensor* _self)
  , $(bool _stable)
  , $(int64_t _dim)
  , $(bool _descending)));
  }|]

argsort_tbl
  :: Ptr Tensor
  -> CBool
  -> Int64
  -> IO (Ptr Tensor)
argsort_tbl _self _stable _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argsort(
    *$(at::Tensor* _self)
  , $(bool _stable)
  , $(int64_t _dim)));
  }|]

argsort_tb
  :: Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
argsort_tb _self _stable =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argsort(
    *$(at::Tensor* _self)
  , $(bool _stable)));
  }|]

argsort_tnb
  :: Ptr Tensor
  -> Ptr Dimname
  -> CBool
  -> IO (Ptr Tensor)
argsort_tnb _self _dim _descending =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argsort(
    *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)
  , $(bool _descending)));
  }|]

argsort_tn
  :: Ptr Tensor
  -> Ptr Dimname
  -> IO (Ptr Tensor)
argsort_tn _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argsort(
    *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)));
  }|]

topk_out_tttllbb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> Int64
  -> CBool
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
topk_out_tttllbb _values _indices _self _k _dim _largest _sorted =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::topk_out(
    *$(at::Tensor* _values)
  , *$(at::Tensor* _indices)
  , *$(at::Tensor* _self)
  , $(int64_t _k)
  , $(int64_t _dim)
  , $(bool _largest)
  , $(bool _sorted)));
  }|]

topk_out_tttllb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> Int64
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
topk_out_tttllb _values _indices _self _k _dim _largest =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::topk_out(
    *$(at::Tensor* _values)
  , *$(at::Tensor* _indices)
  , *$(at::Tensor* _self)
  , $(int64_t _k)
  , $(int64_t _dim)
  , $(bool _largest)));
  }|]

topk_out_tttll
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
topk_out_tttll _values _indices _self _k _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::topk_out(
    *$(at::Tensor* _values)
  , *$(at::Tensor* _indices)
  , *$(at::Tensor* _self)
  , $(int64_t _k)
  , $(int64_t _dim)));
  }|]

topk_out_tttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
topk_out_tttl _values _indices _self _k =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::topk_out(
    *$(at::Tensor* _values)
  , *$(at::Tensor* _indices)
  , *$(at::Tensor* _self)
  , $(int64_t _k)));
  }|]

topk_tllbb
  :: Ptr Tensor
  -> Int64
  -> Int64
  -> CBool
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
topk_tllbb _self _k _dim _largest _sorted =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::topk(
    *$(at::Tensor* _self)
  , $(int64_t _k)
  , $(int64_t _dim)
  , $(bool _largest)
  , $(bool _sorted)));
  }|]

topk_tllb
  :: Ptr Tensor
  -> Int64
  -> Int64
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
topk_tllb _self _k _dim _largest =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::topk(
    *$(at::Tensor* _self)
  , $(int64_t _k)
  , $(int64_t _dim)
  , $(bool _largest)));
  }|]

topk_tll
  :: Ptr Tensor
  -> Int64
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
topk_tll _self _k _dim =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::topk(
    *$(at::Tensor* _self)
  , $(int64_t _k)
  , $(int64_t _dim)));
  }|]

topk_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
topk_tl _self _k =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::topk(
    *$(at::Tensor* _self)
  , $(int64_t _k)));
  }|]

all_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
all_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::all(
    *$(at::Tensor* _self)));
  }|]

all_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
all_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::all_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

any_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
any_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::any(
    *$(at::Tensor* _self)));
  }|]

any_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
any_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::any_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

renorm_out_ttsls
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Int64
  -> Ptr Scalar
  -> IO (Ptr Tensor)
renorm_out_ttsls _out _self _p _dim _maxnorm =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::renorm_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Scalar* _p)
  , $(int64_t _dim)
  , *$(at::Scalar* _maxnorm)));
  }|]

renorm_tsls
  :: Ptr Tensor
  -> Ptr Scalar
  -> Int64
  -> Ptr Scalar
  -> IO (Ptr Tensor)
renorm_tsls _self _p _dim _maxnorm =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::renorm(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _p)
  , $(int64_t _dim)
  , *$(at::Scalar* _maxnorm)));
  }|]

unfold_backward_tllll
  :: Ptr Tensor
  -> Ptr IntArray
  -> Int64
  -> Int64
  -> Int64
  -> IO (Ptr Tensor)
unfold_backward_tllll _grad_in _input_sizes _dim _size _step =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::unfold_backward(
    *$(at::Tensor* _grad_in)
  , *$(std::vector<int64_t>* _input_sizes)
  , $(int64_t _dim)
  , $(int64_t _size)
  , $(int64_t _step)));
  }|]

equal_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (CBool)
equal_tt _self _other =
  [C.throwBlock| bool { return (at::equal(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

pow_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
pow_out_ttt _out _self _exponent =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::pow_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _exponent)));
  }|]

pow_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
pow_tt _self _exponent =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::pow(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _exponent)));
  }|]

pow_out_tst
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr Tensor
  -> IO (Ptr Tensor)
pow_out_tst _out _self _exponent =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::pow_out(
    *$(at::Tensor* _out)
  , *$(at::Scalar* _self)
  , *$(at::Tensor* _exponent)));
  }|]

pow_st
  :: Ptr Scalar
  -> Ptr Tensor
  -> IO (Ptr Tensor)
pow_st _self _exponent =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::pow(
    *$(at::Scalar* _self)
  , *$(at::Tensor* _exponent)));
  }|]

pow_out_tts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
pow_out_tts _out _self _exponent =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::pow_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Scalar* _exponent)));
  }|]

pow_ts
  :: Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
pow_ts _self _exponent =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::pow(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _exponent)));
  }|]

float_power_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
float_power_out_ttt _out _self _exponent =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::float_power_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _exponent)));
  }|]

float_power_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
float_power_tt _self _exponent =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::float_power(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _exponent)));
  }|]

float_power_out_tst
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr Tensor
  -> IO (Ptr Tensor)
float_power_out_tst _out _self _exponent =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::float_power_out(
    *$(at::Tensor* _out)
  , *$(at::Scalar* _self)
  , *$(at::Tensor* _exponent)));
  }|]

float_power_st
  :: Ptr Scalar
  -> Ptr Tensor
  -> IO (Ptr Tensor)
float_power_st _self _exponent =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::float_power(
    *$(at::Scalar* _self)
  , *$(at::Tensor* _exponent)));
  }|]

float_power_out_tts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
float_power_out_tts _out _self _exponent =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::float_power_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Scalar* _exponent)));
  }|]

float_power_ts
  :: Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
float_power_ts _self _exponent =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::float_power(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _exponent)));
  }|]

normal_functional_tddG
  :: Ptr Tensor
  -> CDouble
  -> CDouble
  -> Ptr Generator
  -> IO (Ptr Tensor)
normal_functional_tddG _self _mean _std _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal_functional(
    *$(at::Tensor* _self)
  , $(double _mean)
  , $(double _std)
  , *$(at::Generator* _generator)));
  }|]

normal_functional_tdd
  :: Ptr Tensor
  -> CDouble
  -> CDouble
  -> IO (Ptr Tensor)
normal_functional_tdd _self _mean _std =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal_functional(
    *$(at::Tensor* _self)
  , $(double _mean)
  , $(double _std)));
  }|]

normal_functional_td
  :: Ptr Tensor
  -> CDouble
  -> IO (Ptr Tensor)
normal_functional_td _self _mean =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal_functional(
    *$(at::Tensor* _self)
  , $(double _mean)));
  }|]

normal_functional_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
normal_functional_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal_functional(
    *$(at::Tensor* _self)));
  }|]

normal_out_ttdG
  :: Ptr Tensor
  -> Ptr Tensor
  -> CDouble
  -> Ptr Generator
  -> IO (Ptr Tensor)
normal_out_ttdG _out _mean _std _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _mean)
  , $(double _std)
  , *$(at::Generator* _generator)));
  }|]

-- normal_out_ttd
--   :: Ptr Tensor
--   -> Ptr Tensor
--   -> CDouble
--   -> IO (Ptr Tensor)
-- normal_out_ttd _out _mean _std =
--   [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal_out(
--     *$(at::Tensor* _out)
--   , *$(at::Tensor* _mean)
--   , $(double _std)));
--   }|]

-- normal_out_tt
--   :: Ptr Tensor
--   -> Ptr Tensor
--   -> IO (Ptr Tensor)
-- normal_out_tt _out _mean =
--   [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal_out(
--     *$(at::Tensor* _out)
--   , *$(at::Tensor* _mean)));
--   }|]

normal_tdG
  :: Ptr Tensor
  -> CDouble
  -> Ptr Generator
  -> IO (Ptr Tensor)
normal_tdG _mean _std _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal(
    *$(at::Tensor* _mean)
  , $(double _std)
  , *$(at::Generator* _generator)));
  }|]

normal_td
  :: Ptr Tensor
  -> CDouble
  -> IO (Ptr Tensor)
normal_td _mean _std =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal(
    *$(at::Tensor* _mean)
  , $(double _std)));
  }|]

normal_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
normal_t _mean =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal(
    *$(at::Tensor* _mean)));
  }|]

normal_out_tdtG
  :: Ptr Tensor
  -> CDouble
  -> Ptr Tensor
  -> Ptr Generator
  -> IO (Ptr Tensor)
normal_out_tdtG _out _mean _std _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal_out(
    *$(at::Tensor* _out)
  , $(double _mean)
  , *$(at::Tensor* _std)
  , *$(at::Generator* _generator)));
  }|]

normal_out_tdt
  :: Ptr Tensor
  -> CDouble
  -> Ptr Tensor
  -> IO (Ptr Tensor)
normal_out_tdt _out _mean _std =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal_out(
    *$(at::Tensor* _out)
  , $(double _mean)
  , *$(at::Tensor* _std)));
  }|]

normal_dtG
  :: CDouble
  -> Ptr Tensor
  -> Ptr Generator
  -> IO (Ptr Tensor)
normal_dtG _mean _std _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal(
    $(double _mean)
  , *$(at::Tensor* _std)
  , *$(at::Generator* _generator)));
  }|]

normal_dt
  :: CDouble
  -> Ptr Tensor
  -> IO (Ptr Tensor)
normal_dt _mean _std =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal(
    $(double _mean)
  , *$(at::Tensor* _std)));
  }|]

normal_out_tttG
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Generator
  -> IO (Ptr Tensor)
normal_out_tttG _out _mean _std _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _mean)
  , *$(at::Tensor* _std)
  , *$(at::Generator* _generator)));
  }|]

normal_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
normal_out_ttt _out _mean _std =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _mean)
  , *$(at::Tensor* _std)));
  }|]

normal_ttG
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Generator
  -> IO (Ptr Tensor)
normal_ttG _mean _std _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal(
    *$(at::Tensor* _mean)
  , *$(at::Tensor* _std)
  , *$(at::Generator* _generator)));
  }|]

normal_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
normal_tt _mean _std =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal(
    *$(at::Tensor* _mean)
  , *$(at::Tensor* _std)));
  }|]

normal_ddlGo
  :: CDouble
  -> CDouble
  -> Ptr IntArray
  -> Ptr Generator
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
normal_ddlGo _mean _std _size _generator _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal(
    $(double _mean)
  , $(double _std)
  , *$(std::vector<int64_t>* _size)
  , *$(at::Generator* _generator)
  , *$(at::TensorOptions* _options)));
  }|]

normal_ddlG
  :: CDouble
  -> CDouble
  -> Ptr IntArray
  -> Ptr Generator
  -> IO (Ptr Tensor)
normal_ddlG _mean _std _size _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal(
    $(double _mean)
  , $(double _std)
  , *$(std::vector<int64_t>* _size)
  , *$(at::Generator* _generator)));
  }|]

normal_ddl
  :: CDouble
  -> CDouble
  -> Ptr IntArray
  -> IO (Ptr Tensor)
normal_ddl _mean _std _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal(
    $(double _mean)
  , $(double _std)
  , *$(std::vector<int64_t>* _size)));
  }|]

normal_out_tddlG
  :: Ptr Tensor
  -> CDouble
  -> CDouble
  -> Ptr IntArray
  -> Ptr Generator
  -> IO (Ptr Tensor)
normal_out_tddlG _out _mean _std _size _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal_out(
    *$(at::Tensor* _out)
  , $(double _mean)
  , $(double _std)
  , *$(std::vector<int64_t>* _size)
  , *$(at::Generator* _generator)));
  }|]

normal_out_tddl
  :: Ptr Tensor
  -> CDouble
  -> CDouble
  -> Ptr IntArray
  -> IO (Ptr Tensor)
normal_out_tddl _out _mean _std _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::normal_out(
    *$(at::Tensor* _out)
  , $(double _mean)
  , $(double _std)
  , *$(std::vector<int64_t>* _size)));
  }|]

alias_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
alias_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::alias(
    *$(at::Tensor* _self)));
  }|]

_amp_foreach_non_finite_check_and_unscale__ltt
  :: Ptr TensorList
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (())
_amp_foreach_non_finite_check_and_unscale__ltt _self _found_inf _inv_scale =
  [C.throwBlock| void {  (at::_amp_foreach_non_finite_check_and_unscale_(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Tensor* _found_inf)
  , *$(at::Tensor* _inv_scale)));
  }|]

_amp_update_scale__tttddl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CDouble
  -> CDouble
  -> Int64
  -> IO (Ptr Tensor)
_amp_update_scale__tttddl _self _growth_tracker _found_inf _scale_growth_factor _scale_backoff_factor _growth_interval =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_amp_update_scale_(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _growth_tracker)
  , *$(at::Tensor* _found_inf)
  , $(double _scale_growth_factor)
  , $(double _scale_backoff_factor)
  , $(int64_t _growth_interval)));
  }|]

_foreach_add_ls
  :: Ptr TensorList
  -> Ptr Scalar
  -> IO (Ptr TensorList)
_foreach_add_ls _self _scalar =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_add(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Scalar* _scalar)));
  }|]

_foreach_add__ls
  :: Ptr TensorList
  -> Ptr Scalar
  -> IO (())
_foreach_add__ls _self _scalar =
  [C.throwBlock| void {  (at::_foreach_add_(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Scalar* _scalar)));
  }|]

_foreach_sub_ls
  :: Ptr TensorList
  -> Ptr Scalar
  -> IO (Ptr TensorList)
_foreach_sub_ls _self _scalar =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_sub(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Scalar* _scalar)));
  }|]

_foreach_sub__ls
  :: Ptr TensorList
  -> Ptr Scalar
  -> IO (())
_foreach_sub__ls _self _scalar =
  [C.throwBlock| void {  (at::_foreach_sub_(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Scalar* _scalar)));
  }|]

_foreach_mul_ls
  :: Ptr TensorList
  -> Ptr Scalar
  -> IO (Ptr TensorList)
_foreach_mul_ls _self _scalar =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_mul(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Scalar* _scalar)));
  }|]

_foreach_mul__ls
  :: Ptr TensorList
  -> Ptr Scalar
  -> IO (())
_foreach_mul__ls _self _scalar =
  [C.throwBlock| void {  (at::_foreach_mul_(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Scalar* _scalar)));
  }|]

_foreach_div_ls
  :: Ptr TensorList
  -> Ptr Scalar
  -> IO (Ptr TensorList)
_foreach_div_ls _self _scalar =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_div(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Scalar* _scalar)));
  }|]

_foreach_div__ls
  :: Ptr TensorList
  -> Ptr Scalar
  -> IO (())
_foreach_div__ls _self _scalar =
  [C.throwBlock| void {  (at::_foreach_div_(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Scalar* _scalar)));
  }|]

_foreach_clamp_min_ls
  :: Ptr TensorList
  -> Ptr Scalar
  -> IO (Ptr TensorList)
_foreach_clamp_min_ls _self _scalar =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_clamp_min(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Scalar* _scalar)));
  }|]

_foreach_clamp_min__ls
  :: Ptr TensorList
  -> Ptr Scalar
  -> IO (())
_foreach_clamp_min__ls _self _scalar =
  [C.throwBlock| void {  (at::_foreach_clamp_min_(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Scalar* _scalar)));
  }|]

_foreach_clamp_max_ls
  :: Ptr TensorList
  -> Ptr Scalar
  -> IO (Ptr TensorList)
_foreach_clamp_max_ls _self _scalar =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_clamp_max(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Scalar* _scalar)));
  }|]

_foreach_clamp_max__ls
  :: Ptr TensorList
  -> Ptr Scalar
  -> IO (())
_foreach_clamp_max__ls _self _scalar =
  [C.throwBlock| void {  (at::_foreach_clamp_max_(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Scalar* _scalar)));
  }|]

_foreach_maximum_ls
  :: Ptr TensorList
  -> Ptr Scalar
  -> IO (Ptr TensorList)
_foreach_maximum_ls _self _scalar =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_maximum(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Scalar* _scalar)));
  }|]

_foreach_maximum__ls
  :: Ptr TensorList
  -> Ptr Scalar
  -> IO (())
_foreach_maximum__ls _self _scalar =
  [C.throwBlock| void {  (at::_foreach_maximum_(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Scalar* _scalar)));
  }|]

_foreach_minimum_ls
  :: Ptr TensorList
  -> Ptr Scalar
  -> IO (Ptr TensorList)
_foreach_minimum_ls _self _scalar =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_minimum(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Scalar* _scalar)));
  }|]

_foreach_minimum__ls
  :: Ptr TensorList
  -> Ptr Scalar
  -> IO (())
_foreach_minimum__ls _self _scalar =
  [C.throwBlock| void {  (at::_foreach_minimum_(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Scalar* _scalar)));
  }|]

_foreach_add_lls
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr Scalar
  -> IO (Ptr TensorList)
_foreach_add_lls _self _other _alpha =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_add(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)
  , *$(at::Scalar* _alpha)));
  }|]

_foreach_add_ll
  :: Ptr TensorList
  -> Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_add_ll _self _other =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_add(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)));
  }|]

_foreach_add__lls
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr Scalar
  -> IO (())
_foreach_add__lls _self _other _alpha =
  [C.throwBlock| void {  (at::_foreach_add_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)
  , *$(at::Scalar* _alpha)));
  }|]

_foreach_add__ll
  :: Ptr TensorList
  -> Ptr TensorList
  -> IO (())
_foreach_add__ll _self _other =
  [C.throwBlock| void {  (at::_foreach_add_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)));
  }|]

_foreach_sub_lls
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr Scalar
  -> IO (Ptr TensorList)
_foreach_sub_lls _self _other _alpha =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_sub(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)
  , *$(at::Scalar* _alpha)));
  }|]

_foreach_sub_ll
  :: Ptr TensorList
  -> Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_sub_ll _self _other =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_sub(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)));
  }|]

_foreach_sub__lls
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr Scalar
  -> IO (())
_foreach_sub__lls _self _other _alpha =
  [C.throwBlock| void {  (at::_foreach_sub_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)
  , *$(at::Scalar* _alpha)));
  }|]

_foreach_sub__ll
  :: Ptr TensorList
  -> Ptr TensorList
  -> IO (())
_foreach_sub__ll _self _other =
  [C.throwBlock| void {  (at::_foreach_sub_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)));
  }|]

_foreach_mul_ll
  :: Ptr TensorList
  -> Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_mul_ll _self _other =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_mul(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)));
  }|]

_foreach_mul__ll
  :: Ptr TensorList
  -> Ptr TensorList
  -> IO (())
_foreach_mul__ll _self _other =
  [C.throwBlock| void {  (at::_foreach_mul_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)));
  }|]

_foreach_div_ll
  :: Ptr TensorList
  -> Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_div_ll _self _other =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_div(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)));
  }|]

_foreach_div__ll
  :: Ptr TensorList
  -> Ptr TensorList
  -> IO (())
_foreach_div__ll _self _other =
  [C.throwBlock| void {  (at::_foreach_div_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)));
  }|]

_foreach_clamp_min_ll
  :: Ptr TensorList
  -> Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_clamp_min_ll _self _other =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_clamp_min(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)));
  }|]

_foreach_clamp_min__ll
  :: Ptr TensorList
  -> Ptr TensorList
  -> IO (())
_foreach_clamp_min__ll _self _other =
  [C.throwBlock| void {  (at::_foreach_clamp_min_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)));
  }|]

_foreach_clamp_max_ll
  :: Ptr TensorList
  -> Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_clamp_max_ll _self _other =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_clamp_max(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)));
  }|]

_foreach_clamp_max__ll
  :: Ptr TensorList
  -> Ptr TensorList
  -> IO (())
_foreach_clamp_max__ll _self _other =
  [C.throwBlock| void {  (at::_foreach_clamp_max_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)));
  }|]

_foreach_maximum_ll
  :: Ptr TensorList
  -> Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_maximum_ll _self _other =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_maximum(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)));
  }|]

_foreach_maximum__ll
  :: Ptr TensorList
  -> Ptr TensorList
  -> IO (())
_foreach_maximum__ll _self _other =
  [C.throwBlock| void {  (at::_foreach_maximum_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)));
  }|]

_foreach_minimum_ll
  :: Ptr TensorList
  -> Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_minimum_ll _self _other =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_minimum(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)));
  }|]

_foreach_minimum__ll
  :: Ptr TensorList
  -> Ptr TensorList
  -> IO (())
_foreach_minimum__ll _self _other =
  [C.throwBlock| void {  (at::_foreach_minimum_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _other)));
  }|]

_foreach_add_lA
  :: Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (Ptr TensorList)
_foreach_add_lA _self _scalars =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_add(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_add__lA
  :: Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (())
_foreach_add__lA _self _scalars =
  [C.throwBlock| void {  (at::_foreach_add_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_sub_lA
  :: Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (Ptr TensorList)
_foreach_sub_lA _self _scalars =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_sub(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_sub__lA
  :: Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (())
_foreach_sub__lA _self _scalars =
  [C.throwBlock| void {  (at::_foreach_sub_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_div_lA
  :: Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (Ptr TensorList)
_foreach_div_lA _self _scalars =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_div(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_div__lA
  :: Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (())
_foreach_div__lA _self _scalars =
  [C.throwBlock| void {  (at::_foreach_div_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_mul_lA
  :: Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (Ptr TensorList)
_foreach_mul_lA _self _scalars =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_mul(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_mul__lA
  :: Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (())
_foreach_mul__lA _self _scalars =
  [C.throwBlock| void {  (at::_foreach_mul_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_clamp_min_lA
  :: Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (Ptr TensorList)
_foreach_clamp_min_lA _self _scalars =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_clamp_min(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_clamp_min__lA
  :: Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (())
_foreach_clamp_min__lA _self _scalars =
  [C.throwBlock| void {  (at::_foreach_clamp_min_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_clamp_max_lA
  :: Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (Ptr TensorList)
_foreach_clamp_max_lA _self _scalars =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_clamp_max(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_clamp_max__lA
  :: Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (())
_foreach_clamp_max__lA _self _scalars =
  [C.throwBlock| void {  (at::_foreach_clamp_max_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_maximum_lA
  :: Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (Ptr TensorList)
_foreach_maximum_lA _self _scalars =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_maximum(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_maximum__lA
  :: Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (())
_foreach_maximum__lA _self _scalars =
  [C.throwBlock| void {  (at::_foreach_maximum_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_minimum_lA
  :: Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (Ptr TensorList)
_foreach_minimum_lA _self _scalars =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_minimum(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_minimum__lA
  :: Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (())
_foreach_minimum__lA _self _scalars =
  [C.throwBlock| void {  (at::_foreach_minimum_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_exp_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_exp_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_exp(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_zero__l
  :: Ptr TensorList
  -> IO (())
_foreach_zero__l _self =
  [C.throwBlock| void {  (at::_foreach_zero_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_exp__l
  :: Ptr TensorList
  -> IO (())
_foreach_exp__l _self =
  [C.throwBlock| void {  (at::_foreach_exp_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_sqrt_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_sqrt_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_sqrt(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_sqrt__l
  :: Ptr TensorList
  -> IO (())
_foreach_sqrt__l _self =
  [C.throwBlock| void {  (at::_foreach_sqrt_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_abs_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_abs_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_abs(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_abs__l
  :: Ptr TensorList
  -> IO (())
_foreach_abs__l _self =
  [C.throwBlock| void {  (at::_foreach_abs_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_acos_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_acos_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_acos(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_acos__l
  :: Ptr TensorList
  -> IO (())
_foreach_acos__l _self =
  [C.throwBlock| void {  (at::_foreach_acos_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_asin_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_asin_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_asin(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_asin__l
  :: Ptr TensorList
  -> IO (())
_foreach_asin__l _self =
  [C.throwBlock| void {  (at::_foreach_asin_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_atan_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_atan_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_atan(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_atan__l
  :: Ptr TensorList
  -> IO (())
_foreach_atan__l _self =
  [C.throwBlock| void {  (at::_foreach_atan_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_ceil_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_ceil_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_ceil(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_ceil__l
  :: Ptr TensorList
  -> IO (())
_foreach_ceil__l _self =
  [C.throwBlock| void {  (at::_foreach_ceil_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_cos_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_cos_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_cos(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_cos__l
  :: Ptr TensorList
  -> IO (())
_foreach_cos__l _self =
  [C.throwBlock| void {  (at::_foreach_cos_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_cosh_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_cosh_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_cosh(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_cosh__l
  :: Ptr TensorList
  -> IO (())
_foreach_cosh__l _self =
  [C.throwBlock| void {  (at::_foreach_cosh_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_erf_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_erf_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_erf(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_erf__l
  :: Ptr TensorList
  -> IO (())
_foreach_erf__l _self =
  [C.throwBlock| void {  (at::_foreach_erf_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_erfc_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_erfc_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_erfc(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_erfc__l
  :: Ptr TensorList
  -> IO (())
_foreach_erfc__l _self =
  [C.throwBlock| void {  (at::_foreach_erfc_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_expm1_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_expm1_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_expm1(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_expm1__l
  :: Ptr TensorList
  -> IO (())
_foreach_expm1__l _self =
  [C.throwBlock| void {  (at::_foreach_expm1_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_floor_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_floor_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_floor(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_floor__l
  :: Ptr TensorList
  -> IO (())
_foreach_floor__l _self =
  [C.throwBlock| void {  (at::_foreach_floor_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_log_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_log_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_log(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_log__l
  :: Ptr TensorList
  -> IO (())
_foreach_log__l _self =
  [C.throwBlock| void {  (at::_foreach_log_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_log10_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_log10_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_log10(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_log10__l
  :: Ptr TensorList
  -> IO (())
_foreach_log10__l _self =
  [C.throwBlock| void {  (at::_foreach_log10_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_log1p_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_log1p_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_log1p(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_log1p__l
  :: Ptr TensorList
  -> IO (())
_foreach_log1p__l _self =
  [C.throwBlock| void {  (at::_foreach_log1p_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_log2_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_log2_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_log2(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_log2__l
  :: Ptr TensorList
  -> IO (())
_foreach_log2__l _self =
  [C.throwBlock| void {  (at::_foreach_log2_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_neg_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_neg_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_neg(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_neg__l
  :: Ptr TensorList
  -> IO (())
_foreach_neg__l _self =
  [C.throwBlock| void {  (at::_foreach_neg_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_tan_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_tan_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_tan(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_tan__l
  :: Ptr TensorList
  -> IO (())
_foreach_tan__l _self =
  [C.throwBlock| void {  (at::_foreach_tan_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_tanh_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_tanh_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_tanh(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_tanh__l
  :: Ptr TensorList
  -> IO (())
_foreach_tanh__l _self =
  [C.throwBlock| void {  (at::_foreach_tanh_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_sin_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_sin_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_sin(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_sin__l
  :: Ptr TensorList
  -> IO (())
_foreach_sin__l _self =
  [C.throwBlock| void {  (at::_foreach_sin_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_sinh_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_sinh_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_sinh(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_sinh__l
  :: Ptr TensorList
  -> IO (())
_foreach_sinh__l _self =
  [C.throwBlock| void {  (at::_foreach_sinh_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_round_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_round_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_round(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_round__l
  :: Ptr TensorList
  -> IO (())
_foreach_round__l _self =
  [C.throwBlock| void {  (at::_foreach_round_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_lgamma_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_lgamma_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_lgamma(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_lgamma__l
  :: Ptr TensorList
  -> IO (())
_foreach_lgamma__l _self =
  [C.throwBlock| void {  (at::_foreach_lgamma_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_frac_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_frac_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_frac(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_frac__l
  :: Ptr TensorList
  -> IO (())
_foreach_frac__l _self =
  [C.throwBlock| void {  (at::_foreach_frac_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_reciprocal_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_reciprocal_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_reciprocal(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_reciprocal__l
  :: Ptr TensorList
  -> IO (())
_foreach_reciprocal__l _self =
  [C.throwBlock| void {  (at::_foreach_reciprocal_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_sigmoid_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_sigmoid_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_sigmoid(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_sigmoid__l
  :: Ptr TensorList
  -> IO (())
_foreach_sigmoid__l _self =
  [C.throwBlock| void {  (at::_foreach_sigmoid_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_trunc_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_trunc_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_trunc(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_trunc__l
  :: Ptr TensorList
  -> IO (())
_foreach_trunc__l _self =
  [C.throwBlock| void {  (at::_foreach_trunc_(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_addcdiv__llls
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> Ptr Scalar
  -> IO (())
_foreach_addcdiv__llls _self _tensor1 _tensor2 _value =
  [C.throwBlock| void {  (at::_foreach_addcdiv_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensor1)
  , *$(std::vector<at::Tensor>* _tensor2)
  , *$(at::Scalar* _value)));
  }|]

_foreach_addcdiv__lll
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> IO (())
_foreach_addcdiv__lll _self _tensor1 _tensor2 =
  [C.throwBlock| void {  (at::_foreach_addcdiv_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensor1)
  , *$(std::vector<at::Tensor>* _tensor2)));
  }|]

_foreach_addcmul__llls
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> Ptr Scalar
  -> IO (())
_foreach_addcmul__llls _self _tensor1 _tensor2 _value =
  [C.throwBlock| void {  (at::_foreach_addcmul_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensor1)
  , *$(std::vector<at::Tensor>* _tensor2)
  , *$(at::Scalar* _value)));
  }|]

_foreach_addcmul__lll
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> IO (())
_foreach_addcmul__lll _self _tensor1 _tensor2 =
  [C.throwBlock| void {  (at::_foreach_addcmul_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensor1)
  , *$(std::vector<at::Tensor>* _tensor2)));
  }|]

_foreach_addcdiv__lllA
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (())
_foreach_addcdiv__lllA _self _tensor1 _tensor2 _scalars =
  [C.throwBlock| void {  (at::_foreach_addcdiv_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensor1)
  , *$(std::vector<at::Tensor>* _tensor2)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_addcdiv__lllt
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> Ptr Tensor
  -> IO (())
_foreach_addcdiv__lllt _self _tensor1 _tensor2 _scalars =
  [C.throwBlock| void {  (at::_foreach_addcdiv_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensor1)
  , *$(std::vector<at::Tensor>* _tensor2)
  , *$(at::Tensor* _scalars)));
  }|]

_foreach_addcmul__lllA
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (())
_foreach_addcmul__lllA _self _tensor1 _tensor2 _scalars =
  [C.throwBlock| void {  (at::_foreach_addcmul_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensor1)
  , *$(std::vector<at::Tensor>* _tensor2)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_addcmul__lllt
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> Ptr Tensor
  -> IO (())
_foreach_addcmul__lllt _self _tensor1 _tensor2 _scalars =
  [C.throwBlock| void {  (at::_foreach_addcmul_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensor1)
  , *$(std::vector<at::Tensor>* _tensor2)
  , *$(at::Tensor* _scalars)));
  }|]

_foreach_addcdiv_llls
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> Ptr Scalar
  -> IO (Ptr TensorList)
_foreach_addcdiv_llls _self _tensor1 _tensor2 _value =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_addcdiv(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensor1)
  , *$(std::vector<at::Tensor>* _tensor2)
  , *$(at::Scalar* _value)));
  }|]

_foreach_addcdiv_lll
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_addcdiv_lll _self _tensor1 _tensor2 =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_addcdiv(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensor1)
  , *$(std::vector<at::Tensor>* _tensor2)));
  }|]

_foreach_addcmul_llls
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> Ptr Scalar
  -> IO (Ptr TensorList)
_foreach_addcmul_llls _self _tensor1 _tensor2 _value =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_addcmul(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensor1)
  , *$(std::vector<at::Tensor>* _tensor2)
  , *$(at::Scalar* _value)));
  }|]

_foreach_addcmul_lll
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_addcmul_lll _self _tensor1 _tensor2 =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_addcmul(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensor1)
  , *$(std::vector<at::Tensor>* _tensor2)));
  }|]

_foreach_addcdiv_lllA
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (Ptr TensorList)
_foreach_addcdiv_lllA _self _tensor1 _tensor2 _scalars =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_addcdiv(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensor1)
  , *$(std::vector<at::Tensor>* _tensor2)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_addcdiv_lllt
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> Ptr Tensor
  -> IO (Ptr TensorList)
_foreach_addcdiv_lllt _self _tensor1 _tensor2 _scalars =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_addcdiv(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensor1)
  , *$(std::vector<at::Tensor>* _tensor2)
  , *$(at::Tensor* _scalars)));
  }|]

_foreach_addcmul_lllA
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> Ptr (StdVector Scalar)
  -> IO (Ptr TensorList)
_foreach_addcmul_lllA _self _tensor1 _tensor2 _scalars =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_addcmul(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensor1)
  , *$(std::vector<at::Tensor>* _tensor2)
  , *$(std::vector<at::Scalar>* _scalars)));
  }|]

_foreach_addcmul_lllt
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> Ptr Tensor
  -> IO (Ptr TensorList)
_foreach_addcmul_lllt _self _tensor1 _tensor2 _scalars =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_addcmul(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensor1)
  , *$(std::vector<at::Tensor>* _tensor2)
  , *$(at::Tensor* _scalars)));
  }|]

_foreach_norm_ls
  :: Ptr TensorList
  -> Ptr Scalar
  -> IO (Ptr TensorList)
_foreach_norm_ls _self _ord =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_norm(
    *$(std::vector<at::Tensor>* _self)
  , *$(at::Scalar* _ord)));
  }|]

_foreach_norm_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_norm_l _self =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_norm(
    *$(std::vector<at::Tensor>* _self)));
  }|]

_foreach_lerp_lll
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> IO (Ptr TensorList)
_foreach_lerp_lll _self _tensors1 _weights =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_lerp(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensors1)
  , *$(std::vector<at::Tensor>* _weights)));
  }|]

_foreach_lerp__lll
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr TensorList
  -> IO (())
_foreach_lerp__lll _self _tensors1 _weights =
  [C.throwBlock| void {  (at::_foreach_lerp_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensors1)
  , *$(std::vector<at::Tensor>* _weights)));
  }|]

_foreach_lerp_lls
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr Scalar
  -> IO (Ptr TensorList)
_foreach_lerp_lls _self _tensors1 _weight =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::_foreach_lerp(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensors1)
  , *$(at::Scalar* _weight)));
  }|]

_foreach_lerp__lls
  :: Ptr TensorList
  -> Ptr TensorList
  -> Ptr Scalar
  -> IO (())
_foreach_lerp__lls _self _tensors1 _weight =
  [C.throwBlock| void {  (at::_foreach_lerp_(
    *$(std::vector<at::Tensor>* _self)
  , *$(std::vector<at::Tensor>* _tensors1)
  , *$(at::Scalar* _weight)));
  }|]

bucketize_ttbb
  :: Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> CBool
  -> IO (Ptr Tensor)
bucketize_ttbb _self _boundaries _out_int32 _right =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bucketize(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _boundaries)
  , $(bool _out_int32)
  , $(bool _right)));
  }|]

bucketize_ttb
  :: Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
bucketize_ttb _self _boundaries _out_int32 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bucketize(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _boundaries)
  , $(bool _out_int32)));
  }|]

bucketize_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
bucketize_tt _self _boundaries =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bucketize(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _boundaries)));
  }|]

bucketize_out_tttbb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> CBool
  -> IO (Ptr Tensor)
bucketize_out_tttbb _out _self _boundaries _out_int32 _right =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bucketize_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _boundaries)
  , $(bool _out_int32)
  , $(bool _right)));
  }|]

bucketize_out_tttb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
bucketize_out_tttb _out _self _boundaries _out_int32 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bucketize_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _boundaries)
  , $(bool _out_int32)));
  }|]

bucketize_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
bucketize_out_ttt _out _self _boundaries =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bucketize_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _boundaries)));
  }|]

bucketize_stbb
  :: Ptr Scalar
  -> Ptr Tensor
  -> CBool
  -> CBool
  -> IO (Ptr Tensor)
bucketize_stbb _self _boundaries _out_int32 _right =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bucketize(
    *$(at::Scalar* _self)
  , *$(at::Tensor* _boundaries)
  , $(bool _out_int32)
  , $(bool _right)));
  }|]

bucketize_stb
  :: Ptr Scalar
  -> Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
bucketize_stb _self _boundaries _out_int32 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bucketize(
    *$(at::Scalar* _self)
  , *$(at::Tensor* _boundaries)
  , $(bool _out_int32)));
  }|]

bucketize_st
  :: Ptr Scalar
  -> Ptr Tensor
  -> IO (Ptr Tensor)
bucketize_st _self _boundaries =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bucketize(
    *$(at::Scalar* _self)
  , *$(at::Tensor* _boundaries)));
  }|]

searchsorted_ttbbst
  :: Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> CBool
  -> Ptr StdString
  -> Ptr Tensor
  -> IO (Ptr Tensor)
searchsorted_ttbbst _sorted_sequence _self _out_int32 _right _side _sorter =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::searchsorted(
    *$(at::Tensor* _sorted_sequence)
  , *$(at::Tensor* _self)
  , $(bool _out_int32)
  , $(bool _right)
  , *$(std::string* _side)
  , *$(at::Tensor* _sorter)));
  }|]

searchsorted_ttbbs
  :: Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> CBool
  -> Ptr StdString
  -> IO (Ptr Tensor)
searchsorted_ttbbs _sorted_sequence _self _out_int32 _right _side =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::searchsorted(
    *$(at::Tensor* _sorted_sequence)
  , *$(at::Tensor* _self)
  , $(bool _out_int32)
  , $(bool _right)
  , *$(std::string* _side)));
  }|]

searchsorted_ttbb
  :: Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> CBool
  -> IO (Ptr Tensor)
searchsorted_ttbb _sorted_sequence _self _out_int32 _right =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::searchsorted(
    *$(at::Tensor* _sorted_sequence)
  , *$(at::Tensor* _self)
  , $(bool _out_int32)
  , $(bool _right)));
  }|]

searchsorted_ttb
  :: Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
searchsorted_ttb _sorted_sequence _self _out_int32 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::searchsorted(
    *$(at::Tensor* _sorted_sequence)
  , *$(at::Tensor* _self)
  , $(bool _out_int32)));
  }|]

searchsorted_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
searchsorted_tt _sorted_sequence _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::searchsorted(
    *$(at::Tensor* _sorted_sequence)
  , *$(at::Tensor* _self)));
  }|]

searchsorted_out_tttbbst
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> CBool
  -> Ptr StdString
  -> Ptr Tensor
  -> IO (Ptr Tensor)
searchsorted_out_tttbbst _out _sorted_sequence _self _out_int32 _right _side _sorter =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::searchsorted_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _sorted_sequence)
  , *$(at::Tensor* _self)
  , $(bool _out_int32)
  , $(bool _right)
  , *$(std::string* _side)
  , *$(at::Tensor* _sorter)));
  }|]

searchsorted_out_tttbbs
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> CBool
  -> Ptr StdString
  -> IO (Ptr Tensor)
searchsorted_out_tttbbs _out _sorted_sequence _self _out_int32 _right _side =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::searchsorted_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _sorted_sequence)
  , *$(at::Tensor* _self)
  , $(bool _out_int32)
  , $(bool _right)
  , *$(std::string* _side)));
  }|]

searchsorted_out_tttbb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> CBool
  -> IO (Ptr Tensor)
searchsorted_out_tttbb _out _sorted_sequence _self _out_int32 _right =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::searchsorted_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _sorted_sequence)
  , *$(at::Tensor* _self)
  , $(bool _out_int32)
  , $(bool _right)));
  }|]

searchsorted_out_tttb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
searchsorted_out_tttb _out _sorted_sequence _self _out_int32 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::searchsorted_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _sorted_sequence)
  , *$(at::Tensor* _self)
  , $(bool _out_int32)));
  }|]

searchsorted_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
searchsorted_out_ttt _out _sorted_sequence _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::searchsorted_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _sorted_sequence)
  , *$(at::Tensor* _self)));
  }|]

searchsorted_tsbbst
  :: Ptr Tensor
  -> Ptr Scalar
  -> CBool
  -> CBool
  -> Ptr StdString
  -> Ptr Tensor
  -> IO (Ptr Tensor)
searchsorted_tsbbst _sorted_sequence _self _out_int32 _right _side _sorter =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::searchsorted(
    *$(at::Tensor* _sorted_sequence)
  , *$(at::Scalar* _self)
  , $(bool _out_int32)
  , $(bool _right)
  , *$(std::string* _side)
  , *$(at::Tensor* _sorter)));
  }|]

searchsorted_tsbbs
  :: Ptr Tensor
  -> Ptr Scalar
  -> CBool
  -> CBool
  -> Ptr StdString
  -> IO (Ptr Tensor)
searchsorted_tsbbs _sorted_sequence _self _out_int32 _right _side =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::searchsorted(
    *$(at::Tensor* _sorted_sequence)
  , *$(at::Scalar* _self)
  , $(bool _out_int32)
  , $(bool _right)
  , *$(std::string* _side)));
  }|]

searchsorted_tsbb
  :: Ptr Tensor
  -> Ptr Scalar
  -> CBool
  -> CBool
  -> IO (Ptr Tensor)
searchsorted_tsbb _sorted_sequence _self _out_int32 _right =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::searchsorted(
    *$(at::Tensor* _sorted_sequence)
  , *$(at::Scalar* _self)
  , $(bool _out_int32)
  , $(bool _right)));
  }|]

searchsorted_tsb
  :: Ptr Tensor
  -> Ptr Scalar
  -> CBool
  -> IO (Ptr Tensor)
searchsorted_tsb _sorted_sequence _self _out_int32 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::searchsorted(
    *$(at::Tensor* _sorted_sequence)
  , *$(at::Scalar* _self)
  , $(bool _out_int32)));
  }|]

searchsorted_ts
  :: Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
searchsorted_ts _sorted_sequence _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::searchsorted(
    *$(at::Tensor* _sorted_sequence)
  , *$(at::Scalar* _self)));
  }|]

_convert_indices_from_coo_to_csr_tlb
  :: Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
_convert_indices_from_coo_to_csr_tlb _self _size _out_int32 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_convert_indices_from_coo_to_csr(
    *$(at::Tensor* _self)
  , $(int64_t _size)
  , $(bool _out_int32)));
  }|]

_convert_indices_from_coo_to_csr_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
_convert_indices_from_coo_to_csr_tl _self _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_convert_indices_from_coo_to_csr(
    *$(at::Tensor* _self)
  , $(int64_t _size)));
  }|]

_convert_indices_from_coo_to_csr_out_ttlb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
_convert_indices_from_coo_to_csr_out_ttlb _out _self _size _out_int32 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_convert_indices_from_coo_to_csr_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , $(int64_t _size)
  , $(bool _out_int32)));
  }|]

_convert_indices_from_coo_to_csr_out_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
_convert_indices_from_coo_to_csr_out_ttl _out _self _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_convert_indices_from_coo_to_csr_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , $(int64_t _size)));
  }|]

_convert_indices_from_csr_to_coo_ttbb
  :: Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> CBool
  -> IO (Ptr Tensor)
_convert_indices_from_csr_to_coo_ttbb _crow_indices _col_indices _out_int32 _transpose =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_convert_indices_from_csr_to_coo(
    *$(at::Tensor* _crow_indices)
  , *$(at::Tensor* _col_indices)
  , $(bool _out_int32)
  , $(bool _transpose)));
  }|]

_convert_indices_from_csr_to_coo_ttb
  :: Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
_convert_indices_from_csr_to_coo_ttb _crow_indices _col_indices _out_int32 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_convert_indices_from_csr_to_coo(
    *$(at::Tensor* _crow_indices)
  , *$(at::Tensor* _col_indices)
  , $(bool _out_int32)));
  }|]

_convert_indices_from_csr_to_coo_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
_convert_indices_from_csr_to_coo_tt _crow_indices _col_indices =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_convert_indices_from_csr_to_coo(
    *$(at::Tensor* _crow_indices)
  , *$(at::Tensor* _col_indices)));
  }|]

_convert_indices_from_csr_to_coo_out_tttbb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> CBool
  -> IO (Ptr Tensor)
_convert_indices_from_csr_to_coo_out_tttbb _out _crow_indices _col_indices _out_int32 _transpose =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_convert_indices_from_csr_to_coo_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _crow_indices)
  , *$(at::Tensor* _col_indices)
  , $(bool _out_int32)
  , $(bool _transpose)));
  }|]

_convert_indices_from_csr_to_coo_out_tttb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
_convert_indices_from_csr_to_coo_out_tttb _out _crow_indices _col_indices _out_int32 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_convert_indices_from_csr_to_coo_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _crow_indices)
  , *$(at::Tensor* _col_indices)
  , $(bool _out_int32)));
  }|]

_convert_indices_from_csr_to_coo_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
_convert_indices_from_csr_to_coo_out_ttt _out _crow_indices _col_indices =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_convert_indices_from_csr_to_coo_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _crow_indices)
  , *$(at::Tensor* _col_indices)));
  }|]

mse_loss_out_tttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
mse_loss_out_tttl _out _self _target _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::mse_loss_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , $(int64_t _reduction)));
  }|]

mse_loss_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
mse_loss_out_ttt _out _self _target =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::mse_loss_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)));
  }|]

mse_loss_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
mse_loss_ttl _self _target _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::mse_loss(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , $(int64_t _reduction)));
  }|]

mse_loss_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
mse_loss_tt _self _target =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::mse_loss(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)));
  }|]

mse_loss_backward_out_ttttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
mse_loss_backward_out_ttttl _grad_input _grad_output _self _target _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::mse_loss_backward_out(
    *$(at::Tensor* _grad_input)
  , *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , $(int64_t _reduction)));
  }|]

mse_loss_backward_tttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
mse_loss_backward_tttl _grad_output _self _target _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::mse_loss_backward(
    *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , $(int64_t _reduction)));
  }|]

l1_loss_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
l1_loss_ttl _self _target _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::l1_loss(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , $(int64_t _reduction)));
  }|]

l1_loss_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
l1_loss_tt _self _target =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::l1_loss(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)));
  }|]

multi_margin_loss_out_tttsstl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
multi_margin_loss_out_tttsstl _out _self _target _p _margin _weight _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multi_margin_loss_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Scalar* _p)
  , *$(at::Scalar* _margin)
  , *$(at::Tensor* _weight)
  , $(int64_t _reduction)));
  }|]

multi_margin_loss_out_tttsst
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> Ptr Tensor
  -> IO (Ptr Tensor)
multi_margin_loss_out_tttsst _out _self _target _p _margin _weight =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multi_margin_loss_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Scalar* _p)
  , *$(at::Scalar* _margin)
  , *$(at::Tensor* _weight)));
  }|]

multi_margin_loss_out_tttss
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
multi_margin_loss_out_tttss _out _self _target _p _margin =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multi_margin_loss_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Scalar* _p)
  , *$(at::Scalar* _margin)));
  }|]

multi_margin_loss_out_ttts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
multi_margin_loss_out_ttts _out _self _target _p =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multi_margin_loss_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Scalar* _p)));
  }|]

multi_margin_loss_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
multi_margin_loss_out_ttt _out _self _target =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multi_margin_loss_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)));
  }|]

multi_margin_loss_ttsstl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
multi_margin_loss_ttsstl _self _target _p _margin _weight _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multi_margin_loss(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Scalar* _p)
  , *$(at::Scalar* _margin)
  , *$(at::Tensor* _weight)
  , $(int64_t _reduction)));
  }|]

multi_margin_loss_ttsst
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> Ptr Tensor
  -> IO (Ptr Tensor)
multi_margin_loss_ttsst _self _target _p _margin _weight =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multi_margin_loss(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Scalar* _p)
  , *$(at::Scalar* _margin)
  , *$(at::Tensor* _weight)));
  }|]

multi_margin_loss_ttss
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
multi_margin_loss_ttss _self _target _p _margin =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multi_margin_loss(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Scalar* _p)
  , *$(at::Scalar* _margin)));
  }|]

multi_margin_loss_tts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
multi_margin_loss_tts _self _target _p =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multi_margin_loss(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Scalar* _p)));
  }|]

multi_margin_loss_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
multi_margin_loss_tt _self _target =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multi_margin_loss(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)));
  }|]

multi_margin_loss_backward_out_ttttsstl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
multi_margin_loss_backward_out_ttttsstl _grad_input _grad_output _self _target _p _margin _weight _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multi_margin_loss_backward_out(
    *$(at::Tensor* _grad_input)
  , *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Scalar* _p)
  , *$(at::Scalar* _margin)
  , *$(at::Tensor* _weight)
  , $(int64_t _reduction)));
  }|]

multi_margin_loss_backward_out_ttttsst
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> Ptr Tensor
  -> IO (Ptr Tensor)
multi_margin_loss_backward_out_ttttsst _grad_input _grad_output _self _target _p _margin _weight =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multi_margin_loss_backward_out(
    *$(at::Tensor* _grad_input)
  , *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Scalar* _p)
  , *$(at::Scalar* _margin)
  , *$(at::Tensor* _weight)));
  }|]

multi_margin_loss_backward_out_ttttss
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
multi_margin_loss_backward_out_ttttss _grad_input _grad_output _self _target _p _margin =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multi_margin_loss_backward_out(
    *$(at::Tensor* _grad_input)
  , *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Scalar* _p)
  , *$(at::Scalar* _margin)));
  }|]

multi_margin_loss_backward_tttsstl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
multi_margin_loss_backward_tttsstl _grad_output _self _target _p _margin _weight _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multi_margin_loss_backward(
    *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Scalar* _p)
  , *$(at::Scalar* _margin)
  , *$(at::Tensor* _weight)
  , $(int64_t _reduction)));
  }|]

multi_margin_loss_backward_tttsst
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> Ptr Tensor
  -> IO (Ptr Tensor)
multi_margin_loss_backward_tttsst _grad_output _self _target _p _margin _weight =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multi_margin_loss_backward(
    *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Scalar* _p)
  , *$(at::Scalar* _margin)
  , *$(at::Tensor* _weight)));
  }|]

multi_margin_loss_backward_tttss
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
multi_margin_loss_backward_tttss _grad_output _self _target _p _margin =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multi_margin_loss_backward(
    *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Scalar* _p)
  , *$(at::Scalar* _margin)));
  }|]

multilabel_margin_loss_out_tttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
multilabel_margin_loss_out_tttl _out _self _target _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multilabel_margin_loss_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , $(int64_t _reduction)));
  }|]

multilabel_margin_loss_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
multilabel_margin_loss_out_ttt _out _self _target =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multilabel_margin_loss_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)));
  }|]

multilabel_margin_loss_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
multilabel_margin_loss_ttl _self _target _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multilabel_margin_loss(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , $(int64_t _reduction)));
  }|]

multilabel_margin_loss_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
multilabel_margin_loss_tt _self _target =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multilabel_margin_loss(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)));
  }|]

multilabel_margin_loss_forward_out_ttttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
multilabel_margin_loss_forward_out_ttttl _output _is_target _self _target _reduction =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::multilabel_margin_loss_forward_out(
    *$(at::Tensor* _output)
  , *$(at::Tensor* _is_target)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , $(int64_t _reduction)));
  }|]

multilabel_margin_loss_forward_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
multilabel_margin_loss_forward_ttl _self _target _reduction =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::multilabel_margin_loss_forward(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , $(int64_t _reduction)));
  }|]

multilabel_margin_loss_backward_out_ttttlt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> Ptr Tensor
  -> IO (Ptr Tensor)
multilabel_margin_loss_backward_out_ttttlt _grad_input _grad_output _self _target _reduction _is_target =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multilabel_margin_loss_backward_out(
    *$(at::Tensor* _grad_input)
  , *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , $(int64_t _reduction)
  , *$(at::Tensor* _is_target)));
  }|]

multilabel_margin_loss_backward_tttlt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> Ptr Tensor
  -> IO (Ptr Tensor)
multilabel_margin_loss_backward_tttlt _grad_output _self _target _reduction _is_target =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::multilabel_margin_loss_backward(
    *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , $(int64_t _reduction)
  , *$(at::Tensor* _is_target)));
  }|]

nll_loss_out_ttttll
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> Int64
  -> IO (Ptr Tensor)
nll_loss_out_ttttll _out _self _target _weight _reduction _ignore_index =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nll_loss_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Tensor* _weight)
  , $(int64_t _reduction)
  , $(int64_t _ignore_index)));
  }|]

nll_loss_out_ttttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
nll_loss_out_ttttl _out _self _target _weight _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nll_loss_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Tensor* _weight)
  , $(int64_t _reduction)));
  }|]

nll_loss_out_tttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
nll_loss_out_tttt _out _self _target _weight =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nll_loss_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Tensor* _weight)));
  }|]

nll_loss_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
nll_loss_out_ttt _out _self _target =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nll_loss_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)));
  }|]

nll_loss_nd_tttll
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> Int64
  -> IO (Ptr Tensor)
nll_loss_nd_tttll _self _target _weight _reduction _ignore_index =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nll_loss_nd(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Tensor* _weight)
  , $(int64_t _reduction)
  , $(int64_t _ignore_index)));
  }|]

nll_loss_nd_tttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
nll_loss_nd_tttl _self _target _weight _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nll_loss_nd(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Tensor* _weight)
  , $(int64_t _reduction)));
  }|]

nll_loss_nd_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
nll_loss_nd_ttt _self _target _weight =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nll_loss_nd(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Tensor* _weight)));
  }|]

nll_loss_nd_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
nll_loss_nd_tt _self _target =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::nll_loss_nd(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)));
  }|]

