
-- generated by using spec/Declarations.yaml

{-# LANGUAGE DataKinds #-}
{-# LANGUAGE PolyKinds #-}
{-# LANGUAGE TemplateHaskell #-}
{-# LANGUAGE QuasiQuotes #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE OverloadedStrings #-}

module Torch.Internal.Unmanaged.Native.Native0 where


import Foreign.C.String
import Foreign.C.Types
import Foreign
import Torch.Internal.Type

import qualified Language.C.Inline.Cpp as C
import qualified Language.C.Inline.Cpp.Unsafe as C
import qualified Language.C.Inline.Context as C
import qualified Language.C.Types as C

C.context $ C.cppCtx <> mempty { C.ctxTypesTable = typeTable }

C.include "<vector>"
C.include "<ATen/Tensor.h>"
C.include "<ATen/Functions.h>"


_cast_Byte_tb
  :: Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
_cast_Byte_tb _self _non_blocking =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cast_Byte(
    *$(at::Tensor* _self)
  , $(bool _non_blocking)));
  }|]

_cast_Byte_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_cast_Byte_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cast_Byte(
    *$(at::Tensor* _self)));
  }|]

_cast_Char_tb
  :: Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
_cast_Char_tb _self _non_blocking =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cast_Char(
    *$(at::Tensor* _self)
  , $(bool _non_blocking)));
  }|]

_cast_Char_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_cast_Char_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cast_Char(
    *$(at::Tensor* _self)));
  }|]

_cast_Double_tb
  :: Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
_cast_Double_tb _self _non_blocking =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cast_Double(
    *$(at::Tensor* _self)
  , $(bool _non_blocking)));
  }|]

_cast_Double_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_cast_Double_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cast_Double(
    *$(at::Tensor* _self)));
  }|]

_cast_Float_tb
  :: Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
_cast_Float_tb _self _non_blocking =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cast_Float(
    *$(at::Tensor* _self)
  , $(bool _non_blocking)));
  }|]

_cast_Float_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_cast_Float_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cast_Float(
    *$(at::Tensor* _self)));
  }|]

_cast_Int_tb
  :: Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
_cast_Int_tb _self _non_blocking =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cast_Int(
    *$(at::Tensor* _self)
  , $(bool _non_blocking)));
  }|]

_cast_Int_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_cast_Int_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cast_Int(
    *$(at::Tensor* _self)));
  }|]

_cast_Long_tb
  :: Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
_cast_Long_tb _self _non_blocking =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cast_Long(
    *$(at::Tensor* _self)
  , $(bool _non_blocking)));
  }|]

_cast_Long_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_cast_Long_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cast_Long(
    *$(at::Tensor* _self)));
  }|]

_cast_Short_tb
  :: Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
_cast_Short_tb _self _non_blocking =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cast_Short(
    *$(at::Tensor* _self)
  , $(bool _non_blocking)));
  }|]

_cast_Short_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_cast_Short_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cast_Short(
    *$(at::Tensor* _self)));
  }|]

_cast_Half_tb
  :: Ptr Tensor
  -> CBool
  -> IO (Ptr Tensor)
_cast_Half_tb _self _non_blocking =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cast_Half(
    *$(at::Tensor* _self)
  , $(bool _non_blocking)));
  }|]

_cast_Half_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_cast_Half_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cast_Half(
    *$(at::Tensor* _self)));
  }|]

_make_dual_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
_make_dual_ttl _primal _tangent _level =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_make_dual(
    *$(at::Tensor* _primal)
  , *$(at::Tensor* _tangent)
  , $(int64_t _level)));
  }|]

_unpack_dual_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
_unpack_dual_tl _dual _level =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::_unpack_dual(
    *$(at::Tensor* _dual)
  , $(int64_t _level)));
  }|]

_new_zeros_with_same_feature_meta_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
_new_zeros_with_same_feature_meta_ttl _self _other _self_num_batch_dims =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_new_zeros_with_same_feature_meta(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)
  , $(int64_t _self_num_batch_dims)));
  }|]

_new_zeros_with_same_feature_meta_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
_new_zeros_with_same_feature_meta_tt _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_new_zeros_with_same_feature_meta(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

_has_same_storage_numel_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (CBool)
_has_same_storage_numel_tt _self _other =
  [C.throwBlock| bool { return (at::_has_same_storage_numel(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

align_tensors_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
align_tensors_l _tensors =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::align_tensors(
    *$(std::vector<at::Tensor>* _tensors)));
  }|]

_assert_async_t
  :: Ptr Tensor
  -> IO (())
_assert_async_t _self =
  [C.throwBlock| void {  (at::_assert_async(
    *$(at::Tensor* _self)));
  }|]

_assert_tensor_metadata_tlls
  :: Ptr Tensor
  -> Ptr IntArray
  -> Ptr IntArray
  -> ScalarType
  -> IO (())
_assert_tensor_metadata_tlls _a _size _stride _dtype =
  [C.throwBlock| void {  (at::_assert_tensor_metadata(
    *$(at::Tensor* _a)
  , *$(std::vector<int64_t>* _size)
  , *$(std::vector<int64_t>* _stride)
  , $(at::ScalarType _dtype)));
  }|]

_assert_tensor_metadata_tll
  :: Ptr Tensor
  -> Ptr IntArray
  -> Ptr IntArray
  -> IO (())
_assert_tensor_metadata_tll _a _size _stride =
  [C.throwBlock| void {  (at::_assert_tensor_metadata(
    *$(at::Tensor* _a)
  , *$(std::vector<int64_t>* _size)
  , *$(std::vector<int64_t>* _stride)));
  }|]

_assert_tensor_metadata_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (())
_assert_tensor_metadata_tl _a _size =
  [C.throwBlock| void {  (at::_assert_tensor_metadata(
    *$(at::Tensor* _a)
  , *$(std::vector<int64_t>* _size)));
  }|]

_assert_tensor_metadata_t
  :: Ptr Tensor
  -> IO (())
_assert_tensor_metadata_t _a =
  [C.throwBlock| void {  (at::_assert_tensor_metadata(
    *$(at::Tensor* _a)));
  }|]

_use_cudnn_ctc_loss_ttlll
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr IntArray
  -> Int64
  -> IO (CBool)
_use_cudnn_ctc_loss_ttlll _log_probs _targets _input_lengths _target_lengths _blank =
  [C.throwBlock| bool { return (at::_use_cudnn_ctc_loss(
    *$(at::Tensor* _log_probs)
  , *$(at::Tensor* _targets)
  , *$(std::vector<int64_t>* _input_lengths)
  , *$(std::vector<int64_t>* _target_lengths)
  , $(int64_t _blank)));
  }|]

_use_cudnn_ctc_loss_ttttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (CBool)
_use_cudnn_ctc_loss_ttttl _log_probs _targets _input_lengths _target_lengths _blank =
  [C.throwBlock| bool { return (at::_use_cudnn_ctc_loss(
    *$(at::Tensor* _log_probs)
  , *$(at::Tensor* _targets)
  , *$(at::Tensor* _input_lengths)
  , *$(at::Tensor* _target_lengths)
  , $(int64_t _blank)));
  }|]

_cudnn_ctc_loss_ttlllbb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr IntArray
  -> Ptr IntArray
  -> Int64
  -> CBool
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
_cudnn_ctc_loss_ttlllbb _log_probs _targets _input_lengths _target_lengths _blank _deterministic _zero_infinity =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::_cudnn_ctc_loss(
    *$(at::Tensor* _log_probs)
  , *$(at::Tensor* _targets)
  , *$(std::vector<int64_t>* _input_lengths)
  , *$(std::vector<int64_t>* _target_lengths)
  , $(int64_t _blank)
  , $(bool _deterministic)
  , $(bool _zero_infinity)));
  }|]

_cudnn_ctc_loss_ttttlbb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> CBool
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
_cudnn_ctc_loss_ttttlbb _log_probs _targets _input_lengths _target_lengths _blank _deterministic _zero_infinity =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::_cudnn_ctc_loss(
    *$(at::Tensor* _log_probs)
  , *$(at::Tensor* _targets)
  , *$(at::Tensor* _input_lengths)
  , *$(at::Tensor* _target_lengths)
  , $(int64_t _blank)
  , $(bool _deterministic)
  , $(bool _zero_infinity)));
  }|]

_use_cudnn_rnn_flatten_weight
  :: IO (CBool)
_use_cudnn_rnn_flatten_weight  =
  [C.throwBlock| bool { return (at::_use_cudnn_rnn_flatten_weight(
    ));
  }|]

_cudnn_rnn_flatten_weight_lllllllbb
  :: Ptr TensorList
  -> Int64
  -> Int64
  -> Int64
  -> Int64
  -> Int64
  -> Int64
  -> CBool
  -> CBool
  -> IO (Ptr Tensor)
_cudnn_rnn_flatten_weight_lllllllbb _weight_arr _weight_stride0 _input_size _mode _hidden_size _proj_size _num_layers _batch_first _bidirectional =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cudnn_rnn_flatten_weight(
    *$(std::vector<at::Tensor>* _weight_arr)
  , $(int64_t _weight_stride0)
  , $(int64_t _input_size)
  , $(int64_t _mode)
  , $(int64_t _hidden_size)
  , $(int64_t _proj_size)
  , $(int64_t _num_layers)
  , $(bool _batch_first)
  , $(bool _bidirectional)));
  }|]

_cudnn_rnn_tlltttllllbdbblt
  :: Ptr Tensor
  -> Ptr TensorList
  -> Int64
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> Int64
  -> Int64
  -> Int64
  -> CBool
  -> CDouble
  -> CBool
  -> CBool
  -> Ptr IntArray
  -> Ptr Tensor
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor,Tensor,Tensor)))
_cudnn_rnn_tlltttllllbdbblt _input _weight _weight_stride0 _weight_buf _hx _cx _mode _hidden_size _proj_size _num_layers _batch_first _dropout _train _bidirectional _batch_sizes _dropout_state =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor,at::Tensor>(at::_cudnn_rnn(
    *$(at::Tensor* _input)
  , *$(std::vector<at::Tensor>* _weight)
  , $(int64_t _weight_stride0)
  , *$(at::Tensor* _weight_buf)
  , *$(at::Tensor* _hx)
  , *$(at::Tensor* _cx)
  , $(int64_t _mode)
  , $(int64_t _hidden_size)
  , $(int64_t _proj_size)
  , $(int64_t _num_layers)
  , $(bool _batch_first)
  , $(double _dropout)
  , $(bool _train)
  , $(bool _bidirectional)
  , *$(std::vector<int64_t>* _batch_sizes)
  , *$(at::Tensor* _dropout_state)));
  }|]

_cudnn_rnn_backward_tlltttttttllllbdbbltta
  :: Ptr Tensor
  -> Ptr TensorList
  -> Int64
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> Int64
  -> Int64
  -> Int64
  -> CBool
  -> CDouble
  -> CBool
  -> CBool
  -> Ptr IntArray
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr (StdArray '(CBool,4))
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor,TensorList)))
_cudnn_rnn_backward_tlltttttttllllbdbbltta _input _weight _weight_stride0 _weight_buf _hx _cx _output _grad_output _grad_hy _grad_cy _mode _hidden_size _proj_size _num_layers _batch_first _dropout _train _bidirectional _batch_sizes _dropout_state _reserve _output_mask =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor,std::vector<at::Tensor>>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor,std::vector<at::Tensor>>(at::_cudnn_rnn_backward(
    *$(at::Tensor* _input)
  , *$(std::vector<at::Tensor>* _weight)
  , $(int64_t _weight_stride0)
  , *$(at::Tensor* _weight_buf)
  , *$(at::Tensor* _hx)
  , *$(at::Tensor* _cx)
  , *$(at::Tensor* _output)
  , *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _grad_hy)
  , *$(at::Tensor* _grad_cy)
  , $(int64_t _mode)
  , $(int64_t _hidden_size)
  , $(int64_t _proj_size)
  , $(int64_t _num_layers)
  , $(bool _batch_first)
  , $(double _dropout)
  , $(bool _train)
  , $(bool _bidirectional)
  , *$(std::vector<int64_t>* _batch_sizes)
  , *$(at::Tensor* _dropout_state)
  , *$(at::Tensor* _reserve)
  , *$(std::array<bool,4>* _output_mask)));
  }|]

_cudnn_init_dropout_state_dblo
  :: CDouble
  -> CBool
  -> Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
_cudnn_init_dropout_state_dblo _dropout _train _dropout_seed _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_cudnn_init_dropout_state(
    $(double _dropout)
  , $(bool _train)
  , $(int64_t _dropout_seed)
  , *$(at::TensorOptions* _options)));
  }|]

_debug_has_internal_overlap_t
  :: Ptr Tensor
  -> IO (Int64)
_debug_has_internal_overlap_t _self =
  [C.throwBlock| int64_t { return (at::_debug_has_internal_overlap(
    *$(at::Tensor* _self)));
  }|]

_fused_dropout_tdG
  :: Ptr Tensor
  -> CDouble
  -> Ptr Generator
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
_fused_dropout_tdG _self _p _generator =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::_fused_dropout(
    *$(at::Tensor* _self)
  , $(double _p)
  , *$(at::Generator* _generator)));
  }|]

_fused_dropout_td
  :: Ptr Tensor
  -> CDouble
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
_fused_dropout_td _self _p =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::_fused_dropout(
    *$(at::Tensor* _self)
  , $(double _p)));
  }|]

_masked_scale_ttd
  :: Ptr Tensor
  -> Ptr Tensor
  -> CDouble
  -> IO (Ptr Tensor)
_masked_scale_ttd _self _mask _scale =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_masked_scale(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _mask)
  , $(double _scale)));
  }|]

native_dropout_tdb
  :: Ptr Tensor
  -> CDouble
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
native_dropout_tdb _input _p _train =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::native_dropout(
    *$(at::Tensor* _input)
  , $(double _p)
  , $(bool _train)));
  }|]

native_dropout_backward_ttd
  :: Ptr Tensor
  -> Ptr Tensor
  -> CDouble
  -> IO (Ptr Tensor)
native_dropout_backward_ttd _grad_output _mask _scale =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::native_dropout_backward(
    *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _mask)
  , $(double _scale)));
  }|]

_sobol_engine_draw_tltlls
  :: Ptr Tensor
  -> Int64
  -> Ptr Tensor
  -> Int64
  -> Int64
  -> ScalarType
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
_sobol_engine_draw_tltlls _quasi _n _sobolstate _dimension _num_generated _dtype =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::_sobol_engine_draw(
    *$(at::Tensor* _quasi)
  , $(int64_t _n)
  , *$(at::Tensor* _sobolstate)
  , $(int64_t _dimension)
  , $(int64_t _num_generated)
  , $(at::ScalarType _dtype)));
  }|]

_sobol_engine_ff__tltll
  :: Ptr Tensor
  -> Int64
  -> Ptr Tensor
  -> Int64
  -> Int64
  -> IO (Ptr Tensor)
_sobol_engine_ff__tltll _self _n _sobolstate _dimension _num_generated =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sobol_engine_ff_(
    *$(at::Tensor* _self)
  , $(int64_t _n)
  , *$(at::Tensor* _sobolstate)
  , $(int64_t _dimension)
  , $(int64_t _num_generated)));
  }|]

_sobol_engine_scramble__ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
_sobol_engine_scramble__ttl _self _ltm _dimension =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sobol_engine_scramble_(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _ltm)
  , $(int64_t _dimension)));
  }|]

_sobol_engine_initialize_state__tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
_sobol_engine_initialize_state__tl _self _dimension =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sobol_engine_initialize_state_(
    *$(at::Tensor* _self)
  , $(int64_t _dimension)));
  }|]

_reshape_from_tensor_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
_reshape_from_tensor_tt _self _shape =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_reshape_from_tensor(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _shape)));
  }|]

_shape_as_tensor_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_shape_as_tensor_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_shape_as_tensor(
    *$(at::Tensor* _self)));
  }|]

dropout_tdb
  :: Ptr Tensor
  -> CDouble
  -> CBool
  -> IO (Ptr Tensor)
dropout_tdb _input _p _train =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::dropout(
    *$(at::Tensor* _input)
  , $(double _p)
  , $(bool _train)));
  }|]

dropout__tdb
  :: Ptr Tensor
  -> CDouble
  -> CBool
  -> IO (Ptr Tensor)
dropout__tdb _self _p _train =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::dropout_(
    *$(at::Tensor* _self)
  , $(double _p)
  , $(bool _train)));
  }|]

feature_dropout_tdb
  :: Ptr Tensor
  -> CDouble
  -> CBool
  -> IO (Ptr Tensor)
feature_dropout_tdb _input _p _train =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::feature_dropout(
    *$(at::Tensor* _input)
  , $(double _p)
  , $(bool _train)));
  }|]

feature_dropout__tdb
  :: Ptr Tensor
  -> CDouble
  -> CBool
  -> IO (Ptr Tensor)
feature_dropout__tdb _self _p _train =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::feature_dropout_(
    *$(at::Tensor* _self)
  , $(double _p)
  , $(bool _train)));
  }|]

alpha_dropout_tdb
  :: Ptr Tensor
  -> CDouble
  -> CBool
  -> IO (Ptr Tensor)
alpha_dropout_tdb _input _p _train =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::alpha_dropout(
    *$(at::Tensor* _input)
  , $(double _p)
  , $(bool _train)));
  }|]

alpha_dropout__tdb
  :: Ptr Tensor
  -> CDouble
  -> CBool
  -> IO (Ptr Tensor)
alpha_dropout__tdb _self _p _train =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::alpha_dropout_(
    *$(at::Tensor* _self)
  , $(double _p)
  , $(bool _train)));
  }|]

feature_alpha_dropout_tdb
  :: Ptr Tensor
  -> CDouble
  -> CBool
  -> IO (Ptr Tensor)
feature_alpha_dropout_tdb _input _p _train =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::feature_alpha_dropout(
    *$(at::Tensor* _input)
  , $(double _p)
  , $(bool _train)));
  }|]

feature_alpha_dropout__tdb
  :: Ptr Tensor
  -> CDouble
  -> CBool
  -> IO (Ptr Tensor)
feature_alpha_dropout__tdb _self _p _train =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::feature_alpha_dropout_(
    *$(at::Tensor* _self)
  , $(double _p)
  , $(bool _train)));
  }|]

abs_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
abs_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::abs(
    *$(at::Tensor* _self)));
  }|]

abs__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
abs__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::abs_(
    *$(at::Tensor* _self)));
  }|]

abs_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
abs_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::abs_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

absolute_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
absolute_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::absolute(
    *$(at::Tensor* _self)));
  }|]

absolute_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
absolute_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::absolute_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

angle_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
angle_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::angle(
    *$(at::Tensor* _self)));
  }|]

angle_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
angle_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::angle_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

view_as_real_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
view_as_real_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::view_as_real(
    *$(at::Tensor* _self)));
  }|]

view_as_complex_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
view_as_complex_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::view_as_complex(
    *$(at::Tensor* _self)));
  }|]

sgn_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
sgn_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::sgn(
    *$(at::Tensor* _self)));
  }|]

sgn_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
sgn_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::sgn_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

real_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
real_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::real(
    *$(at::Tensor* _self)));
  }|]

imag_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
imag_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::imag(
    *$(at::Tensor* _self)));
  }|]

_conj_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_conj_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_conj(
    *$(at::Tensor* _self)));
  }|]

conj_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
conj_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::conj(
    *$(at::Tensor* _self)));
  }|]

_conj_physical_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_conj_physical_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_conj_physical(
    *$(at::Tensor* _self)));
  }|]

conj_physical_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
conj_physical_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::conj_physical(
    *$(at::Tensor* _self)));
  }|]

conj_physical_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
conj_physical_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::conj_physical_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

conj_physical__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
conj_physical__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::conj_physical_(
    *$(at::Tensor* _self)));
  }|]

resolve_conj_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
resolve_conj_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::resolve_conj(
    *$(at::Tensor* _self)));
  }|]

resolve_neg_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
resolve_neg_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::resolve_neg(
    *$(at::Tensor* _self)));
  }|]

_neg_view_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_neg_view_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_neg_view(
    *$(at::Tensor* _self)));
  }|]

acos_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
acos_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::acos(
    *$(at::Tensor* _self)));
  }|]

acos__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
acos__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::acos_(
    *$(at::Tensor* _self)));
  }|]

acos_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
acos_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::acos_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

arccos_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
arccos_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arccos(
    *$(at::Tensor* _self)));
  }|]

arccos__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
arccos__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arccos_(
    *$(at::Tensor* _self)));
  }|]

arccos_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
arccos_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arccos_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

avg_pool1d_tlllbb
  :: Ptr Tensor
  -> Ptr IntArray
  -> Ptr IntArray
  -> Ptr IntArray
  -> CBool
  -> CBool
  -> IO (Ptr Tensor)
avg_pool1d_tlllbb _self _kernel_size _stride _padding _ceil_mode _count_include_pad =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::avg_pool1d(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _kernel_size)
  , *$(std::vector<int64_t>* _stride)
  , *$(std::vector<int64_t>* _padding)
  , $(bool _ceil_mode)
  , $(bool _count_include_pad)));
  }|]

avg_pool1d_tlllb
  :: Ptr Tensor
  -> Ptr IntArray
  -> Ptr IntArray
  -> Ptr IntArray
  -> CBool
  -> IO (Ptr Tensor)
avg_pool1d_tlllb _self _kernel_size _stride _padding _ceil_mode =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::avg_pool1d(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _kernel_size)
  , *$(std::vector<int64_t>* _stride)
  , *$(std::vector<int64_t>* _padding)
  , $(bool _ceil_mode)));
  }|]

avg_pool1d_tlll
  :: Ptr Tensor
  -> Ptr IntArray
  -> Ptr IntArray
  -> Ptr IntArray
  -> IO (Ptr Tensor)
avg_pool1d_tlll _self _kernel_size _stride _padding =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::avg_pool1d(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _kernel_size)
  , *$(std::vector<int64_t>* _stride)
  , *$(std::vector<int64_t>* _padding)));
  }|]

avg_pool1d_tll
  :: Ptr Tensor
  -> Ptr IntArray
  -> Ptr IntArray
  -> IO (Ptr Tensor)
avg_pool1d_tll _self _kernel_size _stride =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::avg_pool1d(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _kernel_size)
  , *$(std::vector<int64_t>* _stride)));
  }|]

avg_pool1d_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
avg_pool1d_tl _self _kernel_size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::avg_pool1d(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _kernel_size)));
  }|]

adaptive_avg_pool1d_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
adaptive_avg_pool1d_tl _self _output_size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::adaptive_avg_pool1d(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _output_size)));
  }|]

adaptive_max_pool1d_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr (StdTuple '(Tensor,Tensor)))
adaptive_max_pool1d_tl _self _output_size =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor>(at::adaptive_max_pool1d(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _output_size)));
  }|]

add_tts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
add_tts _self _other _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::add(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)
  , *$(at::Scalar* _alpha)));
  }|]

add_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
add_tt _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::add(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

add_out_ttts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
add_out_ttts _out _self _other _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::add_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _other)
  , *$(at::Scalar* _alpha)));
  }|]

add_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
add_out_ttt _out _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::add_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

_add_relu_tts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
_add_relu_tts _self _other _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_add_relu(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)
  , *$(at::Scalar* _alpha)));
  }|]

_add_relu_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
_add_relu_tt _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_add_relu(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

_add_relu__tts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
_add_relu__tts _self _other _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_add_relu_(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)
  , *$(at::Scalar* _alpha)));
  }|]

_add_relu__tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
_add_relu__tt _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_add_relu_(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

_add_relu_out_ttts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
_add_relu_out_ttts _out _self _other _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_add_relu_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _other)
  , *$(at::Scalar* _alpha)));
  }|]

_add_relu_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
_add_relu_out_ttt _out _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_add_relu_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

_add_relu_tss
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
_add_relu_tss _self _other _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_add_relu(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _other)
  , *$(at::Scalar* _alpha)));
  }|]

_add_relu_ts
  :: Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
_add_relu_ts _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_add_relu(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _other)));
  }|]

_add_relu__tss
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
_add_relu__tss _self _other _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_add_relu_(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _other)
  , *$(at::Scalar* _alpha)));
  }|]

_add_relu__ts
  :: Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
_add_relu__ts _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_add_relu_(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _other)));
  }|]

add_tss
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
add_tss _self _other _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::add(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _other)
  , *$(at::Scalar* _alpha)));
  }|]

add_ts
  :: Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
add_ts _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::add(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _other)));
  }|]

addmv_tttss
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
addmv_tttss _self _mat _vec _beta _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::addmv(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _mat)
  , *$(at::Tensor* _vec)
  , *$(at::Scalar* _beta)
  , *$(at::Scalar* _alpha)));
  }|]

addmv_ttts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
addmv_ttts _self _mat _vec _beta =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::addmv(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _mat)
  , *$(at::Tensor* _vec)
  , *$(at::Scalar* _beta)));
  }|]

addmv_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
addmv_ttt _self _mat _vec =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::addmv(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _mat)
  , *$(at::Tensor* _vec)));
  }|]

addmv__tttss
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
addmv__tttss _self _mat _vec _beta _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::addmv_(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _mat)
  , *$(at::Tensor* _vec)
  , *$(at::Scalar* _beta)
  , *$(at::Scalar* _alpha)));
  }|]

addmv__ttts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
addmv__ttts _self _mat _vec _beta =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::addmv_(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _mat)
  , *$(at::Tensor* _vec)
  , *$(at::Scalar* _beta)));
  }|]

addmv__ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
addmv__ttt _self _mat _vec =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::addmv_(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _mat)
  , *$(at::Tensor* _vec)));
  }|]

addmv_out_ttttss
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
addmv_out_ttttss _out _self _mat _vec _beta _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::addmv_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _mat)
  , *$(at::Tensor* _vec)
  , *$(at::Scalar* _beta)
  , *$(at::Scalar* _alpha)));
  }|]

addmv_out_tttts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
addmv_out_tttts _out _self _mat _vec _beta =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::addmv_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _mat)
  , *$(at::Tensor* _vec)
  , *$(at::Scalar* _beta)));
  }|]

addmv_out_tttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
addmv_out_tttt _out _self _mat _vec =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::addmv_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _mat)
  , *$(at::Tensor* _vec)));
  }|]

addr_tttss
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
addr_tttss _self _vec1 _vec2 _beta _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::addr(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _vec1)
  , *$(at::Tensor* _vec2)
  , *$(at::Scalar* _beta)
  , *$(at::Scalar* _alpha)));
  }|]

addr_ttts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
addr_ttts _self _vec1 _vec2 _beta =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::addr(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _vec1)
  , *$(at::Tensor* _vec2)
  , *$(at::Scalar* _beta)));
  }|]

addr_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
addr_ttt _self _vec1 _vec2 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::addr(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _vec1)
  , *$(at::Tensor* _vec2)));
  }|]

addr_out_ttttss
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
addr_out_ttttss _out _self _vec1 _vec2 _beta _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::addr_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _vec1)
  , *$(at::Tensor* _vec2)
  , *$(at::Scalar* _beta)
  , *$(at::Scalar* _alpha)));
  }|]

addr_out_tttts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
addr_out_tttts _out _self _vec1 _vec2 _beta =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::addr_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _vec1)
  , *$(at::Tensor* _vec2)
  , *$(at::Scalar* _beta)));
  }|]

addr_out_tttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
addr_out_tttt _out _self _vec1 _vec2 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::addr_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _vec1)
  , *$(at::Tensor* _vec2)));
  }|]

affine_grid_generator_tlb
  :: Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> IO (Ptr Tensor)
affine_grid_generator_tlb _theta _size _align_corners =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::affine_grid_generator(
    *$(at::Tensor* _theta)
  , *$(std::vector<int64_t>* _size)
  , $(bool _align_corners)));
  }|]

affine_grid_generator_backward_tlb
  :: Ptr Tensor
  -> Ptr IntArray
  -> CBool
  -> IO (Ptr Tensor)
affine_grid_generator_backward_tlb _grad _size _align_corners =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::affine_grid_generator_backward(
    *$(at::Tensor* _grad)
  , *$(std::vector<int64_t>* _size)
  , $(bool _align_corners)));
  }|]

_is_all_true_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_is_all_true_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_is_all_true(
    *$(at::Tensor* _self)));
  }|]

_is_any_true_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_is_any_true_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_is_any_true(
    *$(at::Tensor* _self)));
  }|]

_test_check_tensor_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
_test_check_tensor_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_test_check_tensor(
    *$(at::Tensor* _self)));
  }|]

all_tlb
  :: Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
all_tlb _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::all(
    *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _keepdim)));
  }|]

all_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
all_tl _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::all(
    *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

all_out_ttlb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
all_out_ttlb _out _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::all_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _keepdim)));
  }|]

all_out_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
all_out_ttl _out _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::all_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

all_tnb
  :: Ptr Tensor
  -> Ptr Dimname
  -> CBool
  -> IO (Ptr Tensor)
all_tnb _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::all(
    *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)
  , $(bool _keepdim)));
  }|]

all_tn
  :: Ptr Tensor
  -> Ptr Dimname
  -> IO (Ptr Tensor)
all_tn _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::all(
    *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)));
  }|]

all_out_ttnb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Dimname
  -> CBool
  -> IO (Ptr Tensor)
all_out_ttnb _out _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::all_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)
  , $(bool _keepdim)));
  }|]

all_out_ttn
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Dimname
  -> IO (Ptr Tensor)
all_out_ttn _out _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::all_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)));
  }|]

allclose_ttddb
  :: Ptr Tensor
  -> Ptr Tensor
  -> CDouble
  -> CDouble
  -> CBool
  -> IO (CBool)
allclose_ttddb _self _other _rtol _atol _equal_nan =
  [C.throwBlock| bool { return (at::allclose(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)
  , $(double _rtol)
  , $(double _atol)
  , $(bool _equal_nan)));
  }|]

allclose_ttdd
  :: Ptr Tensor
  -> Ptr Tensor
  -> CDouble
  -> CDouble
  -> IO (CBool)
allclose_ttdd _self _other _rtol _atol =
  [C.throwBlock| bool { return (at::allclose(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)
  , $(double _rtol)
  , $(double _atol)));
  }|]

allclose_ttd
  :: Ptr Tensor
  -> Ptr Tensor
  -> CDouble
  -> IO (CBool)
allclose_ttd _self _other _rtol =
  [C.throwBlock| bool { return (at::allclose(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)
  , $(double _rtol)));
  }|]

allclose_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (CBool)
allclose_tt _self _other =
  [C.throwBlock| bool { return (at::allclose(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

any_tlb
  :: Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
any_tlb _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::any(
    *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _keepdim)));
  }|]

any_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
any_tl _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::any(
    *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

any_out_ttlb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
any_out_ttlb _out _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::any_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _keepdim)));
  }|]

any_out_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
any_out_ttl _out _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::any_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

any_tnb
  :: Ptr Tensor
  -> Ptr Dimname
  -> CBool
  -> IO (Ptr Tensor)
any_tnb _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::any(
    *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)
  , $(bool _keepdim)));
  }|]

any_tn
  :: Ptr Tensor
  -> Ptr Dimname
  -> IO (Ptr Tensor)
any_tn _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::any(
    *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)));
  }|]

any_out_ttnb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Dimname
  -> CBool
  -> IO (Ptr Tensor)
any_out_ttnb _out _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::any_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)
  , $(bool _keepdim)));
  }|]

any_out_ttn
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Dimname
  -> IO (Ptr Tensor)
any_out_ttn _out _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::any_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Dimname* _dim)));
  }|]

arange_so
  :: Ptr Scalar
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
arange_so _end _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arange(
    *$(at::Scalar* _end)
  , *$(at::TensorOptions* _options)));
  }|]

arange_s
  :: Ptr Scalar
  -> IO (Ptr Tensor)
arange_s _end =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arange(
    *$(at::Scalar* _end)));
  }|]

arange_sso
  :: Ptr Scalar
  -> Ptr Scalar
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
arange_sso _start _end _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arange(
    *$(at::Scalar* _start)
  , *$(at::Scalar* _end)
  , *$(at::TensorOptions* _options)));
  }|]

arange_ss
  :: Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
arange_ss _start _end =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arange(
    *$(at::Scalar* _start)
  , *$(at::Scalar* _end)));
  }|]

arange_ssso
  :: Ptr Scalar
  -> Ptr Scalar
  -> Ptr Scalar
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
arange_ssso _start _end _step _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arange(
    *$(at::Scalar* _start)
  , *$(at::Scalar* _end)
  , *$(at::Scalar* _step)
  , *$(at::TensorOptions* _options)));
  }|]

arange_sss
  :: Ptr Scalar
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
arange_sss _start _end _step =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arange(
    *$(at::Scalar* _start)
  , *$(at::Scalar* _end)
  , *$(at::Scalar* _step)));
  }|]

arange_out_ts
  :: Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
arange_out_ts _out _end =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arange_out(
    *$(at::Tensor* _out)
  , *$(at::Scalar* _end)));
  }|]

arange_out_tsss
  :: Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
arange_out_tsss _out _start _end _step =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arange_out(
    *$(at::Tensor* _out)
  , *$(at::Scalar* _start)
  , *$(at::Scalar* _end)
  , *$(at::Scalar* _step)));
  }|]

-- arange_out_tss
--   :: Ptr Tensor
--   -> Ptr Scalar
--   -> Ptr Scalar
--   -> IO (Ptr Tensor)
-- arange_out_tss _out _start _end =
--   [C.throwBlock| at::Tensor* { return new at::Tensor(at::arange_out(
--     *$(at::Tensor* _out)
--   , *$(at::Scalar* _start)
--   , *$(at::Scalar* _end)));
--   }|]

_dim_arange_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
_dim_arange_tl _like _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_dim_arange(
    *$(at::Tensor* _like)
  , $(int64_t _dim)));
  }|]

argmax_tlb
  :: Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
argmax_tlb _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argmax(
    *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _keepdim)));
  }|]

argmax_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
argmax_tl _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argmax(
    *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

argmax_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
argmax_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argmax(
    *$(at::Tensor* _self)));
  }|]

argmax_out_ttlb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
argmax_out_ttlb _out _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argmax_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _keepdim)));
  }|]

argmax_out_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
argmax_out_ttl _out _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argmax_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

argmax_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
argmax_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argmax_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

argmin_tlb
  :: Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
argmin_tlb _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argmin(
    *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _keepdim)));
  }|]

argmin_tl
  :: Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
argmin_tl _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argmin(
    *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

argmin_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
argmin_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argmin(
    *$(at::Tensor* _self)));
  }|]

argmin_out_ttlb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> CBool
  -> IO (Ptr Tensor)
argmin_out_ttlb _out _self _dim _keepdim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argmin_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , $(int64_t _dim)
  , $(bool _keepdim)));
  }|]

argmin_out_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
argmin_out_ttl _out _self _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argmin_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , $(int64_t _dim)));
  }|]

argmin_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
argmin_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::argmin_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

acosh_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
acosh_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::acosh(
    *$(at::Tensor* _self)));
  }|]

acosh__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
acosh__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::acosh_(
    *$(at::Tensor* _self)));
  }|]

acosh_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
acosh_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::acosh_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

arccosh_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
arccosh_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arccosh(
    *$(at::Tensor* _self)));
  }|]

arccosh__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
arccosh__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arccosh_(
    *$(at::Tensor* _self)));
  }|]

arccosh_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
arccosh_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arccosh_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

asinh_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
asinh_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::asinh(
    *$(at::Tensor* _self)));
  }|]

asinh__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
asinh__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::asinh_(
    *$(at::Tensor* _self)));
  }|]

asinh_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
asinh_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::asinh_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

arcsinh_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
arcsinh_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arcsinh(
    *$(at::Tensor* _self)));
  }|]

arcsinh__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
arcsinh__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arcsinh_(
    *$(at::Tensor* _self)));
  }|]

arcsinh_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
arcsinh_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arcsinh_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

atanh_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
atanh_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::atanh(
    *$(at::Tensor* _self)));
  }|]

atanh__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
atanh__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::atanh_(
    *$(at::Tensor* _self)));
  }|]

atanh_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
atanh_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::atanh_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

arctanh_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
arctanh_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arctanh(
    *$(at::Tensor* _self)));
  }|]

arctanh__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
arctanh__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arctanh_(
    *$(at::Tensor* _self)));
  }|]

arctanh_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
arctanh_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arctanh_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

as_strided_tlll
  :: Ptr Tensor
  -> Ptr IntArray
  -> Ptr IntArray
  -> Int64
  -> IO (Ptr Tensor)
as_strided_tlll _self _size _stride _storage_offset =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::as_strided(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _size)
  , *$(std::vector<int64_t>* _stride)
  , $(int64_t _storage_offset)));
  }|]

as_strided_tll
  :: Ptr Tensor
  -> Ptr IntArray
  -> Ptr IntArray
  -> IO (Ptr Tensor)
as_strided_tll _self _size _stride =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::as_strided(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _size)
  , *$(std::vector<int64_t>* _stride)));
  }|]

as_strided__tlll
  :: Ptr Tensor
  -> Ptr IntArray
  -> Ptr IntArray
  -> Int64
  -> IO (Ptr Tensor)
as_strided__tlll _self _size _stride _storage_offset =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::as_strided_(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _size)
  , *$(std::vector<int64_t>* _stride)
  , $(int64_t _storage_offset)));
  }|]

as_strided__tll
  :: Ptr Tensor
  -> Ptr IntArray
  -> Ptr IntArray
  -> IO (Ptr Tensor)
as_strided__tll _self _size _stride =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::as_strided_(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _size)
  , *$(std::vector<int64_t>* _stride)));
  }|]

asin_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
asin_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::asin(
    *$(at::Tensor* _self)));
  }|]

asin__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
asin__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::asin_(
    *$(at::Tensor* _self)));
  }|]

asin_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
asin_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::asin_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

arcsin_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
arcsin_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arcsin(
    *$(at::Tensor* _self)));
  }|]

arcsin__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
arcsin__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arcsin_(
    *$(at::Tensor* _self)));
  }|]

arcsin_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
arcsin_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arcsin_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

atan_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
atan_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::atan(
    *$(at::Tensor* _self)));
  }|]

atan__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
atan__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::atan_(
    *$(at::Tensor* _self)));
  }|]

atan_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
atan_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::atan_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

arctan_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
arctan_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arctan(
    *$(at::Tensor* _self)));
  }|]

arctan__t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
arctan__t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arctan_(
    *$(at::Tensor* _self)));
  }|]

arctan_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
arctan_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::arctan_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

atleast_1d_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
atleast_1d_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::atleast_1d(
    *$(at::Tensor* _self)));
  }|]

atleast_1d_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
atleast_1d_l _tensors =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::atleast_1d(
    *$(std::vector<at::Tensor>* _tensors)));
  }|]

atleast_2d_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
atleast_2d_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::atleast_2d(
    *$(at::Tensor* _self)));
  }|]

atleast_2d_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
atleast_2d_l _tensors =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::atleast_2d(
    *$(std::vector<at::Tensor>* _tensors)));
  }|]

atleast_3d_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
atleast_3d_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::atleast_3d(
    *$(at::Tensor* _self)));
  }|]

atleast_3d_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
atleast_3d_l _tensors =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::atleast_3d(
    *$(std::vector<at::Tensor>* _tensors)));
  }|]

baddbmm_tttss
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
baddbmm_tttss _self _batch1 _batch2 _beta _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::baddbmm(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _batch1)
  , *$(at::Tensor* _batch2)
  , *$(at::Scalar* _beta)
  , *$(at::Scalar* _alpha)));
  }|]

baddbmm_ttts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
baddbmm_ttts _self _batch1 _batch2 _beta =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::baddbmm(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _batch1)
  , *$(at::Tensor* _batch2)
  , *$(at::Scalar* _beta)));
  }|]

baddbmm_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
baddbmm_ttt _self _batch1 _batch2 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::baddbmm(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _batch1)
  , *$(at::Tensor* _batch2)));
  }|]

baddbmm_out_ttttss
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> Ptr Scalar
  -> IO (Ptr Tensor)
baddbmm_out_ttttss _out _self _batch1 _batch2 _beta _alpha =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::baddbmm_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _batch1)
  , *$(at::Tensor* _batch2)
  , *$(at::Scalar* _beta)
  , *$(at::Scalar* _alpha)));
  }|]

baddbmm_out_tttts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
baddbmm_out_tttts _out _self _batch1 _batch2 _beta =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::baddbmm_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _batch1)
  , *$(at::Tensor* _batch2)
  , *$(at::Scalar* _beta)));
  }|]

baddbmm_out_tttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
baddbmm_out_tttt _out _self _batch1 _batch2 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::baddbmm_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _batch1)
  , *$(at::Tensor* _batch2)));
  }|]

bartlett_window_lo
  :: Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
bartlett_window_lo _window_length _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bartlett_window(
    $(int64_t _window_length)
  , *$(at::TensorOptions* _options)));
  }|]

bartlett_window_l
  :: Int64
  -> IO (Ptr Tensor)
bartlett_window_l _window_length =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bartlett_window(
    $(int64_t _window_length)));
  }|]

bartlett_window_lbo
  :: Int64
  -> CBool
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
bartlett_window_lbo _window_length _periodic _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bartlett_window(
    $(int64_t _window_length)
  , $(bool _periodic)
  , *$(at::TensorOptions* _options)));
  }|]

bartlett_window_lb
  :: Int64
  -> CBool
  -> IO (Ptr Tensor)
bartlett_window_lb _window_length _periodic =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bartlett_window(
    $(int64_t _window_length)
  , $(bool _periodic)));
  }|]

batch_norm_tttttbddb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> CDouble
  -> CDouble
  -> CBool
  -> IO (Ptr Tensor)
batch_norm_tttttbddb _input _weight _bias _running_mean _running_var _training _momentum _eps _cudnn_enabled =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::batch_norm(
    *$(at::Tensor* _input)
  , *$(at::Tensor* _weight)
  , *$(at::Tensor* _bias)
  , *$(at::Tensor* _running_mean)
  , *$(at::Tensor* _running_var)
  , $(bool _training)
  , $(double _momentum)
  , $(double _eps)
  , $(bool _cudnn_enabled)));
  }|]

quantized_batch_norm_tttttddl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CDouble
  -> CDouble
  -> Int64
  -> IO (Ptr Tensor)
quantized_batch_norm_tttttddl _input _weight _bias _mean _var _eps _output_scale _output_zero_point =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::quantized_batch_norm(
    *$(at::Tensor* _input)
  , *$(at::Tensor* _weight)
  , *$(at::Tensor* _bias)
  , *$(at::Tensor* _mean)
  , *$(at::Tensor* _var)
  , $(double _eps)
  , $(double _output_scale)
  , $(int64_t _output_zero_point)));
  }|]

_batch_norm_impl_index_tttttbddb
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> CDouble
  -> CDouble
  -> CBool
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor,Tensor,Int64)))
_batch_norm_impl_index_tttttbddb _input _weight _bias _running_mean _running_var _training _momentum _eps _cudnn_enabled =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor,int64_t>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor,int64_t>(at::_batch_norm_impl_index(
    *$(at::Tensor* _input)
  , *$(at::Tensor* _weight)
  , *$(at::Tensor* _bias)
  , *$(at::Tensor* _running_mean)
  , *$(at::Tensor* _running_var)
  , $(bool _training)
  , $(double _momentum)
  , $(double _eps)
  , $(bool _cudnn_enabled)));
  }|]

_batch_norm_impl_index_backward_ltttttttbdat
  :: Int64
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> CBool
  -> CDouble
  -> Ptr (StdArray '(CBool,3))
  -> Ptr Tensor
  -> IO (Ptr (StdTuple '(Tensor,Tensor,Tensor)))
_batch_norm_impl_index_backward_ltttttttbdat _impl_index _input _grad_output _weight _running_mean _running_var _save_mean _save_var_transform _train _eps _output_mask _reservedSpace =
  [C.throwBlock| std::tuple<at::Tensor,at::Tensor,at::Tensor>* { return new std::tuple<at::Tensor,at::Tensor,at::Tensor>(at::_batch_norm_impl_index_backward(
    $(int64_t _impl_index)
  , *$(at::Tensor* _input)
  , *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _weight)
  , *$(at::Tensor* _running_mean)
  , *$(at::Tensor* _running_var)
  , *$(at::Tensor* _save_mean)
  , *$(at::Tensor* _save_var_transform)
  , $(bool _train)
  , $(double _eps)
  , *$(std::array<bool,3>* _output_mask)
  , *$(at::Tensor* _reservedSpace)));
  }|]

bernoulli_tG
  :: Ptr Tensor
  -> Ptr Generator
  -> IO (Ptr Tensor)
bernoulli_tG _self _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bernoulli(
    *$(at::Tensor* _self)
  , *$(at::Generator* _generator)));
  }|]

bernoulli_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
bernoulli_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bernoulli(
    *$(at::Tensor* _self)));
  }|]

bernoulli_out_ttG
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Generator
  -> IO (Ptr Tensor)
bernoulli_out_ttG _out _self _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bernoulli_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Generator* _generator)));
  }|]

-- bernoulli_out_tt
--   :: Ptr Tensor
--   -> Ptr Tensor
--   -> IO (Ptr Tensor)
-- bernoulli_out_tt _out _self =
--   [C.throwBlock| at::Tensor* { return new at::Tensor(at::bernoulli_out(
--     *$(at::Tensor* _out)
--   , *$(at::Tensor* _self)));
--   }|]

bernoulli_tdG
  :: Ptr Tensor
  -> CDouble
  -> Ptr Generator
  -> IO (Ptr Tensor)
bernoulli_tdG _self _p _generator =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bernoulli(
    *$(at::Tensor* _self)
  , $(double _p)
  , *$(at::Generator* _generator)));
  }|]

bernoulli_td
  :: Ptr Tensor
  -> CDouble
  -> IO (Ptr Tensor)
bernoulli_td _self _p =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bernoulli(
    *$(at::Tensor* _self)
  , $(double _p)));
  }|]

bilinear_tttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
bilinear_tttt _input1 _input2 _weight _bias =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bilinear(
    *$(at::Tensor* _input1)
  , *$(at::Tensor* _input2)
  , *$(at::Tensor* _weight)
  , *$(at::Tensor* _bias)));
  }|]

bilinear_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
bilinear_ttt _input1 _input2 _weight =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bilinear(
    *$(at::Tensor* _input1)
  , *$(at::Tensor* _input2)
  , *$(at::Tensor* _weight)));
  }|]

binary_cross_entropy_tttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
binary_cross_entropy_tttl _self _target _weight _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binary_cross_entropy(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Tensor* _weight)
  , $(int64_t _reduction)));
  }|]

binary_cross_entropy_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
binary_cross_entropy_ttt _self _target _weight =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binary_cross_entropy(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Tensor* _weight)));
  }|]

binary_cross_entropy_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
binary_cross_entropy_tt _self _target =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binary_cross_entropy(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)));
  }|]

binary_cross_entropy_out_ttttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
binary_cross_entropy_out_ttttl _out _self _target _weight _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binary_cross_entropy_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Tensor* _weight)
  , $(int64_t _reduction)));
  }|]

binary_cross_entropy_out_tttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
binary_cross_entropy_out_tttt _out _self _target _weight =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binary_cross_entropy_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Tensor* _weight)));
  }|]

binary_cross_entropy_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
binary_cross_entropy_out_ttt _out _self _target =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binary_cross_entropy_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)));
  }|]

binary_cross_entropy_backward_ttttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
binary_cross_entropy_backward_ttttl _grad_output _self _target _weight _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binary_cross_entropy_backward(
    *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Tensor* _weight)
  , $(int64_t _reduction)));
  }|]

binary_cross_entropy_backward_tttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
binary_cross_entropy_backward_tttt _grad_output _self _target _weight =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binary_cross_entropy_backward(
    *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Tensor* _weight)));
  }|]

binary_cross_entropy_backward_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
binary_cross_entropy_backward_ttt _grad_output _self _target =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binary_cross_entropy_backward(
    *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)));
  }|]

binary_cross_entropy_backward_out_tttttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
binary_cross_entropy_backward_out_tttttl _grad_input _grad_output _self _target _weight _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binary_cross_entropy_backward_out(
    *$(at::Tensor* _grad_input)
  , *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Tensor* _weight)
  , $(int64_t _reduction)));
  }|]

binary_cross_entropy_backward_out_ttttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
binary_cross_entropy_backward_out_ttttt _grad_input _grad_output _self _target _weight =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binary_cross_entropy_backward_out(
    *$(at::Tensor* _grad_input)
  , *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Tensor* _weight)));
  }|]

binary_cross_entropy_backward_out_tttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
binary_cross_entropy_backward_out_tttt _grad_input _grad_output _self _target =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binary_cross_entropy_backward_out(
    *$(at::Tensor* _grad_input)
  , *$(at::Tensor* _grad_output)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _target)));
  }|]

binary_cross_entropy_with_logits_ttttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
binary_cross_entropy_with_logits_ttttl _self _target _weight _pos_weight _reduction =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binary_cross_entropy_with_logits(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Tensor* _weight)
  , *$(at::Tensor* _pos_weight)
  , $(int64_t _reduction)));
  }|]

binary_cross_entropy_with_logits_tttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
binary_cross_entropy_with_logits_tttt _self _target _weight _pos_weight =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binary_cross_entropy_with_logits(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Tensor* _weight)
  , *$(at::Tensor* _pos_weight)));
  }|]

binary_cross_entropy_with_logits_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
binary_cross_entropy_with_logits_ttt _self _target _weight =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binary_cross_entropy_with_logits(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)
  , *$(at::Tensor* _weight)));
  }|]

binary_cross_entropy_with_logits_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
binary_cross_entropy_with_logits_tt _self _target =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::binary_cross_entropy_with_logits(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _target)));
  }|]

bincount_ttl
  :: Ptr Tensor
  -> Ptr Tensor
  -> Int64
  -> IO (Ptr Tensor)
bincount_ttl _self _weights _minlength =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bincount(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _weights)
  , $(int64_t _minlength)));
  }|]

bincount_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
bincount_tt _self _weights =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bincount(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _weights)));
  }|]

bincount_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
bincount_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bincount(
    *$(at::Tensor* _self)));
  }|]

bitwise_not_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
bitwise_not_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bitwise_not(
    *$(at::Tensor* _self)));
  }|]

bitwise_not_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
bitwise_not_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bitwise_not_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

copysign_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
copysign_out_ttt _out _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::copysign_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

copysign_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
copysign_tt _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::copysign(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

copysign_ts
  :: Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
copysign_ts _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::copysign(
    *$(at::Tensor* _self)
  , *$(at::Scalar* _other)));
  }|]

copysign_out_tts
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Scalar
  -> IO (Ptr Tensor)
copysign_out_tts _out _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::copysign_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Scalar* _other)));
  }|]

logical_not_t
  :: Ptr Tensor
  -> IO (Ptr Tensor)
logical_not_t _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::logical_not(
    *$(at::Tensor* _self)));
  }|]

logical_not_out_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
logical_not_out_tt _out _self =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::logical_not_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)));
  }|]

logical_xor_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
logical_xor_tt _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::logical_xor(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

logical_xor_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
logical_xor_out_ttt _out _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::logical_xor_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

logical_and_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
logical_and_tt _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::logical_and(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

logical_and_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
logical_and_out_ttt _out _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::logical_and_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

logical_or_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
logical_or_tt _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::logical_or(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

logical_or_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
logical_or_out_ttt _out _self _other =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::logical_or_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _other)));
  }|]

blackman_window_lo
  :: Int64
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
blackman_window_lo _window_length _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::blackman_window(
    $(int64_t _window_length)
  , *$(at::TensorOptions* _options)));
  }|]

blackman_window_l
  :: Int64
  -> IO (Ptr Tensor)
blackman_window_l _window_length =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::blackman_window(
    $(int64_t _window_length)));
  }|]

blackman_window_lbo
  :: Int64
  -> CBool
  -> Ptr TensorOptions
  -> IO (Ptr Tensor)
blackman_window_lbo _window_length _periodic _options =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::blackman_window(
    $(int64_t _window_length)
  , $(bool _periodic)
  , *$(at::TensorOptions* _options)));
  }|]

blackman_window_lb
  :: Int64
  -> CBool
  -> IO (Ptr Tensor)
blackman_window_lb _window_length _periodic =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::blackman_window(
    $(int64_t _window_length)
  , $(bool _periodic)));
  }|]

bmm_tt
  :: Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
bmm_tt _self _mat2 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bmm(
    *$(at::Tensor* _self)
  , *$(at::Tensor* _mat2)));
  }|]

bmm_out_ttt
  :: Ptr Tensor
  -> Ptr Tensor
  -> Ptr Tensor
  -> IO (Ptr Tensor)
bmm_out_ttt _out _self _mat2 =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::bmm_out(
    *$(at::Tensor* _out)
  , *$(at::Tensor* _self)
  , *$(at::Tensor* _mat2)));
  }|]

broadcast_tensors_l
  :: Ptr TensorList
  -> IO (Ptr TensorList)
broadcast_tensors_l _tensors =
  [C.throwBlock| std::vector<at::Tensor>* { return new std::vector<at::Tensor>(at::broadcast_tensors(
    *$(std::vector<at::Tensor>* _tensors)));
  }|]

broadcast_to_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
broadcast_to_tl _self _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::broadcast_to(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _size)));
  }|]

_sparse_broadcast_to_tl
  :: Ptr Tensor
  -> Ptr IntArray
  -> IO (Ptr Tensor)
_sparse_broadcast_to_tl _self _size =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::_sparse_broadcast_to(
    *$(at::Tensor* _self)
  , *$(std::vector<int64_t>* _size)));
  }|]

cat_ll
  :: Ptr TensorList
  -> Int64
  -> IO (Ptr Tensor)
cat_ll _tensors _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::cat(
    *$(std::vector<at::Tensor>* _tensors)
  , $(int64_t _dim)));
  }|]

cat_l
  :: Ptr TensorList
  -> IO (Ptr Tensor)
cat_l _tensors =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::cat(
    *$(std::vector<at::Tensor>* _tensors)));
  }|]

cat_out_tll
  :: Ptr Tensor
  -> Ptr TensorList
  -> Int64
  -> IO (Ptr Tensor)
cat_out_tll _out _tensors _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::cat_out(
    *$(at::Tensor* _out)
  , *$(std::vector<at::Tensor>* _tensors)
  , $(int64_t _dim)));
  }|]

cat_out_tl
  :: Ptr Tensor
  -> Ptr TensorList
  -> IO (Ptr Tensor)
cat_out_tl _out _tensors =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::cat_out(
    *$(at::Tensor* _out)
  , *$(std::vector<at::Tensor>* _tensors)));
  }|]

cat_ln
  :: Ptr TensorList
  -> Ptr Dimname
  -> IO (Ptr Tensor)
cat_ln _tensors _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::cat(
    *$(std::vector<at::Tensor>* _tensors)
  , *$(at::Dimname* _dim)));
  }|]

cat_out_tln
  :: Ptr Tensor
  -> Ptr TensorList
  -> Ptr Dimname
  -> IO (Ptr Tensor)
cat_out_tln _out _tensors _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::cat_out(
    *$(at::Tensor* _out)
  , *$(std::vector<at::Tensor>* _tensors)
  , *$(at::Dimname* _dim)));
  }|]

concat_ll
  :: Ptr TensorList
  -> Int64
  -> IO (Ptr Tensor)
concat_ll _tensors _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::concat(
    *$(std::vector<at::Tensor>* _tensors)
  , $(int64_t _dim)));
  }|]

concat_l
  :: Ptr TensorList
  -> IO (Ptr Tensor)
concat_l _tensors =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::concat(
    *$(std::vector<at::Tensor>* _tensors)));
  }|]

concat_out_tll
  :: Ptr Tensor
  -> Ptr TensorList
  -> Int64
  -> IO (Ptr Tensor)
concat_out_tll _out _tensors _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::concat_out(
    *$(at::Tensor* _out)
  , *$(std::vector<at::Tensor>* _tensors)
  , $(int64_t _dim)));
  }|]

concat_out_tl
  :: Ptr Tensor
  -> Ptr TensorList
  -> IO (Ptr Tensor)
concat_out_tl _out _tensors =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::concat_out(
    *$(at::Tensor* _out)
  , *$(std::vector<at::Tensor>* _tensors)));
  }|]

concat_ln
  :: Ptr TensorList
  -> Ptr Dimname
  -> IO (Ptr Tensor)
concat_ln _tensors _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::concat(
    *$(std::vector<at::Tensor>* _tensors)
  , *$(at::Dimname* _dim)));
  }|]

concat_out_tln
  :: Ptr Tensor
  -> Ptr TensorList
  -> Ptr Dimname
  -> IO (Ptr Tensor)
concat_out_tln _out _tensors _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::concat_out(
    *$(at::Tensor* _out)
  , *$(std::vector<at::Tensor>* _tensors)
  , *$(at::Dimname* _dim)));
  }|]

concatenate_ll
  :: Ptr TensorList
  -> Int64
  -> IO (Ptr Tensor)
concatenate_ll _tensors _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::concatenate(
    *$(std::vector<at::Tensor>* _tensors)
  , $(int64_t _dim)));
  }|]

concatenate_l
  :: Ptr TensorList
  -> IO (Ptr Tensor)
concatenate_l _tensors =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::concatenate(
    *$(std::vector<at::Tensor>* _tensors)));
  }|]

concatenate_out_tll
  :: Ptr Tensor
  -> Ptr TensorList
  -> Int64
  -> IO (Ptr Tensor)
concatenate_out_tll _out _tensors _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::concatenate_out(
    *$(at::Tensor* _out)
  , *$(std::vector<at::Tensor>* _tensors)
  , $(int64_t _dim)));
  }|]

concatenate_out_tl
  :: Ptr Tensor
  -> Ptr TensorList
  -> IO (Ptr Tensor)
concatenate_out_tl _out _tensors =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::concatenate_out(
    *$(at::Tensor* _out)
  , *$(std::vector<at::Tensor>* _tensors)));
  }|]

concatenate_ln
  :: Ptr TensorList
  -> Ptr Dimname
  -> IO (Ptr Tensor)
concatenate_ln _tensors _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::concatenate(
    *$(std::vector<at::Tensor>* _tensors)
  , *$(at::Dimname* _dim)));
  }|]

concatenate_out_tln
  :: Ptr Tensor
  -> Ptr TensorList
  -> Ptr Dimname
  -> IO (Ptr Tensor)
concatenate_out_tln _out _tensors _dim =
  [C.throwBlock| at::Tensor* { return new at::Tensor(at::concatenate_out(
    *$(at::Tensor* _out)
  , *$(std::vector<at::Tensor>* _tensors)
  , *$(at::Dimname* _dim)));
  }|]

