# lima

Convert between

- `Haskell` (`.hs`) files with `GitHub`-flavoured `Markdown` comments and `Markdown` (`.md`)
- `Literate Haskell` (`.lhs`) files and `GitHub`-flavoured `Markdown` (`.md`).

It is possible to make conversion abide the [roundtrip property](https://jesper.sikanda.be/posts/quickcheck-intro.html). In other words, make conversions `file.lhs` -> `file.lhs.md` -> `file.lhs.md.lhs` or `file.hs` -> `file.hs.md` -> `file.hs.md.hs` and get `file.lhs = file.lhs.md.lhs` and `file.hs = file.hs.md.hs` in terms of their contents.

## Alternatives

- [LiterateMarkdown](https://github.com/haskie-lambda/LiterateMarkdown). `lima` is a fork of this (abandoned?) project. Initially, I just wanted to fix some bugs, but then realized that I can't conveniently use `Haskell Language Server` with `.lhs` files so I added the `.hs` -> `.md` conversion.

- [IHaskell](https://github.com/IHaskell/IHaskell) - create `Jupyter` notebooks with `Haskell` code cells and `GitHub`-flavoured `Markdown` text cells and do much more!

## Conversion

### file.hs -> file.hs.md

[Examples](./testdata/hs)

Rules for `.hs` -> `.md` conversion:

- To produce text blocks, write multiline comments in `GitHub`-flavoured `Markdown`
- Such comments should start with `{- ` or `{-\n`
- Multiline comments (even `{- -}`) split `Haskell` code into snippets
- Special comments like `{- FOURMOLU_ENABLE -}` won't appear in a `.md`. You can supply other comments in a config (`hs-md.special-comments`). See the sample [config](./testdata/config/).
- You can ignore parts of a `.hs` file by enclosing them into `{- LIMA_DISABLE -}` and `{- LIMA_ENABLE -}`. The lines between such comments will be commented out in the resulting `.md`.

### file.lhs -> file.lhs.md -> file.lhs.md.lhs

Examples:

- [input0.lhs](./testdata/input0.lhs) -> [input0.lhs.md](./testdata/input0.lhs.md)
- [input1.lhs](./testdata/input1.lhs) -> [input1.lhs.md](./testdata/input1.lhs.md)

As `.lhs` doesn't support `#` (heading) or `>` (quotation start) at a line beginning, one should write ` #` and ` >` instead.

- ` #` -> `#` -> ` #`
- ` >` -> `>` -> ` >`

If you'd like to provide some code in a `.lhs`, follow these rules:

- `>` is for `Haskell` code, there should be an empty line before and after the block with `Haskell` code
- `<` is for any other code. Such code will be converted into code blocks of type `console` in `.md`
- The round-trip property is not guarranteed if you insert code snippets into `.lhs` using three backticks
  - Nevertheless, feel free to insert them into `.md`. In `.lhs`, they will just lose the language info

## Command-line tool

### cabal

1. Clone this repo and install `lima`.

    ```console
    git clone https://github.com/deemp/flakes
    cd flakes/lima
    cabal update
    cabal install .
    ```

### nix

1. [Install Nix](https://github.com/deemp/flakes/blob/main/README/InstallNix.md)

1. Get `lima` on `PATH`.

    ```console
    nix flake lock github:deemp/flakes
    nix shell github:deemp/flakes?dir=lima
    lima --help
    ```

### Windows

To install the executable on `Windows`, if you can't convince cabal to use [`--bindir-method=copy`](https://github.com/haskell/cabal/issues/5748) you can build the project locally and copy the built executeable to `C:/Users/username/AppData/Roaming/cabal/bin` and ensure that this directory is in your `PATH`.

## Contribute

Clone this repo and enter `lima`

```console
git clone https://github.com/deemp/flakes
cd flakes/lima
```

### cabal

Build as usually

```console
cabal update
cabal build
```

### nix

1. [Install](https://github.com/deemp/flakes/blob/main/README/InstallNix.md) `Nix`. Optionally, [learn](https://github.com/deemp/flakes#prerequisites) more about `Nix`.

1. Run a devshell and build `lima`:

    ```console
    nix develop nix-dev/
    cabal build
    ```

1. Optionally, start `VSCodium`:

    ```console
    nix run nix-dev/#writeSettings
    nix run nix-dev/#codium .
    ```

1. Open a `Haskell` file there, hower over a term and wait until `HLS` shows the hints.

1. [Troubleshoot](https://github.com/deemp/flakes/blob/main/README/Troubleshooting.md) if necessary.
