{-# LANGUAGE OverloadedStrings #-}
module Language.Haskell.Liquid.CSS where

import Data.Text (Text)
import qualified Data.Text as Text

syntax :: Text
syntax = Text.unlines
  [ ".hs-linenum {"
  , "  color: #B2B2B2;"
  , "  font-style: italic;"
  , "}"
  , ""
  , ".hs-error {"
  , "  background-color: #FF8585 ;"
  , "}"
  , ""
  , ".hs-keyglyph {"
  , "  color: #007020"
  , "}"
  , ""
  , ".hs-keyword {"
  , "  color: #007020;"
  , "  // font-weight: bold;"
  , "}"
  , ""
  , ".hs-comment, .hs-comment a {color: green;}"
  , ""
  , ".hs-str, .hs-chr {color: teal;}"
  , ""
  , ".hs-conid { "
  , "  color: #902000;   /* color: #00FFFF; color: #0E84B5; */"
  , "  //font-weight: bold;  "
  , "}"
  , ""
  , ".hs-definition { "
  , "  color: #06287E "
  , "  /* font-weight: bold; */ "
  , "}"
  , ""
  , ".hs-varid, .hs-varop, .hs-layout {"
  , "  color: black; "
  , "}"
  , ""
  , ".hs-num {"
  , "  color: #40A070;"
  , "}"
  , ""
  , ".hs-conop {"
  , "  color: #902000; "
  , "}"
  , ""
  , ".hs-cpp {"
  , "  color: orange;"
  , "}"
  , ""
  , ".hs-sel  {}"
  , ""
  , "a.annot {"
  , "  position:relative; "
  , "  color:#000;"
  , "  text-decoration:none; "
  , "  white-space: pre; "
  , "}"
  , ""
  , "a.annot:hover { "
  , "  z-index:25; "
  , "  background-color: #D8D8D8;"
  , "}"
  , ""
  , "a.annot span.annottext{display: none}"
  , ""
  , "a.annot:hover span.annottext{ "
  , "  "
  , "  border-radius: 5px 5px;"
  , "  "
  , "  -moz-border-radius: 5px; "
  , "  -webkit-border-radius: 5px; "
  , "  "
  , "  box-shadow: 5px 5px 5px rgba(0, 0, 0, 0.1); "
  , "  -webkit-box-shadow: 5px 5px rgba(0, 0, 0, 0.1);"
  , "  -moz-box-shadow: 5px 5px rgba(0, 0, 0, 0.1); "
  , ""
  , "  white-space:pre;"
  , "  display:block;"
  , "  position: absolute; "
  , "  left: 1em; top: 2em; "
  , "  z-index: 99;"
  , "  margin-left: 5; "
  , "  background: #FFFFAA; "
  , "  border: 3px solid #FFAD33;"
  , "  padding: 0.8em 1em;"
  , "}"
  , ""
  , "code {"
  , "   /* font-weight: bold; */"
  , "   background-color: rgb(250, 250, 250);"
  , "   border: 1px solid rgb(200, 200, 200);"
  , "   padding-left: 4px;"
  , "   padding-right: 4px;"
  , "}"
  , ""
  , "pre {"
  , "  background-color: #f0f0f0;"
  , "  border-top: 1px solid #ccc;"
  , "  border-bottom: 1px solid #ccc;"
  , "  padding: 5px;"
  , "  // font-size: 120%;"
  , "  // font-family: Bitstream Vera Sans Mono,monospace;"
  , "  display: block;"
  , "  overflow: visible;"
  , "}"
  ]

