# Change log for the `llvm-extra` package

## 0.12.1

* `Multi.Value` -> `Nice.Value`

  The `Multi.Value` name was misleading.
  `Multi.Value` retained for compatibility for now.

## 0.11

* `Memory`: turn methods `load` and `store` into top-level functions
  based on `decompose` and `compose`.
  Deriving `decompose` and `compose` from `load` and `store`, respectively,
  requires `alloca` which will blast your stack when used in a loop.

## 0.10

* `Storable`: We do not support storing tuple types directly anymore.
  This would require the `storable-tuple` package.
  That package ships orphan `Storable` instances
  with a memory layout that does not match your system's ABI.
  Instead, we support the `Tuple` wrapper from `storable-record`.

* `Memory`: Attention!
  Memory layout is no longer compatible with `Foreign.Storable`.
  E.g. `Bool` now takes 1 byte space like LLVM does,
  but no longer 4 byte like `Foreign.Storable`.
  A `Foreign.Storable`-compliant layout
  is provided by `LLVM.Extra.Storable` now.

* `Marshal`: Now based on `Memory.load` and `Memory.store`.
  Does not need `Proxy` anymore.

* `Class` -> `Tuple`,
  `Tuple.Vector` class added.
  Pro: `valueOf vector` is no longer restricted to `IsPrimitive` elements.
  Cons: type inference works less well than before

## 0.9

* `Extension`: Move to new package `llvm-extension`.
  We now implement advanced instructions using generic LLVM intrinsics.

## 0.8.1

* `FastMath`: support for simplified arithmetic primitives
  under the assumption of the absence of corner cases.
