{-# LANGUAGE TypeFamilies #-}
{- |
LLVM counterpart to 'Either' datatype.
-}
module LLVM.Extra.Either (
   Either.T(..),
   Either.run,
   Either.getIsLeft,
   Either.mapLeft,
   Either.mapRight,
   left,
   right,
   ) where

import qualified LLVM.Extra.EitherPrivate as Either
import qualified LLVM.Extra.Tuple as Tuple


left :: (Tuple.Undefined b) => a -> Either.T a b
left = Either.left Tuple.undef

right :: (Tuple.Undefined a) => b -> Either.T a b
right = Either.right Tuple.undef
