{- |
Transfer values between Haskell and JIT generated code
in a Haskell-compatible format as dictated by the 'Foreign.Storable' class.
E.g. instance 'Bool' may use more than a byte (e.g. Word32).
For tuples, you may use the @Tuple@ wrapper from the @storable-record@ package.
The 'Storable' instance for 'Vector's is compatible with arrays,
i.e. indices always count upwards irrespective of machine endianess
and tuple elements are interleaved.
-}
module LLVM.Extra.Storable (
   -- * Basic class
   Store.C(..),
   Store.storeNext,
   Store.modify,

   -- * Classes for tuples and vectors
   Store.Tuple(..),
   Store.Vector(..),
   Store.TupleVector(..),

   -- * Standard method implementations
   Store.loadNewtype,
   Store.storeNewtype,
   Store.loadTraversable,
   Store.loadApplicative,
   Store.storeFoldable,

   -- * Pointer handling
   Store.advancePtr,
   Store.incrementPtr,
   Store.decrementPtr,

   -- * Loops over Storable arrays
   Array.arrayLoop,
   Array.arrayLoop2,
   Array.arrayLoopMaybeCont,
   Array.arrayLoopMaybeCont2,
   ) where

import qualified LLVM.Extra.Storable.Private as Store
import qualified LLVM.Extra.Storable.Array as Array
