module Main where

import qualified Test.Storable as Storable
import qualified Test.Vector as Vector

import qualified LLVM.Core as LLVM

import Data.Tuple.HT (mapFst)

import Control.Monad.IO.Class (liftIO)

import qualified Test.DocTest.Driver as DocTest


main :: IO ()
main = do
   LLVM.initializeNativeTarget

   DocTest.run $ mapM_
      (\(msg,prop) -> do
         DocTest.printPrefix (msg++": ")
         DocTest.property =<< liftIO prop) $
      map (mapFst ("Storable."++)) Storable.tests ++
      map (mapFst ("Vector."++)) Vector.tests ++
      []
