## Installation

Installation cannot be done fully automatically.
It would require Cabal code that is bound to certain Cabal versions
and is prone to fail.
We give several non-automatic ways
that also allow you to choose a particular LLVM version.

First possibility is to point Cabal
to the LLVM installation directories manually.
It is recommended to add options to your global `.cabal/config`:

~~~~
extra-include-dirs: /usr/lib/llvm-21/include
extra-lib-dirs: /usr/lib/llvm-21/lib
~~~~

This works for both `v1-build` and `v2-build`.
The shown paths work for Debian and Ubuntu
using the LLVM repositories at <https://apt.llvm.org/>.
You can obtain them with

~~~~
llvm-config-21 --includedir --libdir
~~~~

You can choose specific LLVM versions per project.
For `v1-builds` it works like so:

~~~~
cabal install -fllvm1300 --extra-include-dirs=$(llvm-config-13 --includedir) --extra-lib-dirs=$(llvm-config-13 --libdir) yourpackage
~~~~

For Nix-style build you must add some options
to the `cabal.project.local` file of your LLVM-related project:

~~~~
package llvm-ffi
  flags: +llvm1300
  extra-include-dirs: /usr/lib/llvm-13/include
  extra-lib-dirs: /usr/lib/llvm-13/lib
~~~~

Alternatively, you may set environment variables globally or locally:

~~~~
export CPATH=/usr/lib/llvm-21/include:$CPATH
export C_INCLUDE_PATH=/usr/lib/llvm-21/include:$C_INCLUDE_PATH
export LD_LIBRARY_PATH=/usr/lib/llvm-21/lib:$LD_LIBRARY_PATH
~~~~

You can install and make LLVM library available
in an elegant way using Nix:

~~~~
nix-shell -p llvmPackages_21.libllvm
~~~~

Though, for compatibility of GHC with LLVM and GLIBC
you will need to use more packages from Nix
and you better use a `shell.nix` file for bundling those:

~~~~
let
  pkgs = import <nixpkgs> {};
  llvmPkgs = pkgs.llvmPackages_21.libllvm;
in
pkgs.mkShell {
  nativeBuildInputs = (with pkgs; [
    gnumake
    pkg-config
    ghc
    cabal-install
    llvmPkgs
  ]);
  CPATH="${llvmPkgs.dev}/include";
  C_INCLUDE_PATH="${llvmPkgs.dev}/include";
  LD_LIBRARY_PATH="${llvmPkgs.lib}/lib";
}
~~~~

The second way uses `pkg-config`.
You can store above paths permanently in a `pkg-config` file like `llvm.pc`.
The optimal way would be if LLVM installations or GNU/Linux distributions
would contain such a file, but they don't.
Instead, you may generate it using the `llvm-pkg-config` package
or write one manually.
Then you run

~~~~
cabal install -fpkgConfig
~~~~

We ship a `pkg-config.nix` file.
If you import this into your Nix expression,
Nix will prepare and install a llvm.pc file for you.


## Known issues

Warning for inplace builds:
Re-configuring the package using, say `-fllvm1600`,
and re-buildung it might result in corrupt code.
You must make sure that the stuff in `cbits` is re-compiled.
Cabal or GHC may forget about that.
You are safe if you run `cabal clean`.


Caution:
Surprises are ahead
if you have configured paths for LLVM version X in `.cabal/config`
and try to build `llvm-ffi` for a different LLVM version Y
by adding custom include and library paths to `cabal.project`.
Counterintuitively, global search paths take higher precedence
[than local ones](https://github.com/haskell/cabal/issues/7782).

We now depend on libLLVM.so, not on libLLVM-X.so anymore.
This is for consistency with the include files,
where there are no include file names including version numbers.
In former versions of this binding package
we depend on generic LLVM/Core.h but specific libLLVM-X.so.
This meant,
that the include files configured in `.cabal/config`
were mixed with the library configured in `cabal.project`.
This lead to ugly, hard to debug crashes.
