{ stdenv, llvmPackages, haskellPackages }:
stdenv.mkDerivation rec {
  pname = "llvm-pc";
  version = llvmPackages.llvm.version;

  buildInputs = [ haskellPackages.llvm-pkg-config ];
  propagatedBuildInputs = [ llvmPackages.libllvm ];

  phases = [ "installPhase" ];

  installPhase = ''
    mkdir -p $out/lib/pkgconfig
    llvm-pkg-config >$out/lib/pkgconfig/llvm-${llvmPackages.llvm.shortVersion}.pc
  '';
}
