{ pkgs ? import <unstable> {}
, llvmVersion ? "2100"
}:

let
  llvmPackagesSet = {
    "1300" = pkgs.llvmPackages_13;
    "1400" = pkgs.llvmPackages_14;
    "1500" = pkgs.llvmPackages_15;
    "1600" = pkgs.llvmPackages_16;
    "1700" = pkgs.llvmPackages_17;
    "1800" = pkgs.llvmPackages_18;
    "1900" = pkgs.llvmPackages_19;
    "2000" = pkgs.llvmPackages_20;
    "2100" = pkgs.llvmPackages_21;
    "2200" = pkgs.llvmPackages_git;
  };
  llvmPkgs = llvmPackagesSet.${llvmVersion};
  llvmPkg = llvmPkgs.libllvm;
in
pkgs.mkShell {
  buildInputs = (with pkgs; [
    gnumake
    just
    pkg-config
    (haskellPackages.ghcWithPackages (hpkgs: with hpkgs; [enumset]))
    cabal-install
    llvmPkg
    haskellPackages.llvm-pkg-config
    (callPackage ./pkg-config.nix {llvmPackages=llvmPkgs;})
  ]);
  CPATH="${llvmPkg.dev}/include";
  C_INCLUDE_PATH="${llvmPkg.dev}/include";
  LD_LIBRARY_PATH="${llvmPkg.lib}/lib";
  PKG_CONFIG_PATH=".";
}
