# Revision history for llvm-pretty-bc-parser

## 0.6.0.0 -- 2026-01-23

* Updates for supporting LLVM-19:
  * Parsing of new `DebugRecord` values.
  * Parsing of new `GEPAttrs` flags for `GEP` instruction and constant
    expression.
  * Parsing for new `DICompositeType` fields added in LLVM 19.
  * Parsing of `num_extra_inhabitants` in `DIBasicType`.
* Updates for supporting new flags in cast-related instructions:
  * Support parsing `zext` instructions that use the `nneg` flag, indicating
    that the argument must be non-negative.
  * Support parsing `zext` and `uitofp` instructions that use the `nneg` flag,
    indicating that the argument must be non-negative.
  * Support parsing `trunc` instructions that use the `nuw` or `nsw` flags,
    indicating that the result should not result in unsigned or signed overflow,
    respectively.
* Support parsing `icmp` instructions that use the `samesign` flag (introduced
  in LLVM 20), indicating that the arguments must have the same sign.
* Support parsing `atomGroup` and `atomRank` fields in `DebugLoc` values
  (introduced in LLVM 21).
* Support parsing `column`, `isArtificial`, and `coroSuspendIdx` fields in
  `DILabel` values (introduced in LLVM 21).
* Support parsing non-constant sizes and offsets in `DIBasicType`,
  `DICompositeType`, and `DIDerivedType` values (a feature introduced in LLVM
  21).
* Fix a bug in which `i1 true` literals would be parsed as
  `i1 18446744073709551615` in certain cases.

## 0.5.1.0 (October 2025)

* Support parsing data layout strings that specify function pointer alignment.
* Implement `CST_CODE_STRING`, allowing the parsing of bitcode files containing strings without null terminators (as may be generated by languages other than C).

## 0.5.0.0 (March 2025)

* `Data.LLVM.BitCode` now defines funtions (whose names all end with
  `*WithWarnings`) that return any parser-related warnings (`ParseWarning`s)
  alongside the parsed `Module`. Users can decide whether or not to display
  these warnings (e.g., by printing them to `stderr` using `ppParseWarnings`).

  The existing functions which do not return warnings have been deprecated in
  favor of the their `*WithWarnings` variants.
* The functions in `Data.LLVM.BitCode` no longer produce a fatal error when
  encountering metadata records of unexpected sizes. Instead, these are now
  treated as warnings.

## 0.4.2.0 (August 2024)

* Add support for GHC 9.8 and drop official support of 9.2.

* Add support for new atomic operations in LLVM 9+.

## 0.4.1.0 (January 2024)

* Add preliminary support for LLVM versions up through 16.
* Require building with `llvm-pretty-0.12.*`.
* Add preliminary support for parsing opaque pointers. For now,
  `llvm-pretty-bc-parser` will still fill in the types of certain instructions
  with non-opaque pointer types (e.g., the type of memory to store in a `store`
  instruction), so be wary of this if you are parsing a bitcode file that
  contains opaque pointers. See also the discussion in
  https://github.com/GaloisInc/llvm-pretty-bc-parser/issues/262.
* Improve the runtime performance of the parser.
* A variety of bugfixes. Some notable fixes include:
  * Fix a bug in which the parser would fail to parse `DIDerivedType` nodes
    produced by Apple Clang on macOS.
  * Fix a bug in which the DWARF address space field of a `DIDerivedType` node
    was parsed incorrectly.
  * Fix a bug in which constant `fcmp`/`icmp` expressions would parse their
    operands incorrectly.
