# llvm-pretty-bc-parser

A parser for the LLVM bitcode file format, yielding a `Module` from
[the llvm-pretty package](http://hackage.haskell.org/package/llvm-pretty).

## Compatibility

The following table shows what kinds of tests have been/are being run with which
compilers.

 - A check in the the randomized tests column indicates that such tests are
   regularly run [in Github Actions][fuzz-workflow].
 - A check in the manual tests column indicates that the parser seems to work on
   some code that was generated by this compiler.

| Compiler  | Version | [Randomized tests](./fuzzing) | Manual tests | Notes                 |
|-----------|---------|-------------------------------|--------------|-----------------------|
| `clang`   | v3.4    | ✓                             |              | See [issues][llvm3.4] |
|           | v3.5    | ✓                             |              | See [issues][llvm3.5] |
|           | v3.6    | ✓                             |              | See [issues][llvm3.6] |
|           | v3.7    | ✓                             |              | See [issues][llvm3.7] |
|           | v3.8    | ✓                             | ✓            | See [issues][llvm3.8] |
|           | v3.9    | ✓                             |              | See [issues][llvm3.9] |
|           | v4      | ✓                             |              | See [issues][llvm4]   |
|           | v5      | ✓                             |              | See [issues][llvm5]   |
|           | v6      | ✓                             | ✓            | See [issues][llvm6]   |
|           | v7      | ✓                             |              | See [issues][llvm7]   |
|           | v8      | ✓                             |              | See [issues][llvm8]   |
|           | v9      | ✓                             |              | See [issues][llvm9]   |
|           | v10     | ✓                             | ✓            | See [issues][llvm10]  |
|           | v11     | ✓                             | ✓            | See [issues][llvm11]  |
|           | v12     | ✓                             | ✓            | See [issues][llvm12]  |
|           | v13     | ✓                             | ✓            | See [issues][llvm13]  |
|           | v14     | ✓                             | ✓            | See [issues][llvm14]  |
|           | v15     | ✓                             | ✓            | See [issues][llvm15]  |
|           | v16     | ✓                             | ✓            | See [issues][llvm16]  |
|           | v17     | ✓                             | ✓            | See [issues][llvm17]  |
|           | v18     | ✓                             | ✓            | See [issues][llvm18]  |
|           | v19     | ✓                             | ✓            | See [issues][llvm19]  |
|           | v20     | ✓                             | ✓            | See [issues][llvm20]  |
|           | v21     | ✓                             | ✓            | See [issues][llvm21]  |

If you encounter problems with the output of *any* compiler, please file [an
issue](https://github.com/GaloisInc/llvm-pretty-bc-parser/issues).

## Documentation

Developers' documentation: [doc/developing.md](./doc/developing.md)

## GHC Support

llvm-pretty-bc-parser endeavors to support three versions of GHC at a time. See
the developers' documentation for more details and a rationale:
[doc/developing.md](./doc/developing.md). Currently supported:

- GHC 9.6.6
- GHC 9.8.4
- GHC 9.10.1

[fuzz-workflow]: https://github.com/GaloisInc/llvm-pretty-bc-parser/blob/master/.github/workflows/llvm-quick-fuzz.yml
[llvm3.4]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F3.4
[llvm3.5]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F3.5
[llvm3.6]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F3.6
[llvm3.7]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F3.7
[llvm3.8]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F3.8
[llvm3.9]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F3.9
[llvm4]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F4.0
[llvm5]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F5.0
[llvm6]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F6.0
[llvm7]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F7.0
[llvm8]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F8.0
[llvm9]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F9.0
[llvm10]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F10.0
[llvm11]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F11.0
[llvm12]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F12.0
[llvm13]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F13.0
[llvm14]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F14.0
[llvm15]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F15.0
[llvm16]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F16.0
[llvm17]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F17.0
[llvm18]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F18.0
[llvm19]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F19.0
[llvm20]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F20.0
[llvm21]: https://github.com/GaloisInc/llvm-pretty-bc-parser/issues?q=is%3Aopen+is%3Aissue+label%3Allvm%2F21.0
