# Developers' documentation

<!-- markdown-toc start - Don't edit this section. Run M-x markdown-toc-refresh-toc -->
**Table of Contents**

- [Developers' documentation](#developers-documentation)
    - [Upstream documentation](#upstream-documentation)
    - [Building](#building)
    - [Running the tests](#running-the-tests)
        - [`llvm-disasm-test`](#llvm-disasm-test)
            - [description](#description)
            - [use](#use)
        - [`regression-test`](#regression-test)
        - [`unit-test`](#unit-test)
    - [Travis CI build](#travis-ci-build)

<!-- markdown-toc end -->

## Upstream documentation

Official (yet incomplete) reference: https://llvm.org/docs/BitCodeFormat.html

Relevant parts of the upstream C++ implementation:
 + [Parser (14.x)](https://github.com/llvm/llvm-project/blob/release/14.x/llvm/lib/Bitcode/Reader/BitcodeReader.cpp)
 + Record codes:
   * [Bitstream enum values (14.x)](https://github.com/llvm/llvm-project/blob/release/14.x/llvm/include/llvm/Bitstream/BitCodes.h)
   * [LLVM bitcode enum values (14.x)](https://github.com/llvm/llvm-project/blob/release/14.x/llvm/include/llvm/Bitcode/LLVMBitCodes.h)

## Building

Make sure you have cloned the `llvm-pretty` submodule before building:

```bash
$ git submodule update --init
$ cabal build
```

## Running the tests

### `llvm-disasm-test`

#### description

This test compares the behavior of `llvm-disasm` against that of `llvm-dis`, by
having them both disassemble the same file and diffing their output (in general,
we don't expect them to exactly match).

Additionally, by default this test does a "round-trip" comparison of
`llvm-disasm` against itself. After disassembling the first time, it reassembles
the output of `llvm-disasm` and runs it again. It then compares both the
ASTs and the LLVM assembly generated by the first and second run of
`llvm-disasm`, to ensure that the printer/parser combo is idempotent.

#### use

To compare the behavior of `llvm-disasm` against that of `llvm-dis`:
```bash
cabal build
./dist/build/disasm-test/disasm-test ./disasm-test/tests/fun-attrs.ll

# When using cabal new-build, the binary locations aren't so nice.
$(find . -name disasm-test -type f) disasm-test/tests/*.ll
```
To see all the options,
```bash
./dist/build/disasm-test/disasm-test --help
```

If you have [Nix](https://nixos.org/nix/) installed, you can easily compare
against multiple versions of `llvm-dis`, e.g.
```bash
nix-shell --pure -p llvm_6 --run "./dist/build/disasm-test/disasm-test ./disasm-test/tests/fun-attrs.ll"
```

### `regression-test`

See [the README in that directory](../regression-test/README.md).

### `fuzzing`

See [the README in that directory](../fuzzing/README.md).

### `unit-test`

These are run with `cabal test` or `cabal new-test`.

## Supported GHC Versions

A policy on which GHC versions to support must balance the benefits of wide
applicability/support against the drawbacks of additional costs of development,
including developer time and CI budgets. Our policy is to support three versions
of GHC at a time. We try to support new versions of GHC as soon as they are
supported by all of libraries that llvm-pretty-bc-parser depends on.

When updating the supported GHC versions, remember to update:

- [The README](../README.md)
- [The Cabal file](../llvm-pretty-bc-parser.cabal)'s `Tested-with` field
- [The Nix flake](../flake.nix)

  Run `nix flake update [input-pkg ...]` (installing [`nix`](https://nixos.org)
  first if necessary) which will update the `flake.lock` file in the top level
  directory.  If no `input-pkg` is specified, *all* inputs are updated.
  Optionally run `nix build ./#TESTS` to run the nix-based tests locally.  Then
  commit the updated `flake.lock` file.

  Newer GHC versions are automatically available to the nix build, but may
  require updating the flake lockfile as described above to become visible.

    1. To add new GHC versions to the `nix` builds, see the `ghc-version` list in
       the `nix-ci.yml` file.

    2. Sometimes GHC versions are deprecated and removed from the latest `nix`
       builds.  When this occurs, add a `nixpkgs` override in the `nix-ci.yml`
       file for the `build_old_GHC` job.

  The `flake.nix` file also specifies the range of LLVM versions that will be
  tested.  See the comments in that file for updating this version range,
  beginning with the comment at the top of the file.

- [CI workflows](../.github/workflows)
