-- SPDX-FileCopyrightText: 2020 Tocqueville Group
--
-- SPDX-License-Identifier: LicenseRef-MIT-TQ

-- | Packing utilities.
module Lorentz.Pack
  ( lPackValue
  , lUnpackValue
  , lEncodeValue
  ) where

import Data.Constraint ((\\))

import Lorentz.Constraints
import Michelson.Interpret.Pack
import Michelson.Interpret.Unpack
import Michelson.Typed

lPackValue
  :: forall a.
     (NicePackedValue a)
  => a -> ByteString
lPackValue =
  packValue' . toVal \\ nicePackedValueEvi @a

lUnpackValue
  :: forall a.
     (NiceUnpackedValue a)
  => ByteString -> Either UnpackError a
lUnpackValue =
  fmap fromVal . unpackValue' \\ niceUnpackedValueEvi @a

lEncodeValue
  :: forall a. (NicePrintedValue a)
  => a -> ByteString
lEncodeValue = encodeValue' . toVal \\ nicePrintedValueEvi @a
