-- | The are three kinds of model, each depending on the previous one:
--
-- * [@Model.Table@]:
--   Pure model of a single table.
--   @
--   updates :: [_] -> Table k v b -> Table k v b
--   @
--
-- * [@Model.Session@]:
--   Pure model of a session (containing multiple tables).
--   @
--   updates :: MonadState Model m => [_] -> Table k v b -> m ()
--   @
--
-- * [@Model.IO@]:
--   STM-based model allowing multiple (potentially closed) sessions.
--   @
--   updates :: MonadSTM m => MSession m -> [_] -> Table k v b -> m ()
--   @
--
module Database.LSMTree.Model () where
