## markov-chain-usage-model

[![Hackage](https://img.shields.io/hackage/v/markov-chain-usage-model.svg)](https://hackage.haskell.org/package/markov-chain-usage-model)
[![Stackage Nightly](http://stackage.org/package/markov-chain-usage-model/badge/nightly)](http://stackage.org/nightly/package/markov-chain-usage-model)
[![Stackage LTS](http://stackage.org/package/markov-chain-usage-model/badge/lts)](http://stackage.org/lts/package/markov-chain-usage-model)
[![Build Status](https://api.travis-ci.org/advancedtelematic/markov-chain-usage-model.svg?branch=master)](https://travis-ci.org/advancedtelematic/markov-chain-usage-model)

`markov-chain-usage-model` is a Haskell library for performing computations on
Markov chain based usage models.

### References

  * [A theory of software reliability and its
    application](http://doi.ieeecomputersociety.org/10.1109/TSE.1975.6312856)
    (1975) by J. D. Musa;

  * [Engineering software under statistical quality
    control](https://doi.org/10.1109/52.60601) (1990) by R. H. Cobb and H. D.
    Mills;

  * [Operational profiles in software-reliability
    engineering](https://doi.org/10.1109/52.199724) (1993) by J. D. Musa;

  * [A Markov chain model for statistical software
    testing](https://doi.org/10.1109/32.328991) (1994) by J. A. Whittaker and M.
    G. Thomason;

  * [Statistical testing of software based on a usage
    model](https://doi.org/10.1002/spe.4380250106) (1995) by G. H. Walton, J. H.
    Poore and C. J. Trammell;

  * [Quantifying the reliability of software: statistical testing based on a
    usage model](https://doi.org/10.1109/SESS.1995.525966) (1995) by C.
    Trammell;

  * [Computations for Markov Chain Usage
    Models](http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.416.2257&rep=rep1&type=pdf)
    (2000) by S. J. Prowell;

  * [Computing system reliability using Markov chain usage
    models](https://doi.org/10.1016/S0164-1212(03)00241-3) (2004) by S. J.
    Prowell and J. H. Poore;

  * Software Reliability Engineering: More Reliable Software Faster and Cheaper
    (2004) by J. D. Musa;

  * [A Simpler and More Direct Derivation of System Reliability Using Markov
    Chain Usage
    Models](https://ksiresearchorg.ipage.com/seke/seke17paper/seke17paper_91.pdf)
    (2017) by L. Lin, Y. Xue and F. Song;

  * [On A Simpler and Faster Derivation of Single Use Reliability Mean and
    Variance for Model-Based Statistical
    Testing](http://ksiresearchorg.ipage.com/seke/seke18paper/seke18paper_26.pdf)
    (2018) by Y. Xue, L. Lin, X. Sun and F. Song;

  * [Stopping criteria for statistical
    testing](https://doi.org/10.1016/S0950-5849(00)00110-5) (2000) by K. Sayre
    and J. H. Poore;

  * [A cost-benefit stopping criterion for statistical
    testing](https://doi.org/10.1109/HICSS.2004.1265715) (2004) by S. J.
    Prowell.

### See also

  * The JUMBL library and tool ([documentation](http://jumbl.sourceforge.net/)
    and [code](https://sourceforge.net/p/jumbl/code/ci/master/tree/))

### License

BSD-style (see the file LICENSE).
