-- Copyright (c) 2014 Sebastian Wiesner <lunaryorn@gmail.com>

-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this software and associated documentation files (the "Software"), to deal
-- in the Software without restriction, including without limitation the rights
-- to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
-- copies of the Software, and to permit persons to whom the Software is
-- furnished to do so, subject to the following conditions:

-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Software.

-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
-- OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
-- THE SOFTWARE.

import Web.Marmalade.Magic (guessMimeType)

import Control.Exception (handleJust)
import Control.Monad (guard)
import System.IO.Error (isDoesNotExistError)
import Test.Tasty
import Test.Tasty.HUnit

mimeTypeOfEmacsLispFile :: TestTree
mimeTypeOfEmacsLispFile = testCase "Emacs Lisp file" $ do
  mimeType <- guessMimeType "test/resources/foo.el"
  mimeType @?= "text/x-lisp"

mimeTypeOfTarFile :: TestTree
mimeTypeOfTarFile = testCase "TAR file" $ do
  mimeType <- guessMimeType "test/resources/foo.tar"
  mimeType @?= "application/x-tar"

mimeTypeOfTextFile :: TestTree
mimeTypeOfTextFile = testCase "Text file" $ do
  mimeType <- guessMimeType "README.md"
  mimeType @?= "text/plain"

fileDoesNotExist :: TestTree
fileDoesNotExist = testCase "File does not exist" $
  handleJust (guard.isDoesNotExistError) (const $ return ()) $ do
    _ <- guessMimeType "thisFileDoesNotExist"
    assertFailure "Expected IO error not thrown"

tests :: TestTree
tests = testGroup "Mimetype guessing"
        [
          mimeTypeOfEmacsLispFile
        , mimeTypeOfTarFile
        , mimeTypeOfTextFile
        , fileDoesNotExist
        ]

main :: IO ()
main = defaultMain tests
