# ML-KEM

_Module-Lattice-based Key-Encapsulation Mechanism_ implemented in Haskell.

See [FIPS 203](https://csrc.nist.gov/pubs/fips/203/final).

Example session:

```haskell
> import Crypto.PubKey.ML_KEM
> import Data.Proxy
> let params = Proxy :: Proxy ML_KEM_768
> (encapKey, decapKey) <- generate params
> (sharedKey, ciphertext) <- encapsulate encapKey
> let sharedKey' = decapsulate decapKey ciphertext
> sharedKey == sharedKey'
True
```

## Notes

The library does its best to destroy secrets and intermediate buffers from
memory after use, despite the implementation in functional style.  This relies
on finalization by the garbage collector and is not guaranteed to run before
the program exits.  Also, depending on optimizations applied, lambdas may
capture variables and move them to the heap.  This could theoretically include
machine words containing secret information that would not then be destroyed.

Best performance is obtained with the LLVM code generator.

## Testing

The test suite executes all NIST test vectors but necessary files are not
included in the package to limit its size.  Instead, two files are downloaded
from the project repository during execution, and this relies on commands `sh`
and `curl` to run the script `tests/get-vectors.sh`.  If not applicable to your
environment, please execute the same steps manually.  It will be needed only
the first time.
