{-# LANGUAGE CPP #-}
module SecureBlock
    ( SecureBlock, create, index, iterModify, Marking.map, new, thaw
    , unsafeCast, unsafeFreeze, toNormalForm
#ifdef ML_KEM_TESTING
    , eq, Marking.showsPrec, fromList, Marking.replicate, toList
    , SecureBlock.length
#endif
    ) where

import Basement.Monad
import Basement.PrimType
#ifdef ML_KEM_TESTING
import Basement.Types.OffsetSize
#endif

import Block (MutableBlock)
import Marking
import qualified Block

iterModify :: (PrimType ty, PrimMonad prim) => (ty -> ty) -> MutableBlock ty (PrimState prim) -> prim ()
iterModify = Block.iterModify

#ifdef ML_KEM_TESTING
length :: (Classified marking, PrimType ty) => SecureBlock marking ty -> CountOf ty
length = lengthBlock
#endif
