{-# LANGUAGE OverloadedStrings #-}
module KeyGen
    ( TestGroup(..), Test(..)
    ) where

import Data.Aeson
import Data.ByteString (ByteString)

import Util

data TestGroup = TestGroup
    { tgId :: Int
    , testType :: String
    , parameterSet :: String
    , tests :: [Test]
    } deriving Show

instance FromJSON TestGroup where
    parseJSON = withObject "TestGroup" $ \o -> TestGroup
        <$> o .: "tgId"
        <*> o .: "testType"
        <*> o .: "parameterSet"
        <*> o .: "tests"

data Test = Test
    { tcId :: Int
    , deferred :: Bool
    , d :: ByteString
    , z :: ByteString
    , ek :: ByteString
    , dk :: ByteString
    } deriving Show

instance FromJSON Test where
    parseJSON = withObject "Test" $ \o -> Test
        <$> o .: "tcId"
        <*> o .: "deferred"
        <*> o .:: "d"
        <*> o .:: "z"
        <*> o .:: "ek"
        <*> o .:: "dk"
