-- |
-- Module      : Vectors
-- License     : BSD-3-Clause
-- Copyright   : (c) 2025 Olivier Chéron
--
-- Common implementation of ML-KEM test vectors
--
{-# LANGUAGE OverloadedStrings #-}
module Vectors
    ( VectorFile(..), readJson
    ) where

import Data.Aeson
import qualified Data.ByteString.Lazy as L

import qualified Codec.Compression.GZip as GZip

data VectorFile tg = VectorFile
    { vsId :: Int
    , algorithm :: String
    , mode :: String
    , revision :: String
    , isSample :: Bool
    , testGroups :: [tg]
    } deriving Show

instance FromJSON tg => FromJSON (VectorFile tg) where
    parseJSON = withObject "File" $ \o -> VectorFile
        <$> o .: "vsId"
        <*> o .: "algorithm"
        <*> o .: "mode"
        <*> o .: "revision"
        <*> o .: "isSample"
        <*> o .: "testGroups"

readJson :: FromJSON tg => FilePath -> IO (VectorFile tg)
readJson path = do
    bs <- L.readFile path
    case decode (GZip.decompress bs) of
        Just file -> return file
        _         -> fail "could not parse"
