-------------------------------------------------------------------
-- |
-- Module      :  Data.SplitBounds
-- Copyright   :  (c) Dmitry Golubovsky, 2009
-- License     :  BSD-style
-- 
-- Maintainer  :  golubovsky@gmail.com
-- Stability   :  experimental
-- Portability :  portable
-- 
--
--
-- Defines string literals for module split boundaries.
------------------------------------------------------------------

module Data.SplitBounds (
  splitOpen
 ,splitClose
 ,splitBegin
 ,splitEnd
 ,parts) where

-- |A special comment to mark the start of a section to uncomment when splitting.

splitOpen :: String
splitOpen   = "{-- #SPLIT#"

-- |A special comment to mark the end of a section to uncomment when splitting.

splitClose :: String
splitClose  = "#SPLIT# --}"

-- |A special comment to mark the start of a module to be created by the splitter.
-- It should be followed immediately by a forward slash and a name of the
-- module to create (with dots). Thus,
--
-- @
-- splitBegin ++ \"/\" ++ \"Data.Foo\"
-- @
--
-- results in creation of a file \"Data/Foo.hs\" relatively to the current directory.

splitBegin :: String
splitBegin  = "-- Split begin"

-- |A special comment to mark the end of a module to be created by the splitter.

splitEnd :: String
splitEnd    = "-- Split end"

-- |A generic version of 'words': breaks a list by any predicate.

parts :: (a -> Bool) -> [a] -> [[a]]
parts pred s = case dropWhile pred s of
                 [] -> []
                 s' -> w : parts pred s''
                             where (w, s'') = break pred s'

