import Data.Aeson (eitherDecodeFileStrict, encodeFile)
import Data.Char (chr)
import Data.IntMap qualified as IntMap

import Graphics.MSDF.Atlas.Layout
import Graphics.MSDF.Atlas.Compact (compact)

main :: IO ()
main = do
  testCompact
  testAtlasCodepoints

testCompact :: IO ()
testCompact = do
  layout <- eitherDecodeFileStrict "test/Ubuntu-R-codepoints.json" >>= either fail pure
  encodeFile "test/compact.json" (compact layout)

testAtlasCodepoints :: IO ()
testAtlasCodepoints = do
  Layout{glyphs, kerning} <- eitherDecodeFileStrict "test/Ubuntu-R-codepoints.json" >>= either fail pure
  mapM_ (matchCodepoints $ byCodepoint glyphs) kerning

matchCodepoints :: ByCodepoint -> Kerning -> IO ()
matchCodepoints (ByCodepoint codepoints) Kerning{..} = sequence_ pair_
  where
    pair_ = do
      a <- unicode1
      b <- unicode2
      Just do
        Glyph{} <- maybe (fail "unicode1 codepoint not found in glyphs") pure $ IntMap.lookup a codepoints
        Glyph{} <- maybe (fail "unicode2 codepoint not found in glyphs") pure $ IntMap.lookup b codepoints
        putStrLn $ chr a : chr b : ' ' : show advance
