{-# LANGUAGE GADTs, MultiParamTypeClasses, RankNTypes, FlexibleContexts, FunctionalDependencies, TypeSynonymInstances, FlexibleInstances #-}

module Main (main) where

import MVD.Debugger
import MVD.Finders
import MVD.STR


eval :: Int -> String -> [Int]
eval 0 "next" = [1]
eval 1 "next" = [2, 1]
eval 2 "next" = [0, 1, 2, 3]
eval 3 "next" = [1]
eval _ _ = undefined

instance Reduce () Int Int where 
    rstate _ c = c

instance Evaluate Int Int Bool where 
    estate goal curr = goal == curr 



strSimple :: STR Int String ()
strSimple = STR 
    { initial = [0]
    , actions = const ["next"]
    , execute = eval
    , commands = const []
    , perform = \c _ -> c
    }

-- This does no reduction and uses == to find breakpoints, in this case it searches for the state identified by 2.
-- Interact wit the debugger by giving the list index of the action you want to execute (0th based).
-- exampleDebugger :: IO ()
-- exampleDebugger = debugger strSimple equalityFinder (2 :: Int) ()

main :: IO ()
main = undefined -- exampleDebugger
