{-# LANGUAGE GADTs, MultiParamTypeClasses, RankNTypes, FlexibleContexts, FunctionalDependencies, TypeSynonymInstances, FlexibleInstances #-}

module MVD.STR where 

import qualified Data.Set as S
import Data.Graph

data STR c a m = STR 
    { initial :: [c]
    , actions :: c -> [a] 
    , execute :: c -> a -> [c] 
    , commands :: c -> [m]
    , perform :: c -> m -> c
    }


data TR c a = TR 
    { tinitial :: [c]
    , accepting :: c -> Bool
    , next :: c -> [(a, c)] 
    }

data DebugConfig c a = DebugConfig 
    { current :: Maybe c
    , history :: Graph c a
    , options :: Graph c a
    }
    deriving (Show, Eq)


data PrettyPrinter c a m = PrettyPrinter 
    { ppc :: c -> String
    , ppa :: a -> String
    , ppm :: m -> String
    }


ppFromShow :: (Show c, Show a, Show m) => PrettyPrinter c a m 
ppFromShow = PrettyPrinter { ppc = show, ppa = show, ppm = show }


data DebugAction a c = Step a | Select c | Jump c | RunDefaultBreak | RunCustomBreak
    deriving Show


-- The result component denotes a list of current:history traces.
-- type Finder c a m e r alpha = (Evaluate e c Bool, Reduce r c alpha) => STR c a m -> Graph c a -> e -> r -> (Graph c a, [c])
type Finder c a m = STR c a m -> Graph c a -> (Graph c a, S.Set c)

class Evaluate e c v where 
    estate :: e -> c -> v

class Reduce r c a | r c -> a where 
    rstate :: r -> c -> a

