{-# LANGUAGE OverloadedStrings #-}

module SortPubkeys (testSortPubkeys) where

import Crypto.Curve.Secp256k1 (Pub)
import Crypto.Curve.Secp256k1.MuSig2 (sortPublicKeys)
import Data.Sequence (Seq)
import qualified Data.Sequence as Seq
import Test.Tasty
import Test.Tasty.HUnit
import Util (parsePoint)

parsePoints :: [Pub]
parsePoints =
  map
    parsePoint
    [ "02DD308AFEC5777E13121FA72B9CC1B7CC0139715309B086C960E18FD969774EB8"
    , "02F9308A019258C31049344F85F89D5229B531C845836F99B08601F113BCE036F9"
    , "03DFF1D77F2A671C5F36183726DB2341BE58FEAE1DA2DECED843240F7B502BA659"
    , "023590A94E768F8E1815C2F24B4D80A8E3149316C3518CE7B7AD338368D038CA66"
    , "02DD308AFEC5777E13121FA72B9CC1B7CC0139715309B086C960E18FD969774EFF"
    , "02DD308AFEC5777E13121FA72B9CC1B7CC0139715309B086C960E18FD969774EB8"
    ]

parsePointsSorted :: Seq Pub
parsePointsSorted =
  Seq.fromList $
    map
      parsePoint
      [ "023590A94E768F8E1815C2F24B4D80A8E3149316C3518CE7B7AD338368D038CA66"
      , "02DD308AFEC5777E13121FA72B9CC1B7CC0139715309B086C960E18FD969774EB8"
      , "02DD308AFEC5777E13121FA72B9CC1B7CC0139715309B086C960E18FD969774EB8"
      , "02DD308AFEC5777E13121FA72B9CC1B7CC0139715309B086C960E18FD969774EFF"
      , "02F9308A019258C31049344F85F89D5229B531C845836F99B08601F113BCE036F9"
      , "03DFF1D77F2A671C5F36183726DB2341BE58FEAE1DA2DECED843240F7B502BA659"
      ]

-- | Test vectors from [BIP-0327 `key_sort_vectors.json`](https://github.com/bitcoin/bips/blob/master/bip-0327/vectors/key_sort_vectors.json)
testSortPubkeys :: TestTree
testSortPubkeys =
  testGroup
    "sorting pubkeys"
    [testCase "BIP-0327 test vector" $ sortPublicKeys parsePoints @=? parsePointsSorted]
