-- | All the definitions in these \"Internal\" modules are not version-controlled.
-- WARNING: If you depend on them, your code may break even when the nanopass package version does not increase.
--
-- They are here because I have found it useful to generate documentation for how this library works.
-- Developers can then check on how the internal interfaces are meant to work together.
--
-- * "Nanopass.Internal.Representation" defines an intermediate representation that is at the core of all operations.
-- * "Nanopass.Internal.Error" holds the data type for error reporting, and TODO will hold printers for those errors.
-- * "Nanopass.Internal.Parser" is responsible for parsing quasiquotes into language definitions, modifications, and passes.
-- * "Nanopass.Internal.Validate" is responsible for ensuring language definitions are well-formed.
-- * "Nanopass.Internal.Extend" is responsible for modifying a base language to create a new language.
-- * TODO "Nanopass.Internal.Decode" is responsible for recovering languages from Haskell data types.
-- * TODO "Nanopass.Internal.GenTypes" is responsible for generating types for a language.
-- * TODO "Nanopass.Internal.GenXlate" is responsible for generating passes (translation functions and types) between languages.
module Nanopass.Internal () where