{-|
Module      : Nauty.Graph6
Description : Encoding and decoding for @graph6@.
Copyright   : (c) Marcelo Garlet Milani, 2026
License     : MIT
Maintainer  : mgmilani@pm.me
Stability   : stable

This module functions for encoding and decoding graphs in @graph6@ format.

If you want to work with a more general interface instead, use "Nauty".
-}

module Nauty.Graph6
       ( 
       -- * Graph structure
         AdjacencyMatrix(..)
       , areAdjacent
       , fromEdgeList
       , toEdgeList
       -- * Parsing
       , parse
       , graph
       -- * Encoding
       , encode
       )
where

import Nauty.Graph6.Internal
