{-|
Module      : Nauty.Internal.Utils
Description : Internal functions.
Copyright   : (c) Marcelo Garlet Milani, 2025
License     : GPL-3
Maintainer  : mgmilani@pm.me
Stability   : unstable

This module contains internal functions used by other modules.
Except for test cases, you should not import this module.
-}

{-# LANGUAGE OverloadedStrings #-}

module Nauty.Internal.Utils where

-- |Group a list of elements two-by-two.
groupByTwo :: [a] -> [(a,a)]
groupByTwo (x:y:xs) = (x,y) : groupByTwo xs
groupByTwo _ = []

-- |Ungroup components of each pair.
ungroupByTwo :: [(a,a)] -> [a]
ungroupByTwo ((a,b) : xs) = a : b : ungroupByTwo xs
ungroupByTwo _ = []
