{-|
Module      : Nauty.Sparse6
Description : Encoding and decoding functions for @sparse6@.
Copyright   : (c) Marcelo Garlet Milani, 2026
License     : MIT
Maintainer  : mgmilani@pm.me
Stability   : stable

This module functions for encoding and decoding graphs in @sparse6@ format.

If you want to work with a more general interface instead, use "Nauty".
-}

module Nauty.Sparse6
       ( 
       -- * Graph structure
         AdjacencyList(..)
       , areAdjacent
       , fromEdgeList
       , toEdgeList
       -- * Parsing
       , parse
       , graph
       , symmetricDifference
       -- * Encoding
       , encode
       , encodeSymmetricDifference
       )
where

import Nauty.Sparse6.Internal
