{-|
Module      : Nauty.Digraph6
Description : Encoding and decoding for @digraph6@.
Copyright   : (c) Marcelo Garlet Milani, 2026
License     : MIT
Maintainer  : mgmilani@pm.me
Stability   : stable

This module contains functions for encoding and decoding graphs in @digrap6@ format.

If you want to work with a more general interface instead, use "Nauty".
-}

module Nauty.Digraph6
       ( 
       -- * Graph structure
         AdjacencyMatrix(..)
       , arcExists
       , fromArcList
       , toArcList
       -- * Parsing
       , parse
       , digraph
       -- * Encoding
       , encode
       )
where

import Nauty.Digraph6.Internal
