
  (
#ifndef TESTING
    Seq
#else
    Seq(..)
#endif
    -- * Accessing the left end of the sequence
  , cons
  , unCons
    -- * Basic queries
  , null
  , length 
    -- * Basic construction
  , empty
  , toList
  , fromList
    -- * Short sequences
  , singleton
  , pair
  , triple
  , quad
    -- * Unsafe head and tail
  , head
  , tail
  , last
    -- * Safe head and tail
  , mbHead
  , mbTail
  , tails
  , mbLast
    -- * Indexing
  , lookup
  , mbLookup
  , update
  , replace
  , drop
    -- * Slow operations
  , append
  , take 
  , init , mbInit
  , snoc
  , unSnoc
    -- * Debugging
  , toListNaive
  , checkInvariant
  , showInternal
  , graphviz
  )
  where

--------------------------------------------------------------------------------

import Prelude hiding ( null , length , head , tail , last , init 
                      , take , drop , fst , snd , seq , lookup )

import qualified Prelude

import Data.Bits ( shiftR , (.&.) )
import Data.Monoid
import Data.Ord

import qualified Data.Foldable as F

import Control.Applicative ( Applicative(..) , (<$>) )
import Control.Monad 

import Text.Show ( showsPrec , showString , showChar , showParen , ShowS )

--------------------------------------------------------------------------------

