-- |
-- Module: NetSpider
-- Description: NetSpider top-level document
-- Maintainer: Toshio Ito <debug.ito@gmail.com>
--
-- This module is just for documentation.
--
-- For tutorial, see the [project README](https://github.com/debug-ito/net-spider).
--
-- = NetSpider module layout
--
-- == Bundle modules for the user
--
-- * "NetSpider.Input": Functions to input local findings to the
--   history graph.
-- * "NetSpider.Output": Functions to get snapshot graphs from the
--   history graph.
--
-- == Spider and query
--
-- * "NetSpider.Spider"
-- * "NetSpider.Spider.Config"
-- * "NetSpider.Query"
-- * "NetSpider.Unify"
--
-- == Weaver (on-memory snapshot builder)
--
-- * "NetSpider.Weaver"
--
-- == Data models
--
-- * "NetSpider.Found"
-- * "NetSpider.Timestamp"
-- * "NetSpider.Graph"
-- * "NetSpider.Snapshot"
-- * "NetSpider.Interval"
--
-- == Formatter
--
-- * "NetSpider.GraphML.Writer": Write a SnapshotGraph in GraphML format.
--
-- == Utility
--
-- * "NetSpider.Pair": Swap-insensitive two-element homogeneous tuple
-- * "NetSpider.Log"
-- * "NetSpider.SeqID": Utility to generate sequential node IDs.
module NetSpider
       () where
