-- |
--
-- Module      : Network.URI.Template.Expand
-- Copyright   : (c) 2025 Patrick Brisbin
-- License     : AGPL-3
-- Maintainer  : pbrisbin@gmail.com
-- Stability   : experimental
-- Portability : POSIX
module Network.URI.Template.Expand
  ( expandTemplate
  ) where

import Prelude

import Data.Map.Strict (Map)
import Data.Text (Text)
import Network.URI.Template.Internal
import Network.URI.Template.VarName
import Network.URI.Template.VarValue

expandTemplate :: Map VarName VarValue -> Template -> Text
expandTemplate env = foldMap (expandTemplatePart env) . (.unwrap)

expandTemplatePart :: Map VarName VarValue -> TemplatePart -> Text
expandTemplatePart env = \case
  Lit t -> t
  Exp e -> expandExpression env e
