module Text.P3
    ( -- * Parser top function
      parse
      -- * Parser monad
    , ParserContext (..)
    , ParserState (..)
    , Parser
    , (>>>)
    , ParserTable (..)
    , insertLeadingParser
    , insertTrailingParser
    , leadingParsersOf
    , trailingParsersOf
    , runParser
    , shift
    , matchToken
    , eot
    , mkAtom
    , mkNode
      -- * Parser types
    , Name (..)
    , BindingPower (..)
    , Token (..)
    , Syntax (..)
      -- * Parser core logic
    , parseLeading
    , parseTrailing
    ) where

import Text.P3.Logic
import Text.P3.Monad
import Text.P3.Types

parse :: Token t => ParserTable t -> [t] -> Either String (Syntax t)
parse tbl = runParser tbl (parseLeading <* eot)
