{-|
Utilities for writing parser combinators in P3.
-}
module Text.P3.Combinators
    ( token
    , satisfy
    , between
    , (<|<)
    , choice
    ) where

import Text.P3.Monad
import Text.P3.Types

-- | Consume a given token.
token :: Eq t => t -> Parser t
token t = matchToken (Token t ==)

-- | Consume a token that satisfies a predicate.
satisfy :: (t -> Bool) -> Parser t
satisfy p = matchToken $ \case
    Token t -> p t
    Terminator -> False

-- | Match a token between two other tokens.
between :: Eq t => t -> t -> Parser t -> Parser t
between open close p = token open >>> p >>> token close

-- | Left-biased choice.
(<|<) :: Parser t -> Parser t -> Parser t
(<|<) p1 p2 ctx st = case p1 ctx st of
    st' | hasError st' -> p2 ctx st'
        | otherwise    -> st'

-- | Choice between multiple parsers.
choice :: [Parser t] -> Parser t
choice = foldr (<|<) (const id)
