```
% pandoc -f latex -t native
\newtheorem{theorem}{Theorem}
\newtheorem{corollary}[theorem]{Corollary}
\newtheorem{lemma}[theorem]{Lemma}
\theoremstyle{definition}
\newtheorem{definition}[theorem]{Definition}
\theoremstyle{remark}
\newtheorem{remark}{Remark}

\begin{definition}[right-angled triangles] \label{def:tri}
A \emph{right-angled triangle} is a triangle whose sides of length~\(a\), \(b\) and~\(c\), in some permutation of order, satisfies \(a^2+b^2=c^2\).
\end{definition}

\begin{lemma}
The triangle with sides of length~\(3\), \(4\) and~\(5\) is right-angled.
\end{lemma}

\begin{proof}
This lemma follows from \cref{def:tri} since \(3^2+4^2=9+16=25=5^2\).
\end{proof}

\begin{theorem}[Pythagorean triplets] \label{thm:py}
Triangles with sides of length \(a=p^2-q^2\), \(b=2pq\) and \(c=p^2+q^2\) are right-angled triangles.
\end{theorem}

\begin{remark}
These are all pretty interesting facts.
\end{remark}
^D
[ Div
    ( "def:tri" , [ "definition" ] , [] )
    [ Para
        [ Strong [ Str "Definition" , Space , Str "1" ]
        , Space
        , Str "(right-angled"
        , Space
        , Str "triangles)."
        , Space
        , Space
        , Str "A"
        , Space
        , Emph [ Str "right-angled" , Space , Str "triangle" ]
        , Space
        , Str "is"
        , Space
        , Str "a"
        , Space
        , Str "triangle"
        , Space
        , Str "whose"
        , Space
        , Str "sides"
        , Space
        , Str "of"
        , Space
        , Str "length\160"
        , Math InlineMath "a"
        , Str ","
        , Space
        , Math InlineMath "b"
        , Space
        , Str "and\160"
        , Math InlineMath "c"
        , Str ","
        , Space
        , Str "in"
        , Space
        , Str "some"
        , Space
        , Str "permutation"
        , Space
        , Str "of"
        , Space
        , Str "order,"
        , Space
        , Str "satisfies"
        , Space
        , Math InlineMath "a^2+b^2=c^2"
        , Str "."
        ]
    ]
, Div
    ( "" , [ "lemma" ] , [] )
    [ Para
        [ Strong [ Str "Lemma" , Space , Str "2" ]
        , Str "."
        , Space
        , Space
        , Emph
            [ Str "The"
            , Space
            , Str "triangle"
            , Space
            , Str "with"
            , Space
            , Str "sides"
            , Space
            , Str "of"
            , Space
            , Str "length\160"
            , Math InlineMath "3"
            , Str ","
            , Space
            , Math InlineMath "4"
            , Space
            , Str "and\160"
            , Math InlineMath "5"
            , Space
            , Str "is"
            , Space
            , Str "right-angled."
            ]
        ]
    ]
, Div
    ( "" , [ "proof" ] , [] )
    [ Para
        [ Emph [ Str "Proof." ]
        , Space
        , Str "This"
        , Space
        , Str "lemma"
        , Space
        , Str "follows"
        , Space
        , Str "from"
        , Space
        , Link
            ( ""
            , []
            , [ ( "reference-type" , "ref+label" )
              , ( "reference" , "def:tri" )
              ]
            )
            [ Str "1" ]
            ( "#def:tri" , "" )
        , Space
        , Str "since"
        , Space
        , Math InlineMath "3^2+4^2=9+16=25=5^2"
        , Str "."
        , Str "\160\9723"
        ]
    ]
, Div
    ( "thm:py" , [ "theorem" ] , [] )
    [ Para
        [ Strong [ Str "Theorem" , Space , Str "3" ]
        , Space
        , Str "(Pythagorean"
        , Space
        , Str "triplets)."
        , Space
        , Space
        , Emph
            [ Str "Triangles"
            , Space
            , Str "with"
            , Space
            , Str "sides"
            , Space
            , Str "of"
            , Space
            , Str "length"
            , Space
            , Math InlineMath "a=p^2-q^2"
            , Str ","
            , Space
            , Math InlineMath "b=2pq"
            , Space
            , Str "and"
            , Space
            , Math InlineMath "c=p^2+q^2"
            , Space
            , Str "are"
            , Space
            , Str "right-angled"
            , Space
            , Str "triangles."
            ]
        ]
    ]
, Div
    ( "" , [ "remark" ] , [] )
    [ Para
        [ Emph [ Str "Remark" , Space , Str "1" ]
        , Str "."
        , Space
        , Space
        , Str "These"
        , Space
        , Str "are"
        , Space
        , Str "all"
        , Space
        , Str "pretty"
        , Space
        , Str "interesting"
        , Space
        , Str "facts."
        ]
    ]
]
```
