Table with row and column spans
```
% pandoc -f html -t asciidoc
<table>
  <colgroup>
    <col style="width: 17%" />
    <col style="width: 16%" />
    <col style="width: 15%" />
    <col style="width: 52%" />
  </colgroup>
  <thead>
    <tr>
      <th>Header 1</th>
      <th>Header 2</th>
      <th>Header 3</th>
      <th>Header 4</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>body row 1</td>
      <td>column 2</td>
      <td>column 3</td>
      <td>column 4</td>
    </tr>
    <tr>
      <td>body row 2</td>
      <td colspan="2">Cells may span columns.</td>
      <td>fff</td>
    </tr>
    <tr>
      <td>body row 3</td>
      <td rowspan="2">Cells may span rows.</td>
      <td rowspan="2">
        <ul>
          <li>Cells</li>
          <li>can</li>
          <li>contain</li>
          <li>blocks.</li>
        </ul>
      </td>
      <td rowspan="2">
        <ul>
          <li>This is a very long line of text</li>
          <li><a href="http://www.python.org/">Python</a></li>
          <li>b</li>
          <li>c</li>
        </ul>
      </td>
    </tr>
    <tr>
      <td>body row 4</td>
    </tr>
  </tbody>
</table>
^D
[width="100%",cols="17%,16%,15%,52%",options="header",]
|===
|Header 1 |Header 2 |Header 3 |Header 4
|body row 1 |column 2 |column 3 |column 4
|body row 2 2+|Cells may span columns. |fff
|body row 3 .2+|Cells may span rows. .2+a|
* Cells
* can
* contain
* blocks.

.2+a|
* This is a very long line of text
* http://www.python.org/[Python]
* b
* c

|body row 4
|===
```

Header and footer.
AsciiDoc only supports 1 header and 1 footer row.
So for multiple header and/or footer rows all the extra rows become part of the table body.
```
% pandoc -f html -t asciidoc
<table>
  <thead>
    <tr>
      <th colspan="2">Inputs</th>
      <th>Output</th>
    </tr>
    <tr>
      <th>A</th>
      <th>B</th>
      <th>A or B</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>False</td>
      <td>False</td>
      <td>False</td>
    </tr>
    <tr>
      <td>True</td>
      <td>False</td>
      <td>True</td>
    </tr>
    <tr>
      <td>False</td>
      <td>True</td>
      <td>True</td>
    </tr>
    <tr>
      <td>True</td>
      <td>True</td>
      <td>True</td>
    </tr>
  </tbody>
  <tfoot>
    <tr>
      <td>A</td>
      <td>B</td>
      <td>A or B</td>
    </tr>
    <tr>
      <td colspan="2">Inputs</td>
      <td>Output</td>
    </tr>
  </tfoot>
</table>
<table>
  <thead>
    <tr>
      <th colspan="2">Header</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>Body 1-1</td>
      <td>Body 2-1</td>
    </tr>
  </tbody>
  <tfoot>
    <tr>
      <td colspan="2">Footer</td>
    </tr>
  </tfoot>
</table>
^D
[cols=",,",options="header,footer",]
|===
2+|Inputs |Output
|A |B |A or B
|False |False |False
|True |False |True
|False |True |True
|True |True |True
|A |B |A or B
2+|Inputs |Output
|===

[cols=",",options="header,footer",]
|===
2+|Header
|Body 1-1 |Body 2-1
2+|Footer
|===
```

Table without header but with footer rows
```
% pandoc -f html -t asciidoc
<table>
  <colgroup>
    <col style="width: 37%" />
    <col style="width: 37%" />
    <col style="width: 26%" />
  </colgroup>
  <tbody>
    <tr>
      <td>False</td>
      <td>False</td>
      <td>False</td>
    </tr>
    <tr>
      <td>True</td>
      <td>False</td>
      <td>True</td>
    </tr>
    <tr>
      <td>False</td>
      <td>True</td>
      <td>True</td>
    </tr>
    <tr>
      <td>True</td>
      <td>True</td>
      <td>True</td>
    </tr>
  </tbody>
  <tfoot>
    <tr>
      <td>A</td>
      <td>B</td>
      <td>A or B</td>
    </tr>
    <tr>
      <td colspan="2">Inputs</td>
      <td>Output</td>
    </tr>
  </tfoot>
</table>
^D
[width="100%",cols="37%,37%,26%",options="footer",]
|===
|False |False |False
|True |False |True
|False |True |True
|True |True |True
|A |B |A or B
2+|Inputs |Output
|===
```

Adjust row span for multiple header rows
```
% pandoc -f html -t asciidoc
<table style="width: 63%">
  <colgroup>
    <col style="width: 30%" />
    <col style="width: 11%" />
    <col style="width: 11%" />
    <col style="width: 11%" />
  </colgroup>
  <thead>
    <tr>
      <th rowspan="2">Location</th>
      <th colspan="3">Temperature 1961-1990 in degree Celsius</th>
    </tr>
    <tr>
      <th>min</th>
      <th>mean</th>
      <th>max</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>Antarctica</td>
      <td>-89.2</td>
      <td>N/A</td>
      <td>19.8</td>
    </tr>
    <tr>
      <td>Earth</td>
      <td>-89.2</td>
      <td>14</td>
      <td>56.7</td>
    </tr>
  </tbody>
</table>
<table style="width: 63%">
  <colgroup>
    <col style="width: 11%" />
    <col style="width: 11%" />
    <col style="width: 11%" />
    <col style="width: 30%" />
  </colgroup>
  <thead>
    <tr>
      <th colspan="3">Temperature 1961-1990 in degree Celsius</th>
      <th rowspan="2">Location</th>
    </tr>
    <tr>
      <th>min</th>
      <th>mean</th>
      <th>max</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>-89.2</td>
      <td>N/A</td>
      <td>19.8</td>
      <td>Antarctica</td>
    </tr>
    <tr>
      <td>-89.2</td>
      <td>14</td>
      <td>56.7</td>
      <td>Earth</td>
    </tr>
  </tbody>
</table>
<table style="width: 65%">
  <colgroup>
    <col style="width: 11%" />
    <col style="width: 11%" />
    <col style="width: 11%" />
    <col style="width: 18%" />
    <col style="width: 14%" />
  </colgroup>
  <thead>
    <tr>
      <th colspan="3">Temperature 1961-1990 in degree Celsius</th>
      <th rowspan="2">Location</th>
      <th>Extra</th>
    </tr>
    <tr>
      <th>min</th>
      <th>mean</th>
      <th>max</th>
      <th>Extra 2</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>-89.2</td>
      <td>N/A</td>
      <td>19.8</td>
      <td>Antarctica</td>
      <td>Extra 3</td>
    </tr>
    <tr>
      <td>-89.2</td>
      <td>14</td>
      <td>56.7</td>
      <td>Earth</td>
      <td>Extra 4</td>
    </tr>
  </tbody>
</table>
<table>
  <thead>
    <tr>
      <th>Header 1-1</th>
      <th colspan="2" rowspan="2">Header 1-2</th>
    </tr>
    <tr>
      <th>Header 2-1</th>
    </tr>
    <tr>
      <th>Header 3-1</th>
      <th>Header 3-2</th>
      <th>Header 3-3</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td rowspan="2">Body 1-1</td>
      <td colspan="2">Body 1-2</td>
    </tr>
    <tr>
      <td>Body 2-1</td>
      <td>Body 2-2</td>
    </tr>
  </tbody>
</table>
<table>
  <thead>
    <tr>
      <th rowspan="2">Header 1-1</th>
      <th>Header 1-2</th>
      <th rowspan="2">Header 1-3</th>
    </tr>
    <tr>
      <th>Header 2-1</th>
    </tr>
    <tr>
      <th>Header 3-1</th>
      <th>Header 3-2</th>
      <th>Header 3-3</th>
    </tr>
  </thead>
  <tbody></tbody>
</table>
^D
[width="63%",cols="49%,17%,17%,17%",options="header",]
|===
|Location 3+|Temperature 1961-1990 in degree Celsius
| |min |mean |max
|Antarctica |-89.2 |N/A |19.8
|Earth |-89.2 |14 |56.7
|===

[width="63%",cols="19%,17%,17%,47%",options="header",]
|===
3+|Temperature 1961-1990 in degree Celsius |Location
|min |mean |max |
|-89.2 |N/A |19.8 |Antarctica
|-89.2 |14 |56.7 |Earth
|===

[width="65%",cols="20%,16%,16%,27%,21%",options="header",]
|===
3+|Temperature 1961-1990 in degree Celsius |Location |Extra
|min |mean |max | |Extra 2
|-89.2 |N/A |19.8 |Antarctica |Extra 3
|-89.2 |14 |56.7 |Earth |Extra 4
|===

[cols=",,",options="header",]
|===
|Header 1-1 2+|Header 1-2
|Header 2-1 2+|
|Header 3-1 |Header 3-2 |Header 3-3
.2+|Body 1-1 2+|Body 1-2
|Body 2-1 |Body 2-2
|===

[cols=",,",options="header",]
|===
|Header 1-1 |Header 1-2 |Header 1-3
| |Header 2-1 |
|Header 3-1 |Header 3-2 |Header 3-3
|===
```

Adjust row span in multiple footer rows.
```
% pandoc -f html -t asciidoc
<table>
  <colgroup>
    <col style="width: 40%" />
    <col style="width: 40%" />
    <col style="width: 20%" />
  </colgroup>
  <tbody>
    <tr>
      <td>Body 1-1</td>
      <td>Body 1-2</td>
      <td>Body 1-3</td>
    </tr>
  </tbody>
  <tfoot>
    <tr>
      <td colspan="2">Footer 1-1/2</td>
      <td>Footer 1-3</td>
    </tr>
    <tr>
      <td>Footer 2-1</td>
      <td rowspan="3">Span 3</td>
      <td>Footer 2-3</td>
    </tr>
    <tr>
      <td rowspan="2">Span 2</td>
      <td>Footer 3-3</td>
    </tr>
    <tr>
      <td>Footer 4-3</td>
    </tr>
  </tfoot>
</table>
<table>
  <tbody>
    <tr>
      <td>Body 1-1</td>
      <td>Body 1-2</td>
      <td>Body 1-3</td>
      <td>Body 1-4</td>
      <td>Body 1-5</td>
    </tr>
    <tr>
      <td>Body 2-1</td>
      <td>Body 2-2</td>
      <td>Body 2-3</td>
      <td>Body 2-4</td>
      <td>Body 2-5</td>
    </tr>
  </tbody>
  <tfoot>
    <tr>
      <td colspan="3">Footer 1-1/2/3</td>
      <td>Footer 1-4</td>
      <td>Footer 1-5</td>
    </tr>
    <tr>
      <td>Footer 2-1</td>
      <td rowspan="3">Span 3</td>
      <td>Footer 2-3</td>
      <td colspan="2">Footer 2-4/5</td>
    </tr>
    <tr>
      <td rowspan="2">Span 2</td>
      <td colspan="2">Footer 3-3/4</td>
      <td rowspan="2">Span 2</td>
    </tr>
    <tr>
      <td rowspan="3">Span 3</td>
      <td>Footer 4-4</td>
    </tr>
    <tr>
      <td>Footer 5-1</td>
      <td>Footer 5-2</td>
      <td>Footer 5-4</td>
      <td rowspan="2">Span 2</td>
    </tr>
    <tr>
      <td colspan="2">Footer 6-1/2</td>
      <td>Footer 6-4</td>
    </tr>
  </tfoot>
</table>
<table>
  <tbody>
    <tr>
      <td>Body 1</td>
      <td>Body 2</td>
      <td>Body 3</td>
      <td>Body 4</td>
    </tr>
  </tbody>
  <tfoot>
    <tr>
      <td>Footer 1-1</td>
      <td colspan="2" rowspan="3">Span 3</td>
      <td rowspan="2">Span 2</td>
    </tr>
    <tr>
      <td>Footer 2-1</td>
    </tr>
    <tr>
      <td>Footer 3-1</td>
      <td>Footer 3-4</td>
    </tr>
  </tfoot>
</table>
<table>
  <tbody>
    <tr>
      <td>Body 1-1</td>
      <td>Body 1-2</td>
      <td>Body 1-3</td>
      <td>Body 1-4</td>
    </tr>
  </tbody>
  <tfoot>
    <tr>
      <td colspan="2">Footer 1-1/2</td>
      <td rowspan="6">Span 6</td>
      <td>Footer 1-4</td>
    </tr>
    <tr>
      <td rowspan="3">Span 3</td>
      <td>Footer 2-2</td>
      <td>Footer 2-4</td>
    </tr>
    <tr>
      <td>Footer 3-2</td>
      <td>Footer 3-4</td>
    </tr>
    <tr>
      <td>Footer 4-2</td>
      <td>Footer 4-4</td>
    </tr>
    <tr>
      <td>Footer 5-1</td>
      <td>Footer 5-2</td>
      <td rowspan="2">Span 2</td>
    </tr>
    <tr>
      <td colspan="2">Footer 6-1/2</td>
    </tr>
  </tfoot>
</table>
^D
[width="100%",cols="40%,40%,20%",options="footer",]
|===
|Body 1-1 |Body 1-2 |Body 1-3
2+|Footer 1-1/2 |Footer 1-3
|Footer 2-1 .2+|Span 3 |Footer 2-3
|Span 2 |Footer 3-3
| | |Footer 4-3
|===

[cols=",,,,",options="footer",]
|===
|Body 1-1 |Body 1-2 |Body 1-3 |Body 1-4 |Body 1-5
|Body 2-1 |Body 2-2 |Body 2-3 |Body 2-4 |Body 2-5
3+|Footer 1-1/2/3 |Footer 1-4 |Footer 1-5
|Footer 2-1 .3+|Span 3 |Footer 2-3 2+|Footer 2-4/5
.2+|Span 2 2+|Footer 3-3/4 .2+|Span 2
.2+|Span 3 |Footer 4-4
|Footer 5-1 |Footer 5-2 |Footer 5-4 |Span 2
2+|Footer 6-1/2 | |Footer 6-4 |
|===

[cols=",,,",options="footer",]
|===
|Body 1 |Body 2 |Body 3 |Body 4
|Footer 1-1 2.2+|Span 3 .2+|Span 2
|Footer 2-1
|Footer 3-1 2+| |Footer 3-4
|===

[cols=",,,",options="footer",]
|===
|Body 1-1 |Body 1-2 |Body 1-3 |Body 1-4
2+|Footer 1-1/2 .5+|Span 6 |Footer 1-4
.3+|Span 3 |Footer 2-2 |Footer 2-4
|Footer 3-2 |Footer 3-4
|Footer 4-2 |Footer 4-4
|Footer 5-1 |Footer 5-2 |Span 2
2+|Footer 6-1/2 | |
|===
```

Individual cell alignments
```
% pandoc -f native -t asciidoc
[ Table
    ( "" , [] , [] )
    (Caption Nothing [])
    [ ( AlignDefault , ColWidthDefault )
    , ( AlignDefault , ColWidthDefault )
    , ( AlignDefault , ColWidthDefault )
    ]
    (TableHead
       ( "" , [] , [] )
       [ Row
           ( "" , [] , [] )
           [ Cell
               ( "" , [] , [] )
               AlignLeft
               (RowSpan 1)
               (ColSpan 1)
               [ Plain [ Str "Left" , Space , Str "Header" ] ]
           , Cell
               ( "" , [] , [] )
               AlignCenter
               (RowSpan 2)
               (ColSpan 2)
               [ Plain [ Str "Center" , Space , Str "Headers" ] ]
           ]
       , Row
           ( "" , [] , [] )
           [ Cell
               ( "" , [] , [] )
               AlignRight
               (RowSpan 1)
               (ColSpan 1)
               [ Plain [ Str "Right" , Space , Str "Header" ] ]
           ]
       , Row
           ( "" , [] , [] )
           [ Cell
               ( "" , [] , [] )
               AlignCenter
               (RowSpan 1)
               (ColSpan 1)
               [ Plain [ Str "Center" , Space , Str "Header" ] ]
           , Cell
               ( "" , [] , [] )
               AlignRight
               (RowSpan 1)
               (ColSpan 1)
               [ Plain [ Str "Right" , Space , Str "Header" ] ]
           , Cell
               ( "" , [] , [] )
               AlignLeft
               (RowSpan 1)
               (ColSpan 1)
               [ Plain [ Str "Left" , Space , Str "Header" ] ]
           ]
       ])
    [ TableBody
        ( "" , [] , [] )
        (RowHeadColumns 0)
        []
        [ Row
           ( "" , [] , [] )
           [ Cell
               ( "" , [] , [] )
               AlignRight
               (RowSpan 2)
               (ColSpan 1)
               [ Plain [ Str "Right" , Space , Str "Body" ] ]
           , Cell
               ( "" , [] , [] )
               AlignLeft
               (RowSpan 1)
               (ColSpan 2)
               [ Plain [ Str "Left" , Space , Str "Body" ] ]
           ]
        , Row
           ( "" , [] , [] )
           [ Cell
               ( "" , [] , [] )
               AlignCenter
               (RowSpan 1)
               (ColSpan 1)
               [ Plain [ Str "Center" , Space , Str "Body" ] ]
           , Cell
               ( "" , [] , [] )
               AlignRight
               (RowSpan 1)
               (ColSpan 1)
               [ Plain [ Str "Right" , Space , Str "Body" ] ]
           ]
        ]
    ]
    (TableFoot
        ( "" , [] , [] )
        [ Row
            ( "" , [] , [] )
            [ Cell
                ( "" , [] , [] )
                AlignCenter
                (RowSpan 1)
                (ColSpan 3)
                [ Plain [ Str "Center" , Space , Str "Footer" ] ]
            ]
        , Row
             ( "" , [] , [] )
             [ Cell
                 ( "" , [] , [] )
                 AlignLeft
                 (RowSpan 1)
                 (ColSpan 2)
                 [ Plain [ Str "Left" , Space , Str "Footer" ] ]
             , Cell
                 ( "" , [] , [] )
                 AlignCenter
                 (RowSpan 3)
                 (ColSpan 1)
                 [ Plain [ Str "Center" , Space , Str "Footer" ] ]
             ]
         , Row
             ( "" , [] , [] )
             [ Cell
                 ( "" , [] , [] )
                 AlignRight
                 (RowSpan 1)
                 (ColSpan 2)
                 [ Plain [ Str "Right" , Space , Str "Footer" ] ]
             ]
         , Row
             ( "" , [] , [] )
             [ Cell
                 ( "" , [] , [] )
                 AlignCenter
                 (RowSpan 1)
                 (ColSpan 2)
                 [ Plain [ Str "Center" , Space , Str "Footer" ] ]
             ]
        ])
]
^D
[cols=",,",options="header,footer",]
|===
<|Left Header 2+^|Center Headers
>|Right Header 2+|
^|Center Header >|Right Header <|Left Header
.2+>|Right Body 2+<|Left Body
^|Center Body >|Right Body
3+^|Center Footer
2+<|Left Footer .2+^|Center Footer
2+>|Right Footer
2+^|Center Footer |
|===
```

Adjust row span for empty rows and handle empty rows in general
```
% pandoc -f native -t asciidoc
[ Table
    ( "" , [] , [] )
    (Caption Nothing [])
    [ ( AlignDefault , ColWidthDefault )
    , ( AlignDefault , ColWidthDefault )
    , ( AlignDefault , ColWidthDefault )
    ]
    (TableHead
       ( "" , [] , [] )
       [ Row
           ( "" , [] , [] )
           [ Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 2)
               (ColSpan 1)
               [ Plain [ Str "Header" , Space , Str "1-1" ] ]
           , Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 3)
               (ColSpan 1)
               [ Plain [ Str "Span" , Space , Str "3" ] ]
           , Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 2)
               (ColSpan 1)
               [ Plain [ Str "Header" , Space , Str "1-3" ] ]
           ]
       , Row ( "" , [] , [] ) []
       , Row
           ( "" , [] , [] )
           [ Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 1)
               (ColSpan 1)
               [ Plain [ Str "Header" , Space , Str "2-1" ] ]
           , Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 1)
               (ColSpan 1)
               [ Plain [ Str "Header" , Space , Str "2-3" ] ]
           ]
       ])
    [ TableBody
        ( "" , [] , [] )
        (RowHeadColumns 0)
        []
        [ Row
            ( "" , [] , [] )
            [ Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 3)
                (ColSpan 2)
                [ Plain [ Str "Body" , Space , Str "1-1/2" ] ]
            , Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 5)
                (ColSpan 1)
                [ Plain [ Str "Span" , Space , Str "5" ] ]
            ]
        , Row ( "" , [] , [] ) []
        , Row ( "" , [] , [] ) []
        , Row
            ( "" , [] , [] )
            [ Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 1)
                (ColSpan 1)
                [ Plain [ Str "Body" , Space , Str "2-1" ] ]
            , Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 1)
                (ColSpan 1)
                [ Plain [ Str "Body" , Space , Str "2-2" ] ]
            ]
        , Row
            ( "" , [] , [] )
            [ Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 1)
                (ColSpan 1)
                [ Plain [ Str "Body" , Space , Str "3-1" ] ]
            , Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 1)
                (ColSpan 1)
                [ Plain [ Str "Body" , Space , Str "3-2" ] ]
            ]
        , Row ( "" , [] , [] ) []
        ]
    ]
    (TableFoot
       ( "" , [] , [] )
       [ Row
           ( "" , [] , [] )
           [ Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 5)
               (ColSpan 1)
               [ Plain
                   [ Str "Span" , Space , Str "5" ]
               ]
           , Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 1)
               (ColSpan 2)
               [ Plain [ Str "Footer" , Space , Str "1-2" ] ]
           ]
       , Row
           ( "" , [] , [] )
           [ Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 2)
               (ColSpan 2)
               [ Plain
                   [ Str "Span" , Space , Str "2" ]
               ]
           ]
       , Row ( "" , [] , [] ) []
       , Row
           ( "" , [] , [] )
           [ Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 1)
               (ColSpan 2)
               [ Plain [ Str "Footer" , Space , Str "3-2/3" ] ]
           ]
       , Row
           ( "" , [] , [] )
           [ Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 1)
               (ColSpan 2)
               [ Plain [ Str "Footer" , Space , Str "4-2/3" ] ]
           ]
       ])
, Table
    ( "" , [] , [] )
    (Caption Nothing [])
    [ ( AlignDefault , ColWidthDefault )
    , ( AlignDefault , ColWidthDefault )
    , ( AlignDefault , ColWidthDefault )
    ]
    (TableHead ( "" , [] , [] ) [])
    [ TableBody
        ( "" , [] , [] )
        (RowHeadColumns 0)
        []
        [ Row
            ( "" , [] , [] )
            [ Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 1)
                (ColSpan 1)
                [ Plain [ Str "Body" , Space , Str "1-1" ] ]
            , Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 1)
                (ColSpan 1)
                [ Plain [ Str "Body" , Space , Str "1-2" ] ]
            , Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 3)
                (ColSpan 1)
                [ Plain [ Str "Span" , Space , Str "4" ] ]
            ]
        , Row
            ( "" , [] , [] )
            [ Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 5)
                (ColSpan 1)
                [ Plain [ Str "Span" , Space , Str "5" ] ]
            , Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 1)
                (ColSpan 1)
                [ Plain [ Str "Body" , Space , Str "2-2" ] ]
            ]
        , Row
            ( "" , [] , [] ) []
        , Row
            ( "" , [] , [] )
            [ Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 1)
                (ColSpan 1)
                [ Plain [ Str "Body" , Space , Str "3-2" ] ]
            , Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 1)
                (ColSpan 1)
                [ Plain [ Str "Body" , Space , Str "3-3" ] ]
            ]
        , Row
            ( "" , [] , [] )
            [ Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 1)
                (ColSpan 1)
                [ Plain [ Str "Body" , Space , Str "4-2" ] ]
            , Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 1)
                (ColSpan 1)
                [ Plain [ Str "Body" , Space , Str "4-3" ] ]
            ]
        , Row
            ( "" , [] , [] ) []
        , Row
            ( "" , [] , [] ) []
        , Row
            ( "" , [] , [] )
            [ Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 1)
                (ColSpan 1)
                [ Plain [ Str "Body" , Space , Str "6-1" ] ]
            , Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 1)
                (ColSpan 1)
                [ Plain [ Str "Body" , Space , Str "6-2" ] ]
            , Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 1)
                (ColSpan 1)
                [ Plain [ Str "Span" , Space , Str "6-3" ] ]
            ]
        ]
    ]
    (TableFoot
       ( "" , [] , [] )
       [ Row
           ( "" , [] , [] )
           [ Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 1)
               (ColSpan 1)
               [ Plain [ Str "Footer" , Space , Str "1-1" ] ]
           , Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 8)
               (ColSpan 1)
               [ Plain [ Str "Span" , Space , Str "8" ] ]
           , Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 1)
               (ColSpan 1)
               [ Plain [ Str "Footer" , Space , Str "1-3" ] ]
           ]
       , Row
           ( "" , [] , [] )
           [ Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 3)
               (ColSpan 1)
               [ Plain [ Str "Span" , Space , Str "3" ] ]
           , Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 1)
               (ColSpan 1)
               [ Plain [ Str "Footer" , Space , Str "2-3" ] ]
           ]
       , Row
           ( "" , [] , [] )
           [ Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 2)
               (ColSpan 1)
               [ Plain [ Str "Span" , Space , Str "2" ] ]
           ]
       , Row ( "" , [] , [] ) []
       , Row
           ( "" , [] , [] )
           [ Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 1)
               (ColSpan 1)
               [ Plain [ Str "Footer" , Space , Str "4-1" ] ]
           , Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 1)
               (ColSpan 1)
               [ Plain [ Str "Footer" , Space , Str "4-3" ] ]
           ]
       , Row
           ( "" , [] , [] )
           [ Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 1)
               (ColSpan 1)
               [ Plain [ Str "Footer" , Space , Str "5-1" ] ]
           , Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 3)
               (ColSpan 1)
               [ Plain [ Str "Span" , Space , Str "3" ] ]
           ]
       , Row
           ( "" , [] , [] )
           [ Cell
               ( "" , [] , [] )
               AlignDefault
               (RowSpan 2)
               (ColSpan 1)
               [ Plain [ Str "Span" , Space , Str "2" ] ]
           ]
       , Row ( "" , [] , [] ) []
       ])
, Table
    ( "" , [] , [] )
    (Caption Nothing [])
    [ ( AlignDefault , ColWidthDefault )
    , ( AlignDefault , ColWidthDefault )
    , ( AlignDefault , ColWidthDefault )
    ]
    (TableHead ( "" , [] , [] ) [])
    [ TableBody
        ( "" , [] , [] )
        (RowHeadColumns 0)
        []
        [ Row
            ( "" , [] , [] )
            [ Cell
                ( "" , [ "rowspan-cell" ] , [] )
                AlignDefault
                (RowSpan 6)
                (ColSpan 1)
                [ Plain [ Str "Span" , Space , Str "6" ] ]
            , Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 1)
                (ColSpan 1)
                [ Plain [ Str "Body" , Space , Str "1-2" ] ]
            , Cell
                ( "" , [ "rowspan-cell" ] , [] )
                AlignDefault
                (RowSpan 2)
                (ColSpan 1)
                [ Plain [ Str "Span" , Space , Str "2" ] ]
            ]
        , Row
            ( "" , [] , [] )
            [ Cell
                ( "" , [ "rowspan-cell" ] , [] )
                AlignDefault
                (RowSpan 3)
                (ColSpan 1)
                [ Plain [ Str "Span" , Space , Str "3" ] ]
            ]
        , Row
            ( "" , [] , [] )
            [ Cell
                ( "" , [ "rowspan-cell" ] , [] )
                AlignDefault
                (RowSpan 4)
                (ColSpan 1)
                [ Plain [ Str "Span" , Space , Str "4" ] ]
            ]
        , Row ( "" , [] , [] ) []
        , Row
            ( "" , [] , [] )
            [ Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 1)
                (ColSpan 1)
                [ Plain [ Str "Body" , Space , Str "3-2" ] ]
            ]
        , Row
            ( "" , [] , [] )
            [ Cell
                ( "" , [] , [] )
                AlignDefault
                (RowSpan 1)
                (ColSpan 1)
                [ Plain [ Str "Body" , Space , Str "4-2" ] ]
            ]
        , Row ( "" , [] , [] ) []
        , Row ( "" , [] , [] ) []
        ]
    ]
    (TableFoot ( "" , [] , [] ) [])
]
^D
[cols=",,",options="header,footer",]
|===
|Header 1-1 |Span 3 |Header 1-3
|Header 2-1 | |Header 2-3
2+|Body 1-1/2 .3+|Span 5
|Body 2-1 |Body 2-2
|Body 3-1 |Body 3-2
| | |
.3+|Span 5 2+|Footer 1-2
2+|Span 2
2+|Footer 3-2/3
| 2+|Footer 4-2/3
|===

[cols=",,",options="footer",]
|===
|Body 1-1 |Body 1-2 .2+|Span 4
.3+|Span 5 |Body 2-2
|Body 3-2 |Body 3-3
|Body 4-2 |Body 4-3
| | |
|Body 6-1 |Body 6-2 |Span 6-3
|Footer 1-1 .5+|Span 8 |Footer 1-3
.2+|Span 3 |Footer 2-3
|Span 2
|Footer 4-1 |Footer 4-3
|Footer 5-1 |Span 3
|Span 2 | |
|===

[cols=",,",]
|===
.5+|Span 6 |Body 1-2 .2+|Span 2
.2+|Span 3
.3+|Span 4
|Body 3-2
|Body 4-2
| | |
| | |
|===
```
