# CRediT Roles

This document contains tests and examples for enabling
export of roles to JATS. It was added for
[Issue #10152](https://github.com/jgm/pandoc/issues/10152)
and corresponding [Pull Request #10153](https://github.com/jgm/pandoc/pull/10153).

In the first example, we show a fully qualified CRediT role.
An explicit name isn't given, so the CRediT name is used.

```
% pandoc -s -t jats
---
title: CRediT Test
author:
  - name: Max Mustermann
    affiliation: [ 1 ]
    roles:
      - credit: software
        credit-name: Software
        degree: Lead
affiliation:
- id: 1
  name: Silverlight University
---
^D
<?xml version="1.0" encoding="utf-8" ?>
<!DOCTYPE article PUBLIC "-//NLM//DTD JATS (Z39.96) Journal Archiving and Interchange DTD v1.2 20190208//EN"
                  "JATS-archivearticle1.dtd">
<article xmlns:mml="http://www.w3.org/1998/Math/MathML" xmlns:xlink="http://www.w3.org/1999/xlink" dtd-version="1.2" article-type="other">
<front>
<journal-meta>
<journal-id></journal-id>
<journal-title-group>
</journal-title-group>
<issn></issn>
<publisher>
<publisher-name></publisher-name>
</publisher>
</journal-meta>
<article-meta>
<title-group>
<article-title>CRediT Test</article-title>
</title-group>
<contrib-group>
<contrib contrib-type="author">
<string-name>Max Mustermann</string-name>
<role vocab="credit" degree-contribution="Lead"
      vocab-identifier="https://credit.niso.org/"
      vocab-term-identifier="https://credit.niso.org/contributor-roles/software/"
      vocab-term="Software"
>Software</role>
<xref ref-type="aff" rid="aff-1"/>
</contrib>
<aff id="aff-1">
<institution-wrap>
<institution>Silverlight University</institution>
</institution-wrap>
</aff>
</contrib-group>
<permissions>
</permissions>
</article-meta>
</front>
<body>

</body>
<back>
</back>
</article>
```

In the second example, we show a fully qualified CRediT role.
An explicit name is given in a different language.

```
% pandoc -s -t jats
---
title: CRediT Test
author:
  - name: Max Mustermann
    affiliation: [ 1 ]
    roles:
      - credit: software
        credit-name: Software
        degree: Lead
        name: Programas
affiliation:
- id: 1
  name: Silverlight University
---
^D
<?xml version="1.0" encoding="utf-8" ?>
<!DOCTYPE article PUBLIC "-//NLM//DTD JATS (Z39.96) Journal Archiving and Interchange DTD v1.2 20190208//EN"
                  "JATS-archivearticle1.dtd">
<article xmlns:mml="http://www.w3.org/1998/Math/MathML" xmlns:xlink="http://www.w3.org/1999/xlink" dtd-version="1.2" article-type="other">
<front>
<journal-meta>
<journal-id></journal-id>
<journal-title-group>
</journal-title-group>
<issn></issn>
<publisher>
<publisher-name></publisher-name>
</publisher>
</journal-meta>
<article-meta>
<title-group>
<article-title>CRediT Test</article-title>
</title-group>
<contrib-group>
<contrib contrib-type="author">
<string-name>Max Mustermann</string-name>
<role vocab="credit" degree-contribution="Lead"
      vocab-identifier="https://credit.niso.org/"
      vocab-term-identifier="https://credit.niso.org/contributor-roles/software/"
      vocab-term="Software"
>Programas</role>
<xref ref-type="aff" rid="aff-1"/>
</contrib>
<aff id="aff-1">
<institution-wrap>
<institution>Silverlight University</institution>
</institution-wrap>
</aff>
</contrib-group>
<permissions>
</permissions>
</article-meta>
</front>
<body>

</body>
<back>
</back>
</article>
```

In this example, we show a partially qualified CRediT role
that does not have a `degree`:

```
% pandoc -s -t jats
---
title: CRediT Test
author:
  - name: Max Mustermann
    affiliation: [ 1 ]
    roles:
      - credit: software
        credit-name: Software
affiliation:
- id: 1
  name: Silverlight University
---
^D
<?xml version="1.0" encoding="utf-8" ?>
<!DOCTYPE article PUBLIC "-//NLM//DTD JATS (Z39.96) Journal Archiving and Interchange DTD v1.2 20190208//EN"
                  "JATS-archivearticle1.dtd">
<article xmlns:mml="http://www.w3.org/1998/Math/MathML" xmlns:xlink="http://www.w3.org/1999/xlink" dtd-version="1.2" article-type="other">
<front>
<journal-meta>
<journal-id></journal-id>
<journal-title-group>
</journal-title-group>
<issn></issn>
<publisher>
<publisher-name></publisher-name>
</publisher>
</journal-meta>
<article-meta>
<title-group>
<article-title>CRediT Test</article-title>
</title-group>
<contrib-group>
<contrib contrib-type="author">
<string-name>Max Mustermann</string-name>
<role vocab="credit"
      vocab-identifier="https://credit.niso.org/"
      vocab-term-identifier="https://credit.niso.org/contributor-roles/software/"
      vocab-term="Software"
>Software</role>
<xref ref-type="aff" rid="aff-1"/>
</contrib>
<aff id="aff-1">
<institution-wrap>
<institution>Silverlight University</institution>
</institution-wrap>
</aff>
</contrib-group>
<permissions>
</permissions>
</article-meta>
</front>
<body>

</body>
<back>
</back>
</article>
```

In this example, we show a more stripped-down data that requires automatic lookup of the
`credit-name`.

```
% pandoc -s -t jats
---
title: CRediT Test
author:
  - name: Max Mustermann
    affiliation: [ 1 ]
    roles:
      - credit: software
affiliation:
- id: 1
  name: Silverlight University
---
^D
<?xml version="1.0" encoding="utf-8" ?>
<!DOCTYPE article PUBLIC "-//NLM//DTD JATS (Z39.96) Journal Archiving and Interchange DTD v1.2 20190208//EN"
                  "JATS-archivearticle1.dtd">
<article xmlns:mml="http://www.w3.org/1998/Math/MathML" xmlns:xlink="http://www.w3.org/1999/xlink" dtd-version="1.2" article-type="other">
<front>
<journal-meta>
<journal-id></journal-id>
<journal-title-group>
</journal-title-group>
<issn></issn>
<publisher>
<publisher-name></publisher-name>
</publisher>
</journal-meta>
<article-meta>
<title-group>
<article-title>CRediT Test</article-title>
</title-group>
<contrib-group>
<contrib contrib-type="author">
<string-name>Max Mustermann</string-name>
<role vocab="credit"
      vocab-identifier="https://credit.niso.org/"
      vocab-term-identifier="https://credit.niso.org/contributor-roles/software/"
      vocab-term="Software"
>Software</role>
<xref ref-type="aff" rid="aff-1"/>
</contrib>
<aff id="aff-1">
<institution-wrap>
<institution>Silverlight University</institution>
</institution-wrap>
</aff>
</contrib-group>
<permissions>
</permissions>
</article-meta>
</front>
<body>

</body>
<back>
</back>
</article>
```

In this example, we test the correct XML encoding of
the CRediT role [Writing – review & editing](https://credit.niso.org/contributor-roles/writing-review-editing/),
which annoyingly contains an ampersand in its label.

```
% pandoc -s -t jats
---
title: CRediT Test
author:
  - name: Max Mustermann
    affiliation: [ 1 ]
    roles:
      - credit: writing-review-editing
        credit-name: Writing – review & editing
        degree: Lead
affiliation:
- id: 1
  name: Silverlight University
---
^D
<?xml version="1.0" encoding="utf-8" ?>
<!DOCTYPE article PUBLIC "-//NLM//DTD JATS (Z39.96) Journal Archiving and Interchange DTD v1.2 20190208//EN"
                  "JATS-archivearticle1.dtd">
<article xmlns:mml="http://www.w3.org/1998/Math/MathML" xmlns:xlink="http://www.w3.org/1999/xlink" dtd-version="1.2" article-type="other">
<front>
<journal-meta>
<journal-id></journal-id>
<journal-title-group>
</journal-title-group>
<issn></issn>
<publisher>
<publisher-name></publisher-name>
</publisher>
</journal-meta>
<article-meta>
<title-group>
<article-title>CRediT Test</article-title>
</title-group>
<contrib-group>
<contrib contrib-type="author">
<string-name>Max Mustermann</string-name>
<role vocab="credit" degree-contribution="Lead"
      vocab-identifier="https://credit.niso.org/"
      vocab-term-identifier="https://credit.niso.org/contributor-roles/writing-review-editing/"
      vocab-term="Writing – review &amp; editing"
>Writing – review &amp; editing</role>
<xref ref-type="aff" rid="aff-1"/>
</contrib>
<aff id="aff-1">
<institution-wrap>
<institution>Silverlight University</institution>
</institution-wrap>
</aff>
</contrib-group>
<permissions>
</permissions>
</article-meta>
</front>
<body>

</body>
<back>
</back>
</article>
```

In this example, we show a role that isn't qualified with CRediT.

```
% pandoc -s -t jats
---
title: CRediT Test
author:
  - name: Max Mustermann
    affiliation: [ 1 ]
    roles:
      - name: Dolphin Catcher
affiliation:
- id: 1
  name: Silverlight University
---
^D
<?xml version="1.0" encoding="utf-8" ?>
<!DOCTYPE article PUBLIC "-//NLM//DTD JATS (Z39.96) Journal Archiving and Interchange DTD v1.2 20190208//EN"
                  "JATS-archivearticle1.dtd">
<article xmlns:mml="http://www.w3.org/1998/Math/MathML" xmlns:xlink="http://www.w3.org/1999/xlink" dtd-version="1.2" article-type="other">
<front>
<journal-meta>
<journal-id></journal-id>
<journal-title-group>
</journal-title-group>
<issn></issn>
<publisher>
<publisher-name></publisher-name>
</publisher>
</journal-meta>
<article-meta>
<title-group>
<article-title>CRediT Test</article-title>
</title-group>
<contrib-group>
<contrib contrib-type="author">
<string-name>Max Mustermann</string-name>
<role>Dolphin Catcher</role>
<xref ref-type="aff" rid="aff-1"/>
</contrib>
<aff id="aff-1">
<institution-wrap>
<institution>Silverlight University</institution>
</institution-wrap>
</aff>
</contrib-group>
<permissions>
</permissions>
</article-meta>
</front>
<body>

</body>
<back>
</back>
</article>
```

In this example, we show a role that neither has a CRediT identifer,
nor a name, so it's ignored.

```
% pandoc -s -t jats
---
title: CRediT Test
author:
  - name: Max Mustermann
    affiliation: [ 1 ]
    roles:
      - irrelevant-key: Dolphin Catcher
affiliation:
- id: 1
  name: Silverlight University
---
^D
<?xml version="1.0" encoding="utf-8" ?>
<!DOCTYPE article PUBLIC "-//NLM//DTD JATS (Z39.96) Journal Archiving and Interchange DTD v1.2 20190208//EN"
                  "JATS-archivearticle1.dtd">
<article xmlns:mml="http://www.w3.org/1998/Math/MathML" xmlns:xlink="http://www.w3.org/1999/xlink" dtd-version="1.2" article-type="other">
<front>
<journal-meta>
<journal-id></journal-id>
<journal-title-group>
</journal-title-group>
<issn></issn>
<publisher>
<publisher-name></publisher-name>
</publisher>
</journal-meta>
<article-meta>
<title-group>
<article-title>CRediT Test</article-title>
</title-group>
<contrib-group>
<contrib contrib-type="author">
<string-name>Max Mustermann</string-name>
<xref ref-type="aff" rid="aff-1"/>
</contrib>
<aff id="aff-1">
<institution-wrap>
<institution>Silverlight University</institution>
</institution-wrap>
</aff>
</contrib-group>
<permissions>
</permissions>
</article-meta>
</front>
<body>

</body>
<back>
</back>
</article>
```
